/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.IApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ProcessAction;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ProcessGoal;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ResponseBuilder;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaireresponse.QuestionnaireResponseProcessor;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.dstu3.ContainedHelper;
import org.opencds.cqf.fhir.utility.monad.Eithers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyProcessor
implements IApplyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ApplyProcessor.class);
    protected static final List<String> EXCLUDED_EXTENSION_LIST = Arrays.asList("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeCapability", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeRepresentationLevel", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-softwaresystem", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-questionnaire-generate", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-logicDefinition", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-effectiveDataRequirements");
    protected final Repository repository;
    protected final ModelResolver modelResolver;
    protected final ExtensionProcessor extensionProcessor;
    protected final GenerateProcessor generateProcessor;
    protected final PopulateProcessor populateProcessor;
    protected final QuestionnaireResponseProcessor extractProcessor;
    protected final ResponseBuilder processRequest;
    protected final ProcessGoal processGoal;
    protected final ProcessAction processAction;
    protected final org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor;

    public ApplyProcessor(Repository repository, ModelResolver modelResolver, org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor) {
        this.repository = repository;
        this.modelResolver = modelResolver;
        this.activityProcessor = activityProcessor;
        this.extensionProcessor = new ExtensionProcessor();
        this.generateProcessor = new GenerateProcessor(this.repository);
        this.populateProcessor = new PopulateProcessor();
        this.extractProcessor = new QuestionnaireResponseProcessor(this.repository);
        this.processRequest = new ResponseBuilder(this.populateProcessor);
        this.processGoal = new ProcessGoal();
        this.processAction = new ProcessAction(this.repository, this, this.generateProcessor);
    }

    @Override
    public IBaseResource apply(ApplyRequest request) {
        request.setContainResources(true);
        IBaseResource requestOrchestration = this.applyPlanDefinition(request);
        request.resolveOperationOutcome(requestOrchestration);
        IBaseResource carePlan = this.processRequest.generateCarePlan(request, requestOrchestration);
        return this.liftContainedResourcesToParent(request, carePlan);
    }

    @Override
    public IBaseBundle applyR5(ApplyRequest request) {
        this.initApply(request);
        IBaseResource requestOrchestration = this.applyPlanDefinition(request);
        request.resolveOperationOutcome(requestOrchestration);
        IBaseBundle resultBundle = BundleHelper.newBundle((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.getIdElement().getIdPart(), null);
        BundleHelper.addEntry((IBaseBundle)resultBundle, (IBaseBackboneElement)BundleHelper.newEntryWithResource((IBaseResource)requestOrchestration));
        for (IBaseResource resource : request.getRequestResources()) {
            BundleHelper.addEntry((IBaseBundle)resultBundle, (IBaseBackboneElement)BundleHelper.newEntryWithResource((IBaseResource)resource));
        }
        if (!request.getItems((IBase)request.getQuestionnaire()).isEmpty()) {
            BundleHelper.addEntry((IBaseBundle)resultBundle, (IBaseBackboneElement)BundleHelper.newEntryWithResource((IBaseResource)this.populateProcessor.populate(request.toPopulateRequest())));
        }
        return resultBundle;
    }

    protected void initApply(ApplyRequest request) {
        String version;
        IBaseResource questionnaire = this.generateProcessor.generate(request.getPlanDefinition().getIdElement().getIdPart());
        String url = request.resolvePathString((IBase)request.getPlanDefinition(), "url").replace("/PlanDefinition/", "/Questionnaire/");
        if (url != null) {
            request.getModelResolver().setValue((Object)questionnaire, "url", (Object)VersionUtilities.uriTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)url));
        }
        if ((version = request.resolvePathString((IBase)request.getPlanDefinition(), "version")) != null) {
            String subject = request.getSubjectId().getIdPart();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-hh.mm.ss");
            request.getModelResolver().setValue((Object)questionnaire, "version", (Object)VersionUtilities.stringTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)version.concat(String.format("-%s-%s", subject, formatter.format(new Date())))));
        }
        request.setQuestionnaire(questionnaire);
        request.addCqlLibraryExtension();
        this.extractQuestionnaireResponse(request);
    }

    protected void extractQuestionnaireResponse(ApplyRequest request) {
        if (request.getData() == null) {
            return;
        }
        List questionnaireResponses = BundleHelper.getEntryResources((IBaseBundle)request.getData()).stream().filter(r -> r.fhirType().equals("QuestionnaireResponse")).collect(Collectors.toList());
        if (questionnaireResponses != null && !questionnaireResponses.isEmpty()) {
            for (IBaseResource questionnaireResponse : questionnaireResponses) {
                try {
                    IBaseBundle extractBundle = this.extractProcessor.extract(Eithers.forRight((Object)questionnaireResponse), null, request.getParameters(), request.getData(), request.getUseServerData(), request.getLibraryEngine());
                    for (IBaseBackboneElement entry : BundleHelper.getEntry((IBaseBundle)extractBundle)) {
                        BundleHelper.addEntry((IBaseBundle)request.getData(), (IBaseBackboneElement)entry);
                    }
                }
                catch (Exception e) {
                    request.logException(String.format("Error encountered extracting %s: %s", questionnaireResponse.getIdElement().getIdPart(), e.getMessage()));
                }
            }
        }
    }

    public IBaseResource applyPlanDefinition(ApplyRequest request) {
        logger.info("Performing $apply operation on PlanDefinition/{}", (Object)request.getPlanDefinition().getIdElement().getIdPart());
        IBaseResource requestOrchestration = this.processRequest.generateRequestOrchestration(request);
        this.extensionProcessor.processExtensions(request, (IBase)requestOrchestration, (IElement)request.getPlanDefinition(), EXCLUDED_EXTENSION_LIST);
        this.processGoals(request, requestOrchestration);
        HashMap<String, IBaseBackboneElement> metConditions = new HashMap<String, IBaseBackboneElement>();
        for (IBaseBackboneElement action : request.resolvePathList((IBase)request.getPlanDefinition(), "action", IBaseBackboneElement.class)) {
            request.getModelResolver().setValue((Object)requestOrchestration, "action", Collections.singletonList(this.processAction.processAction(request, requestOrchestration, metConditions, action)));
        }
        return Boolean.TRUE.equals(request.getContainResources()) ? this.liftContainedResourcesToParent(request, requestOrchestration) : requestOrchestration;
    }

    public IBaseResource applyActivityDefinition(org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest request) {
        return this.liftContainedResourcesToParent(request, this.activityProcessor.apply(request));
    }

    protected void processGoals(ApplyRequest request, IBaseResource requestOrchestration) {
        List<IBaseBackboneElement> goals = request.resolvePathList((IBase)request.getPlanDefinition(), "goal", IBaseBackboneElement.class);
        for (int i = 0; i < goals.size(); ++i) {
            IBaseResource goal = this.processGoal.convertGoal(request, goals.get(i));
            if (Boolean.TRUE.equals(request.getContainResources())) {
                goalId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)String.valueOf(i + 1));
                goal.setId(goalId);
                request.getModelResolver().setValue((Object)requestOrchestration, "contained", Collections.singletonList(goal));
            } else {
                goalId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)"Goal", (String)String.valueOf(i + 1));
                goal.setId(goalId);
                request.getModelResolver().setValue((Object)requestOrchestration, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(request.getFhirVersion(), ExtensionBuilders.pertainToGoalExtension(goal.getIdElement().getValue()), request.getContainResources())));
            }
            request.getRequestResources().add(goal);
        }
    }

    protected IBaseResource liftContainedResourcesToParent(ICpgRequest request, IBaseResource resource) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return ContainedHelper.liftContainedResourcesToParent((org.hl7.fhir.dstu3.model.DomainResource)((org.hl7.fhir.dstu3.model.DomainResource)resource));
            }
            case R4: {
                return org.opencds.cqf.fhir.utility.r4.ContainedHelper.liftContainedResourcesToParent((DomainResource)((DomainResource)resource));
            }
            case R5: {
                return org.opencds.cqf.fhir.utility.r5.ContainedHelper.liftContainedResourcesToParent((org.hl7.fhir.r5.model.DomainResource)((org.hl7.fhir.r5.model.DomainResource)resource));
            }
        }
        return resource;
    }
}

