/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r5.model.Enumerations;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IGenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ItemGenerator;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateProcessor
implements IGenerateProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(GenerateProcessor.class);
    protected static final String NO_BASE_DEFINITION_ERROR = "An error occurred searching for base definition with url (%s): %s";
    protected final Repository repository;
    protected final FhirVersionEnum fhirVersion;
    protected final ItemGenerator itemGenerator;

    public GenerateProcessor(Repository repository) {
        this.repository = repository;
        this.fhirVersion = repository.fhirContext().getVersion().getVersion();
        this.itemGenerator = new ItemGenerator(repository);
    }

    @Override
    public IBaseResource generate(String id) {
        IBaseResource questionnaire = this.createQuestionnaire();
        if (id != null) {
            IIdType newId = Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)id, (String)"Questionnaire"));
            questionnaire.setId(newId);
        }
        return questionnaire;
    }

    @Override
    public IBaseResource generate(GenerateRequest request, String id) {
        request.setQuestionnaire(this.generate(id == null ? request.getProfile().getIdElement().getIdPart() : id));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-hh.mm.ssZ");
        request.getQuestionnaireAdapter().setVersion(String.format("%s-%s", request.getProfileAdapter().getVersion(), formatter.format(new Date())));
        Pair item = this.generateItem(request);
        request.addQuestionnaireItem((IBaseBackboneElement)item.getLeft());
        if (!((List)item.getRight()).isEmpty()) {
            request.addLaunchContextExtensions((List)item.getRight());
        }
        return request.getQuestionnaire();
    }

    @Override
    public <T extends IBaseExtension<?, ?>> Pair<IBaseBackboneElement, List<T>> generateItem(GenerateRequest request) {
        logger.info("Generating Questionnaire Item for StructureDefinition/{}", (Object)request.getProfile().getIdElement().getIdPart());
        request.setDifferentialElements(this.getElements(request, request.resolvePath((IBase)request.getProfile(), "differential")));
        request.setSnapshotElements(this.getElements(request, this.getProfileSnapshot(request)));
        return this.itemGenerator.generate(request);
    }

    protected <E extends ICompositeType> List<E> getElements(GenerateRequest request, IBase baseElement) {
        return baseElement == null ? null : request.resolvePathList(baseElement, "element").stream().filter(e -> request.resolvePathString((IBase)e, "path").split("\\.").length > 1).map(e -> (ICompositeType)e).collect(Collectors.toList());
    }

    protected IBase getProfileSnapshot(GenerateRequest request) {
        IPrimitiveType baseUrl;
        IBase snapshot = request.resolvePath((IBase)request.getProfile(), "snapshot");
        if (snapshot == null && (baseUrl = request.resolvePath((IBase)request.getProfile(), "baseDefinition", IPrimitiveType.class)) != null) {
            IBaseResource baseProfile = null;
            try {
                baseProfile = SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)baseUrl);
            }
            catch (Exception e) {
                logger.debug(NO_BASE_DEFINITION_ERROR, (Object)baseUrl.getValueAsString(), (Object)e);
            }
            if (baseProfile != null) {
                snapshot = request.resolvePath((IBase)baseProfile, "snapshot");
            }
        }
        return snapshot;
    }

    protected IBaseResource createQuestionnaire() {
        switch (this.fhirVersion) {
            case R4: {
                return new Questionnaire().setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.Questionnaire().setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
        }
        return null;
    }
}

