/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;

public class GenerateRequest
implements IQuestionnaireRequest {
    private final boolean supportedOnly;
    private final boolean requiredOnly;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final IBaseResource profile;
    private String defaultLibraryUrl;
    private IBaseResource questionnaire;
    private IQuestionnaireAdapter questionnaireAdapter;
    private IStructureDefinitionAdapter profileAdapter;
    private List<? extends ICompositeType> differentialElements;
    private List<? extends ICompositeType> snapshotElements;

    public GenerateRequest(IBaseResource profile, boolean supportedOnly, boolean requiredOnly, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)profile, (Object)"expected non-null value for profile");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.profile = profile;
        this.fhirVersion = this.profile.getStructureFhirVersionEnum();
        this.supportedOnly = supportedOnly;
        this.requiredOnly = requiredOnly;
        this.modelResolver = modelResolver;
        this.defaultLibraryUrl = this.resolveDefaultLibraryUrl();
    }

    public IBaseResource getProfile() {
        return this.profile;
    }

    public IStructureDefinitionAdapter getProfileAdapter() {
        if (this.profileAdapter == null) {
            this.profileAdapter = (IStructureDefinitionAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)this.profile);
        }
        return this.profileAdapter;
    }

    @Override
    public IQuestionnaireAdapter getQuestionnaireAdapter() {
        if (this.questionnaireAdapter == null && this.questionnaire != null) {
            this.questionnaireAdapter = (IQuestionnaireAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)this.questionnaire);
        }
        return this.questionnaireAdapter;
    }

    public <E extends ICompositeType> void setDifferentialElements(List<E> elements) {
        this.differentialElements = elements;
    }

    public <E extends ICompositeType> List<E> getDifferentialElements() {
        return this.differentialElements;
    }

    public <E extends ICompositeType> void setSnapshotElements(List<E> elements) {
        this.snapshotElements = elements;
    }

    public <E extends ICompositeType> List<E> getSnapshotElements() {
        return this.snapshotElements;
    }

    public GenerateRequest setQuestionnaire(IBaseResource questionnaire) {
        this.questionnaire = questionnaire;
        return this;
    }

    public Boolean getSupportedOnly() {
        return this.supportedOnly;
    }

    public Boolean getRequiredOnly() {
        return this.requiredOnly;
    }

    public GenerateRequest setDefaultLibraryUrl(String url) {
        this.defaultLibraryUrl = url;
        return this;
    }

    @Override
    public String getOperationName() {
        return "questionnaire";
    }

    @Override
    public IIdType getSubjectId() {
        throw new UnsupportedOperationException("Unimplemented method 'getSubjectId'");
    }

    @Override
    public IBaseBundle getData() {
        throw new UnsupportedOperationException("Unimplemented method 'getData'");
    }

    @Override
    public boolean getUseServerData() {
        throw new UnsupportedOperationException("Unimplemented method 'getUseServerData'");
    }

    @Override
    public IBaseParameters getParameters() {
        throw new UnsupportedOperationException("Unimplemented method 'getParameters'");
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        throw new UnsupportedOperationException("Unimplemented method 'getLibraryEngine'");
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        throw new UnsupportedOperationException("Unimplemented method 'getOperationOutcome'");
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        throw new UnsupportedOperationException("Unimplemented method 'setOperationOutcome'");
    }

    protected final String resolveDefaultLibraryUrl() {
        IBaseExtension libraryExt = this.getExtensions((IBase)this.profile).stream().filter(e -> e.getUrl().equals(this.fhirVersion == FhirVersionEnum.DSTU3 ? "http://hl7.org/fhir/StructureDefinition/cqif-library" : "http://hl7.org/fhir/StructureDefinition/cqf-library")).findFirst().orElse(null);
        return libraryExt == null ? null : (String)((IPrimitiveType)libraryExt.getValue()).getValue();
    }
}

