/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import java.util.Collections;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.r5.ElementProcessor;
import org.opencds.cqf.fhir.utility.CqfExpression;

public interface IElementProcessor {
    public IBaseBackboneElement processElement(GenerateRequest var1, ICompositeType var2, String var3, String var4, CqfExpression var5, Boolean var6);

    public static IElementProcessor createProcessor(Repository repository) {
        switch (repository.fhirContext().getVersion().getVersion()) {
            case R4: {
                return new org.opencds.cqf.fhir.cr.questionnaire.generate.r4.ElementProcessor(repository);
            }
            case R5: {
                return new ElementProcessor(repository);
            }
        }
        return null;
    }

    public static Object createInitial(IOperationRequest request, IBaseDatatype value) {
        switch (request.getFhirVersion()) {
            case R4: {
                return Collections.singletonList(new Questionnaire.QuestionnaireItemInitialComponent().setValue(ItemValueTransformer.transformValueToItem((Type)value)));
            }
            case R5: {
                return Collections.singletonList(new Questionnaire.QuestionnaireItemInitialComponent().setValue(ItemValueTransformer.transformValueToItem((DataType)value)));
            }
        }
        return null;
    }
}

