/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IElementProcessor;
import org.opencds.cqf.fhir.utility.Constants;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(ItemGenerator.class);
    protected static final String NO_PROFILE_ERROR = "No profile defined for input. Unable to generate item.";
    protected static final String ITEM_CREATION_ERROR = "An error occurred during item creation: %s";
    protected static final String CHILD_LINK_ID_FORMAT = "%s.%s";
    protected final Repository repository;
    protected final CqlEngine engine;
    protected final IElementProcessor elementProcessor;
    protected final ExpressionProcessor expressionProcessor;
    protected final ExtensionProcessor extensionProcessor;

    public ItemGenerator(Repository repository) {
        this(repository, IElementProcessor.createProcessor(repository));
    }

    public ItemGenerator(Repository repository, IElementProcessor elementProcessor) {
        this.repository = repository;
        this.engine = Engines.forRepository((Repository)this.repository);
        this.elementProcessor = elementProcessor;
        this.expressionProcessor = new ExpressionProcessor();
        this.extensionProcessor = new ExtensionProcessor();
    }

    public <T extends IBaseExtension<?, ?>> Pair<IBaseBackboneElement, List<T>> generate(GenerateRequest request) {
        String linkId = String.valueOf(request.getItems((IBase)request.getQuestionnaire()).size() + 1);
        try {
            IBaseBackboneElement questionnaireItem = this.createQuestionnaireItem(request, linkId);
            int childCount = request.getItems((IBase)questionnaireItem).size();
            CqfExpression caseFeature = this.getFeatureExpression(request);
            List parentElements = this.getElements(request, null, null);
            this.processElements(request, questionnaireItem, parentElements, childCount, linkId, caseFeature);
            ArrayList launchContextExts = new ArrayList();
            if (caseFeature != null) {
                IBaseExtension itemContextExt = questionnaireItem.addExtension();
                itemContextExt.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext");
                itemContextExt.setValue((IBaseDatatype)caseFeature.toExpressionType(request.getFhirVersion()));
                launchContextExts.add(ExtensionBuilders.buildSdcLaunchContextExt(request.getFhirVersion(), "patient"));
                ILibraryAdapter featureLibrary = request.getAdapterFactory().createLibrary(SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)caseFeature.getLibraryUrl())));
                List<String> inParameters = featureLibrary.getParameter().stream().filter(p -> {
                    String name = request.resolvePathString((IBase)p, "name").toUpperCase();
                    return name.equals("PRACTITIONER") || request.resolvePathString((IBase)p, "use").equals("in") && Arrays.asList(Constants.SDC_QUESTIONNAIRE_LAUNCH_CONTEXT_CODE.values()).stream().map(Object::toString).collect(Collectors.toList()).contains(name);
                }).map(p -> request.resolvePathString((IBase)p, "name").toLowerCase()).collect(Collectors.toList());
                inParameters.forEach(p -> launchContextExts.add(ExtensionBuilders.buildSdcLaunchContextExt(request.getFhirVersion(), p)));
            }
            return new ImmutablePair((Object)questionnaireItem, launchContextExts);
        }
        catch (Exception ex) {
            String message = String.format(ITEM_CREATION_ERROR, ex.getMessage());
            logger.error(message);
            return new ImmutablePair((Object)this.createErrorItem(request, linkId, message), new ArrayList());
        }
    }

    protected CqfExpression getFeatureExpression(GenerateRequest request) {
        CqfExpression expression = this.expressionProcessor.getCqfExpression(request, request.getExtensions((IBase)request.getProfile()), "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression");
        if (expression != null) {
            expression.setName(request.getProfileAdapter().getName());
        }
        return expression;
    }

    protected <E extends ICompositeType> void processElements(GenerateRequest request, IBaseBackboneElement item, List<E> elements, int childCount, String itemLinkId, CqfExpression caseFeature) {
        for (ICompositeType element : elements) {
            String childLinkId = String.format(CHILD_LINK_ID_FORMAT, itemLinkId, ++childCount);
            List<E> childElements = this.getElements(request, request.resolvePathString((IBase)element, "path"), request.resolvePathString((IBase)element, "sliceName"));
            String elementType = this.getElementType(request, element);
            IBaseBackboneElement childItem = this.processElement(request, element, elementType, childLinkId, caseFeature, !childElements.isEmpty());
            if (childElements.isEmpty()) {
                request.getModelResolver().setValue((Object)item, "item", Collections.singletonList(childItem));
                continue;
            }
            this.processElements(request, childItem, childElements, 0, childLinkId, caseFeature);
            request.getModelResolver().setValue((Object)item, "item", Collections.singletonList(childItem));
        }
    }

    protected IBaseBackboneElement processElement(GenerateRequest request, ICompositeType element, String elementType, String childLinkId, CqfExpression caseFeature, Boolean isGroup) {
        try {
            return this.elementProcessor.processElement(request, element, elementType, childLinkId, caseFeature, isGroup);
        }
        catch (Exception ex) {
            String message = String.format(ITEM_CREATION_ERROR, ex.getMessage());
            logger.warn(message);
            return this.createErrorItem(request, childLinkId, message);
        }
    }

    protected <E extends ICompositeType> List<E> getElements(GenerateRequest request, String parentPath, String sliceName) {
        ArrayList elements = new ArrayList();
        if (request.getDifferentialElements() != null) {
            elements.addAll(request.getDifferentialElements().stream().map(e -> e).filter(e -> this.filterElement(request, e, null, parentPath, sliceName, false)).collect(Collectors.toList()));
        }
        if (request.getSnapshotElements() != null) {
            elements.addAll(request.getSnapshotElements().stream().map(e -> e).filter(e -> this.filterElement(request, e, elements, parentPath, sliceName, request.getRequiredOnly())).collect(Collectors.toList()));
        }
        return elements;
    }

    protected <E extends ICompositeType> Boolean filterElement(GenerateRequest request, E element, List<E> existingElements, String parentPath, String sliceName, Boolean requiredOnly) {
        IBaseBooleanDatatype mustSupportElement;
        String path = request.resolvePathString((IBase)element, "path");
        if (this.elementExists(request, existingElements, path)) {
            return false;
        }
        if (request.resolvePath((IBase)element, "slicing") != null) {
            return false;
        }
        if (this.notInPath(path, parentPath)) {
            return false;
        }
        if (sliceName != null && !request.resolvePathString((IBase)element, "id").contains(sliceName)) {
            return false;
        }
        if (Boolean.TRUE.equals(requiredOnly) && !this.isRequiredPath(request, element)) {
            return false;
        }
        if (Boolean.TRUE.equals(request.getSupportedOnly()) && ((mustSupportElement = request.resolvePath((IBase)element, "mustSupport", IBaseBooleanDatatype.class)) == null || ((Boolean)mustSupportElement.getValue()).equals(Boolean.FALSE))) {
            return false;
        }
        return true;
    }

    protected <E extends ICompositeType> boolean elementExists(GenerateRequest request, List<E> existingElements, String path) {
        return existingElements != null && !existingElements.isEmpty() && existingElements.stream().anyMatch(e -> path.equals(request.resolvePathString((IBase)e, "path")));
    }

    protected boolean notInPath(String path, String parentPath) {
        int splitLength;
        String[] pathSplit = path.split("\\.");
        return parentPath == null ? pathSplit.length > 2 : pathSplit.length > (splitLength = parentPath.split("\\.").length + 1) || !path.contains(parentPath + ".");
    }

    protected <E extends ICompositeType> boolean isRequiredPath(GenerateRequest request, E element) {
        IPrimitiveType min = request.resolvePath((IBase)element, "min", IPrimitiveType.class);
        return min != null && (Integer)min.getValue() != 0;
    }

    protected IBaseBackboneElement createErrorItem(GenerateRequest request, String linkId, String errorMessage) {
        return this.createQuestionnaireItemComponent(request, errorMessage, linkId, null, true);
    }

    protected String resolveElementType(GenerateRequest request, ICompositeType element) {
        List<IBase> typeList = request.resolvePathList((IBase)element, "type");
        return typeList.isEmpty() ? null : request.resolvePathString(typeList.get(0), "code");
    }

    protected String getElementType(GenerateRequest request, ICompositeType element) {
        String type = this.resolveElementType(request, element);
        if (type == null) {
            ICompositeType snapshot;
            String path = request.resolvePathString((IBase)element, "path");
            ICompositeType iCompositeType = snapshot = request.getSnapshotElements() == null ? null : (ICompositeType)request.getSnapshotElements().stream().filter(e -> path.equals(request.resolvePathString((IBase)e, "path"))).findFirst().orElse(null);
            if (snapshot != null) {
                type = this.resolveElementType(request, snapshot);
            }
        }
        return type;
    }

    public IBaseBackboneElement createQuestionnaireItem(GenerateRequest request, String linkId) {
        String text = request.getProfileAdapter().hasTitle() ? request.getProfileAdapter().getTitle() : request.getProfileAdapter().getName();
        IBaseBackboneElement item = this.createQuestionnaireItemComponent(request, text, linkId, request.getProfileAdapter().getUrl(), false);
        IBaseExtension extractContext = item.addExtension();
        extractContext.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext");
        extractContext.setValue((IBaseDatatype)VersionUtilities.codeTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)request.getProfileAdapter().getType()));
        return item;
    }

    protected IBaseBackboneElement createQuestionnaireItemComponent(GenerateRequest request, String text, String linkId, String definition, Boolean isDisplay) {
        switch (request.getFhirVersion()) {
            case R4: {
                return new Questionnaire.QuestionnaireItemComponent().setType(Boolean.TRUE.equals(isDisplay) ? Questionnaire.QuestionnaireItemType.DISPLAY : Questionnaire.QuestionnaireItemType.GROUP).setDefinition(definition).setLinkId(linkId).setText(text);
            }
            case R5: {
                return new Questionnaire.QuestionnaireItemComponent().setType(Boolean.TRUE.equals(isDisplay) ? Questionnaire.QuestionnaireItemType.DISPLAY : Questionnaire.QuestionnaireItemType.GROUP).setDefinition(definition).setLinkId(linkId).setText(text);
            }
        }
        return null;
    }
}

