/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItem;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessItemWithContext
extends ProcessItem {
    private static final Logger logger = LoggerFactory.getLogger(ProcessItemWithContext.class);

    public ProcessItemWithContext() {
    }

    public ProcessItemWithContext(ExpressionProcessor expressionProcessor) {
        super(expressionProcessor);
    }

    List<IBaseBackboneElement> processContextItem(PopulateRequest request, IBaseBackboneElement item) {
        String itemLinkId = request.getItemLinkId(item);
        IBaseResource profile = null;
        String definition = request.resolvePathString((IBase)item, "definition");
        if (StringUtils.isNotBlank((CharSequence)definition)) {
            String profileUrl = definition.split("#")[0];
            try {
                profile = SearchHelper.searchRepositoryByCanonical((Repository)request.getRepository(), (IPrimitiveType)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)profileUrl));
            }
            catch (Exception e) {
                String message = String.format("No profile found for definition: %s", profileUrl);
                logger.error(message);
                request.logException(message);
            }
        }
        IStructureDefinitionAdapter profileAdapter = profile == null ? null : (IStructureDefinitionAdapter)request.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)profile);
        CqfExpression contextExpression = this.expressionProcessor.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext");
        List populationContext = this.expressionProcessor.getExpressionResultForItem(request, contextExpression, itemLinkId).stream().map(r -> {
            if (r instanceof IBaseResource) {
                return (IBaseResource)r;
            }
            String message = String.format("Encountered error populating item (%s): Context value is expected to be a resource.", itemLinkId);
            logger.error(message);
            request.logException(message);
            return null;
        }).filter(r -> Objects.nonNull(r)).collect(Collectors.toList());
        if (populationContext.isEmpty()) {
            populationContext.add(null);
        }
        return populationContext.stream().map(context -> this.processPopulationContext(request, item, contextExpression.getName(), (IBaseResource)context, profileAdapter)).collect(Collectors.toList());
    }

    IBaseBackboneElement processPopulationContext(PopulateRequest request, IBaseBackboneElement groupItem, String contextName, IBaseResource context, IStructureDefinitionAdapter profile) {
        IBaseBackboneElement contextItem = this.createResponseItem(request.getFhirVersion(), groupItem);
        request.getItems((IBase)groupItem).forEach(item -> {
            List<IBaseBackboneElement> childItems = request.getItems((IBase)item);
            if (!childItems.isEmpty()) {
                IBaseBackboneElement childGroupItem = this.processPopulationContext(request, (IBaseBackboneElement)item, contextName, context, profile);
                request.getModelResolver().setValue((Object)contextItem, "item", Collections.singletonList(childGroupItem));
            } else {
                try {
                    IBaseBackboneElement processedSubItem = this.createResponseContextItem(request, (IBaseBackboneElement)item, contextName, context, profile);
                    request.getModelResolver().setValue((Object)contextItem, "item", Collections.singletonList(processedSubItem));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    request.logException(e.getMessage());
                }
            }
        });
        return contextItem;
    }

    IBaseBackboneElement createResponseContextItem(PopulateRequest request, IBaseBackboneElement item, String contextName, IBaseResource context, IStructureDefinitionAdapter profile) {
        if (request.resolveRawPath(item, "initial") != null) {
            return this.processItem(request, item);
        }
        IBaseBackboneElement responseItem = this.createResponseItem(request.getFhirVersion(), item);
        String definition = request.resolvePathString((IBase)item, "definition");
        if (StringUtils.isNotBlank((CharSequence)definition) && profile != null) {
            Object pathValue = this.getPathValue(request, context, definition, profile);
            if (pathValue != null) {
                List<IBase> answerValue;
                List<IBase> list = answerValue = pathValue instanceof List ? (List<IBase>)pathValue : Arrays.asList((IBase)pathValue);
                if (answerValue != null && !answerValue.isEmpty()) {
                    this.addAuthorExtension(request, responseItem);
                }
                this.populateAnswer(request, responseItem, answerValue);
            }
        } else {
            IBaseExtension<?, ?> extension = request.getExtensionByUrl((IBase)item, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            if (extension != null) {
                request.addContextParameter("%" + contextName, context);
                this.populateAnswer(request, responseItem, this.getInitialValue(request, item, responseItem));
            }
        }
        return responseItem;
    }

    public Object getPathValue(IOperationRequest request, IBaseResource context, String definition, IStructureDefinitionAdapter profile) {
        Object pathValue = null;
        String elementId = definition.split("#")[1];
        String[] pathSplit = elementId.split("\\.");
        if (pathSplit.length > 2) {
            pathValue = this.getNestedPath(request, context, profile, elementId, pathSplit);
        } else {
            String path = pathSplit[pathSplit.length - 1].replace("[x]", "");
            pathValue = request.resolveRawPath(context, path);
        }
        return pathValue;
    }

    private Object getNestedPath(IOperationRequest request, Object pathValue, IStructureDefinitionAdapter profile, String elementId, String[] pathSplit) {
        String slice = null;
        for (int i = 1; i < pathSplit.length; ++i) {
            if (pathValue instanceof List && !((List)pathValue).isEmpty()) {
                pathValue = slice != null && ((List)pathValue).size() > 1 ? this.getSliceValue(request, profile, pathValue, elementId, pathSplit, slice, i) : ((List)pathValue).get(0);
            }
            slice = pathSplit[i].contains(":") ? pathSplit[i].substring(pathSplit[i].indexOf(":") + 1) : null;
            pathValue = request.resolveRawPath(pathValue, pathSplit[i].replace("[x]", "").replace(":" + slice, ""));
        }
        return pathValue;
    }

    private Object getSliceValue(IOperationRequest request, IStructureDefinitionAdapter profile, Object pathValue, String elementId, String[] pathSplit, String slice, int i) {
        String sliceName = slice;
        int filterIndex = i;
        List pathValues = (List)pathValue;
        List<IBaseBackboneElement> filterElements = profile.getDifferentialElements().stream().filter(e -> {
            String id = request.resolvePathString((IBase)e, "id");
            return !id.equals(elementId) && request.resolveRawPath(e, "sliceName") == null && id.contains(sliceName);
        }).collect(Collectors.toList());
        ArrayList filterValues = new ArrayList();
        filterElements.forEach(e -> {
            String path = request.resolvePathString((IBase)e, "path");
            String elementPath = elementId.replace(":" + sliceName, "");
            String filterPath = path.replace(elementPath.substring(0, elementPath.indexOf(pathSplit[filterIndex])), "");
            IBase filterValue = request.resolvePath((IBase)e, "fixed");
            pathValues.stream().forEach(v -> {
                IBase value = request.resolvePath((IBase)v, filterPath);
                if (value instanceof IPrimitiveType && filterValue instanceof IPrimitiveType) {
                    if (((IPrimitiveType)value).getValueAsString().equals(((IPrimitiveType)filterValue).getValueAsString())) {
                        filterValues.add(v);
                    }
                } else if (value.equals((Object)filterValue)) {
                    filterValues.add(v);
                }
            });
        });
        pathValue = filterValues.isEmpty() ? null : filterValues.get(0);
        return pathValue;
    }
}

