/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import java.util.List;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r5.model.Bundle;
import org.opencds.cqf.fhir.utility.Ids;

public class ResponseBundle {
    public static IBaseBundle createBundleDstu3(String extractId, List<IBaseResource> resources) {
        org.hl7.fhir.dstu3.model.Bundle newBundle = new org.hl7.fhir.dstu3.model.Bundle();
        newBundle.setId(Ids.ensureIdType((String)extractId, (String)"Bundle"));
        newBundle.setType(Bundle.BundleType.TRANSACTION);
        newBundle.getEntry();
        resources.forEach(resource -> {
            Bundle.BundleEntryRequestComponent entryRequest = new Bundle.BundleEntryRequestComponent();
            entryRequest.setMethod(Bundle.HTTPVerb.PUT);
            entryRequest.setUrl(resource.fhirType() + "/" + resource.getIdElement().getIdPart());
            Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
            entry.setResource((Resource)resource);
            entry.setRequest(entryRequest);
            newBundle.addEntry(entry);
        });
        return newBundle;
    }

    public static IBaseBundle createBundleR4(String extractId, List<IBaseResource> resources) {
        Bundle newBundle = new Bundle();
        newBundle.setId(Ids.ensureIdType((String)extractId, (String)"Bundle"));
        newBundle.setType(Bundle.BundleType.TRANSACTION);
        newBundle.getEntry();
        resources.forEach(resource -> {
            Bundle.BundleEntryRequestComponent entryRequest = new Bundle.BundleEntryRequestComponent();
            entryRequest.setMethod(Bundle.HTTPVerb.PUT);
            entryRequest.setUrl(resource.fhirType() + "/" + resource.getIdElement().getIdPart());
            Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
            entry.setResource((org.hl7.fhir.r4.model.Resource)resource);
            entry.setRequest(entryRequest);
            newBundle.addEntry(entry);
        });
        return newBundle;
    }

    public static IBaseBundle createBundleR5(String extractId, List<IBaseResource> resources) {
        org.hl7.fhir.r5.model.Bundle newBundle = new org.hl7.fhir.r5.model.Bundle();
        newBundle.setId(Ids.ensureIdType((String)extractId, (String)"Bundle"));
        newBundle.setType(Bundle.BundleType.TRANSACTION);
        newBundle.getEntry();
        resources.forEach(resource -> {
            Bundle.BundleEntryRequestComponent entryRequest = new Bundle.BundleEntryRequestComponent();
            entryRequest.setMethod(Bundle.HTTPVerb.PUT);
            entryRequest.setUrl(resource.fhirType() + "/" + resource.getIdElement().getIdPart());
            Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
            entry.setResource((org.hl7.fhir.r5.model.Resource)resource);
            entry.setRequest(entryRequest);
            newBundle.addEntry(entry);
        });
        return newBundle;
    }
}

