/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Date;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.r4.ArtifactAssessment;

public class ApproveVisitor
extends BaseKnowledgeArtifactVisitor {
    public ApproveVisitor(Repository repository) {
        super(repository);
    }

    public IBase visit(IKnowledgeArtifactAdapter adapter, IBaseParameters approveParameters) {
        Date currentDate = new Date();
        Date approvalDate = VisitorHelper.getDateParameter("approvalDate", approveParameters).orElse(currentDate);
        String artifactAssessmentType = VisitorHelper.getStringParameter("artifactAssessmentType", approveParameters).orElse("comment");
        Optional<String> artifactAssessmentSummary = VisitorHelper.getStringParameter("artifactAssessmentSummary", approveParameters);
        Optional<String> artifactAssessmentTarget = VisitorHelper.getStringParameter("artifactAssessmentTarget", approveParameters);
        if (artifactAssessmentTarget.isPresent()) {
            if (!Canonicals.getUrl((String)artifactAssessmentTarget.get()).equals(adapter.getUrl())) {
                throw new UnprocessableEntityException("ArtifactCommentTarget URL does not match URL of resource being approved.");
            }
            if (adapter.hasVersion() && !Canonicals.getVersion((String)artifactAssessmentTarget.get()).equals(adapter.getVersion())) {
                throw new UnprocessableEntityException("ArtifactCommentTarget version does not match version of resource being approved.");
            }
        }
        Optional<String> artifactAssessmentRelatedArtifact = VisitorHelper.getStringParameter("artifactAssessmentRelatedArtifact", approveParameters);
        Optional<IBaseReference> artifactAssessmentAuthor = VisitorHelper.getParameter("artifactAssessmentAuthor", approveParameters);
        IBaseBundle returnBundle = BundleHelper.newBundle((FhirVersionEnum)this.fhirVersion(), null, (String)"transaction");
        IBaseResource assessment = this.createApprovalAssessment(adapter.getId(), artifactAssessmentType, artifactAssessmentSummary, artifactAssessmentTarget, artifactAssessmentRelatedArtifact, artifactAssessmentAuthor, adapter.get().getIdElement());
        adapter.setApprovalDate(approvalDate);
        this.setDateElement(adapter, currentDate, this.fhirVersion());
        BundleHelper.addEntry((IBaseBundle)returnBundle, (IBaseBackboneElement)PackageHelper.createEntry((IBaseResource)assessment, (boolean)false));
        BundleHelper.addEntry((IBaseBundle)returnBundle, (IBaseBackboneElement)PackageHelper.createEntry((IBaseResource)adapter.get(), (boolean)true));
        return this.repository.transaction(returnBundle);
    }

    private IBaseResource createApprovalAssessment(IIdType id, String artifactAssessmentType, Optional<String> artifactAssessmentSummary, Optional<String> artifactAssessmentTargetCanonical, Optional<String> artifactAssessmentRelatedArtifact, Optional<IBaseReference> artifactAssessmentAuthor, IIdType artifactTargetReference) throws UnprocessableEntityException {
        try {
            switch (this.fhirVersion()) {
                case DSTU3: {
                    return new org.opencds.cqf.fhir.utility.dstu3.ArtifactAssessment(new Reference(id)).createArtifactComment(new org.hl7.fhir.dstu3.model.CodeType(artifactAssessmentType), new Reference(artifactTargetReference), artifactAssessmentTargetCanonical.map(UriType::new), artifactAssessmentSummary.map(MarkdownType::new), artifactAssessmentRelatedArtifact.map(UriType::new), artifactAssessmentAuthor.map(t -> (Reference)t));
                }
                case R4: {
                    return new ArtifactAssessment(new org.hl7.fhir.r4.model.Reference(id)).createArtifactComment(new CodeType(artifactAssessmentType), new org.hl7.fhir.r4.model.Reference(artifactTargetReference), artifactAssessmentTargetCanonical.map(CanonicalType::new), artifactAssessmentSummary.map(org.hl7.fhir.r4.model.MarkdownType::new), artifactAssessmentRelatedArtifact.map(CanonicalType::new), artifactAssessmentAuthor.map(t -> (org.hl7.fhir.r4.model.Reference)t));
                }
                case R5: {
                    org.hl7.fhir.r5.model.ArtifactAssessment r5ArtifactAssessment = new org.hl7.fhir.r5.model.ArtifactAssessment((DataType)new org.hl7.fhir.r5.model.Reference(id)).setDate(new Date());
                    ArtifactAssessment.ArtifactAssessmentContentComponent content = r5ArtifactAssessment.getContentFirstRep().setSummaryElement((org.hl7.fhir.r5.model.MarkdownType)artifactAssessmentSummary.map(org.hl7.fhir.r5.model.MarkdownType::new).orElse(null)).setAuthor((org.hl7.fhir.r5.model.Reference)artifactAssessmentAuthor.map(t -> (org.hl7.fhir.r5.model.Reference)t).orElse(null)).setInformationType(ArtifactAssessment.ArtifactAssessmentInformationType.fromCode((String)artifactAssessmentType));
                    if (artifactAssessmentTargetCanonical.isPresent()) {
                        content.addRelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.DERIVEDFROM).setResourceElement(artifactAssessmentTargetCanonical.map(org.hl7.fhir.r5.model.CanonicalType::new).get());
                    }
                    if (artifactAssessmentRelatedArtifact.isPresent()) {
                        content.addRelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.CITATION).setResourceElement(artifactAssessmentRelatedArtifact.map(org.hl7.fhir.r5.model.CanonicalType::new).get());
                    }
                    return r5ArtifactAssessment;
                }
            }
            throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", this.fhirVersion().getFhirVersionString()));
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
    }

    private void setDateElement(IKnowledgeArtifactAdapter adapter, Date currentDate, FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                adapter.setDateElement((IPrimitiveType)new DateTimeType(currentDate, TemporalPrecisionEnum.DAY));
                break;
            }
            case R4: {
                adapter.setDateElement((IPrimitiveType)new org.hl7.fhir.r4.model.DateTimeType(currentDate, TemporalPrecisionEnum.DAY));
                break;
            }
            case R5: {
                adapter.setDateElement((IPrimitiveType)new org.hl7.fhir.r5.model.DateTimeType(currentDate, TemporalPrecisionEnum.DAY));
                break;
            }
            default: {
                throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
            }
        }
    }
}

