/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.ValueSets;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandHelper {
    private static final Logger myLogger = LoggerFactory.getLogger(ExpandHelper.class);
    private final Repository repository;
    private final TerminologyServerClient terminologyServerClient;
    public static final List<String> unsupportedParametersToRemove = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("canonical-version")));

    public ExpandHelper(Repository repository, TerminologyServerClient server) {
        this.repository = repository;
        this.terminologyServerClient = server;
    }

    private FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    private static void filterOutUnsupportedParameters(IParametersAdapter parameters) {
        List paramsToSet = parameters.getParameter();
        unsupportedParametersToRemove.forEach(parameterUrl -> {
            while (parameters.getParameter(parameterUrl) != null) {
                paramsToSet.remove(parameters.getParameter(parameterUrl));
                parameters.setParameter(paramsToSet);
            }
        });
    }

    public void expandValueSet(IValueSetAdapter valueSet, IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, Date expansionTimestamp) {
        if (expandedList.contains(valueSet.getUrl())) {
            return;
        }
        ExpandHelper.filterOutUnsupportedParameters(expansionParameters);
        String authoritativeSourceUrl = valueSet.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource")).findFirst().map(url -> ((IPrimitiveType)url.getValue()).getValueAsString()).map(url -> TerminologyServerClient.getAddressBase((String)url, (FhirContext)this.fhirContext())).orElse(null);
        if (terminologyEndpoint.isPresent() && (authoritativeSourceUrl == null || authoritativeSourceUrl.equals(terminologyEndpoint.get().getAddress()))) {
            try {
                IValueSetAdapter expandedValueSet = (IValueSetAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)this.terminologyServerClient.expand(valueSet, terminologyEndpoint.get(), expansionParameters));
                if (!valueSet.hasVersion()) {
                    valueSet.setVersion(expandedValueSet.getVersion());
                }
                valueSet.setExpansion(expandedValueSet.getExpansion());
            }
            catch (Exception ex) {
                throw new UnprocessableEntityException(String.format("Terminology Server expansion failed for ValueSet (%s): %s", valueSet.getId(), ex.getMessage()));
            }
        } else if (valueSet.hasSimpleCompose()) {
            valueSet.naiveExpand();
        } else if (valueSet.hasGroupingCompose()) {
            this.groupExpand(valueSet, expansionParameters, terminologyEndpoint, valueSets, expandedList, this.repository, expansionTimestamp);
        } else if (valueSet.hasCompose()) {
            throw new UnprocessableEntityException("Cannot expand ValueSet without a terminology server: " + String.valueOf(valueSet.getId()));
        }
        expandedList.add(valueSet.getUrl());
    }

    private void groupExpand(IValueSetAdapter valueSet, IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, Repository repository, Date expansionTimestamp) {
        IBaseBackboneElement expansion = this.expandIncludes(valueSet, expansionParameters, terminologyEndpoint, valueSets, expandedList, repository, expansionTimestamp);
        try {
            ValueSets.setExpansionTimestamp((FhirContext)this.fhirContext(), (IBase)expansion, (Date)(expansionTimestamp == null ? new Date() : expansionTimestamp));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        valueSet.setExpansion(expansion);
    }

    private IBaseBackboneElement expandIncludes(IValueSetAdapter valueSet, IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, Repository repository, Date expansionTimestamp) {
        IBaseBackboneElement expansion = valueSet.newExpansion();
        valueSet.getValueSetIncludes().forEach(reference -> {
            String version;
            String url = Canonicals.getUrl((String)reference);
            IValueSetAdapter includedVS = this.getIncludedValueSet(valueSet, terminologyEndpoint, valueSets, repository, (String)reference, url, version = Canonicals.getVersion((String)reference));
            if (includedVS != null) {
                if (!expandedList.contains(url)) {
                    this.expandIncluded(expansionParameters, terminologyEndpoint, valueSets, expandedList, expansionTimestamp, includedVS);
                }
                this.addCodesToExpansion(expansion, includedVS);
                if (includedVS.hasNaiveParameter() && !valueSet.hasNaiveParameter()) {
                    ValueSets.addParameterToExpansion((FhirContext)this.fhirContext(), (IBase)expansion, (IBaseBackboneElement)valueSet.createNaiveParameter());
                }
            } else {
                throw new UnprocessableEntityException("Terminology Server expansion failed for ValueSet '" + valueSet.getUrl() + "' because Child ValueSet '" + reference + "' could not be found. ");
            }
        });
        return expansion;
    }

    private void addCodesToExpansion(IBaseBackboneElement expansion, IValueSetAdapter includedVS) {
        Optional.ofNullable(ValueSets.getCodesInExpansion((FhirContext)this.fhirContext(), (IBaseResource)includedVS.get())).ifPresent(e -> e.forEach(code -> {
            List existingCodes = ValueSets.getCodesInExpansion((FhirContext)this.fhirContext(), (IBase)expansion);
            if (existingCodes == null || existingCodes.stream().noneMatch(expandedCode -> code.getSystem().equals(expandedCode.getSystem()) && code.getCode().equals(expandedCode.getCode()) && (StringUtils.isEmpty((CharSequence)code.getVersion()) || code.getVersion().equals(expandedCode.getVersion())))) {
                try {
                    ValueSets.addCodeToExpansion((FhirContext)this.fhirContext(), (IBase)expansion, (Code)code);
                }
                catch (Exception ex) {
                    throw new UnprocessableEntityException(String.format("Encountered exception attempting to expand ValueSet %s: %s", includedVS.get().getId(), ex.getMessage()));
                }
            }
        }));
    }

    private IValueSetAdapter getIncludedValueSet(IValueSetAdapter valueSet, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, Repository repository, String reference, String url, String version) {
        return valueSets.stream().filter(v -> v.getUrl().equals(url) && (version == null || v.getVersion().equals(version))).findFirst().orElseGet(() -> {
            if (terminologyEndpoint.isPresent()) {
                return this.terminologyServerClient.getResource((IEndpointAdapter)terminologyEndpoint.get(), reference, valueSet.get().getStructureFhirVersionEnum()).map(r -> (IValueSetAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)r)).orElse(null);
            }
            return VisitorHelper.tryGetLatestVersion(reference, repository).map(a -> (IValueSetAdapter)a).orElse(null);
        });
    }

    private void expandIncluded(IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, Date expansionTimestamp, IValueSetAdapter includedVS) {
        IBaseBackboneElement versionParam;
        IParametersAdapter childExpParams = (IParametersAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)expansionParameters.copy());
        IBaseBackboneElement urlParam = childExpParams.getParameter("url");
        if (urlParam != null) {
            int ind = childExpParams.getParameter().indexOf(urlParam);
            childExpParams.getParameter().remove(ind);
            if (includedVS.hasUrl()) {
                childExpParams.addParameter(this.fhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU3 ? Parameters.newUriPart((FhirContext)this.fhirContext(), (String)"url", (String)includedVS.getUrl(), (IBase[])new IBase[0]) : Parameters.newUrlPart((FhirContext)this.fhirContext(), (String)"url", (String)includedVS.getUrl(), (IBase[])new IBase[0]));
            }
        }
        if ((versionParam = childExpParams.getParameter("valueSetVersion")) != null) {
            int ind = childExpParams.getParameter().indexOf(versionParam);
            childExpParams.getParameter().remove(ind);
            if (includedVS.hasVersion()) {
                childExpParams.addParameter(Parameters.newStringPart((FhirContext)this.fhirContext(), (String)"valueSetVersion", (String)includedVS.getVersion(), (IBase[])new IBase[0]));
            }
        }
        this.expandValueSet(includedVS, childExpParams, terminologyEndpoint, valueSets, expandedList, expansionTimestamp);
    }
}

