/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.cr.visitor.ExpandHelper;
import org.opencds.cqf.fhir.cr.visitor.IValueSetExpansionCache;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.cr.visitor.dstu3.ResourceTypes;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageVisitor
extends BaseKnowledgeArtifactVisitor {
    private static final Logger myLogger = LoggerFactory.getLogger(PackageVisitor.class);
    private static final String CANONICAL_TYPE = "canonical";
    private static final String CONFORMANCE_TYPE = "conformance";
    private static final String KNOWLEDGE_ARTIFACT_TYPE = "knowledge";
    private static final String TERMINOLOGY_TYPE = "terminology";
    protected final TerminologyServerClient terminologyServerClient;
    protected final ExpandHelper expandHelper;
    protected Map<String, List<?>> resourceTypes = new HashMap();

    public PackageVisitor(Repository repository) {
        this(repository, null);
    }

    public PackageVisitor(Repository repository, IValueSetExpansionCache cache) {
        super(repository, cache);
        this.terminologyServerClient = new TerminologyServerClient(this.fhirContext());
        this.expandHelper = new ExpandHelper(this.repository, this.terminologyServerClient);
        this.setupResourceTypes();
    }

    public void setupResourceTypes() {
        switch (this.fhirVersion()) {
            case DSTU3: {
                this.resourceTypes.put(CANONICAL_TYPE, ResourceTypes.canonicalResourceTypes);
                this.resourceTypes.put(CONFORMANCE_TYPE, ResourceTypes.conformanceResourceTypes);
                this.resourceTypes.put(KNOWLEDGE_ARTIFACT_TYPE, ResourceTypes.knowledgeArtifactResourceTypes);
                this.resourceTypes.put(TERMINOLOGY_TYPE, ResourceTypes.terminologyResourceTypes);
                break;
            }
            case R4: {
                this.resourceTypes.put(CANONICAL_TYPE, org.opencds.cqf.fhir.cr.visitor.r4.ResourceTypes.canonicalResourceTypes);
                this.resourceTypes.put(CONFORMANCE_TYPE, org.opencds.cqf.fhir.cr.visitor.r4.ResourceTypes.conformanceResourceTypes);
                this.resourceTypes.put(KNOWLEDGE_ARTIFACT_TYPE, org.opencds.cqf.fhir.cr.visitor.r4.ResourceTypes.knowledgeArtifactResourceTypes);
                this.resourceTypes.put(TERMINOLOGY_TYPE, org.opencds.cqf.fhir.cr.visitor.r4.ResourceTypes.terminologyResourceTypes);
                break;
            }
            case R5: {
                this.resourceTypes.put(CANONICAL_TYPE, org.opencds.cqf.fhir.cr.visitor.r5.ResourceTypes.canonicalResourceTypes);
                this.resourceTypes.put(CONFORMANCE_TYPE, org.opencds.cqf.fhir.cr.visitor.r5.ResourceTypes.conformanceResourceTypes);
                this.resourceTypes.put(KNOWLEDGE_ARTIFACT_TYPE, org.opencds.cqf.fhir.cr.visitor.r5.ResourceTypes.knowledgeArtifactResourceTypes);
                this.resourceTypes.put(TERMINOLOGY_TYPE, org.opencds.cqf.fhir.cr.visitor.r5.ResourceTypes.terminologyResourceTypes);
                break;
            }
        }
    }

    public IBase visit(IKnowledgeArtifactAdapter adapter, IBaseParameters packageParameters) {
        FhirVersionEnum fhirVersion = adapter.get().getStructureFhirVersionEnum();
        Optional<String> artifactRoute = VisitorHelper.getStringParameter("artifactRoute", packageParameters);
        Optional<String> endpointUri = VisitorHelper.getStringParameter("endpointUri", packageParameters);
        Optional endpoint = VisitorHelper.getResourceParameter("endpoint", packageParameters);
        Optional<IBaseResource> terminologyEndpoint = VisitorHelper.getResourceParameter("terminologyEndpoint", packageParameters);
        Optional<Boolean> packageOnly = VisitorHelper.getBooleanParameter("packageOnly", packageParameters);
        Optional<Integer> count = VisitorHelper.getIntegerParameter("count", packageParameters);
        Optional<Integer> offset = VisitorHelper.getIntegerParameter("offset", packageParameters);
        List include = VisitorHelper.getStringListParameter("include", packageParameters).orElseGet(() -> new ArrayList());
        List capability = VisitorHelper.getStringListParameter("capability", packageParameters).orElseGet(() -> new ArrayList());
        List artifactVersion = VisitorHelper.getStringListParameter("artifactVersion", packageParameters).orElseGet(() -> new ArrayList());
        List checkArtifactVersion = VisitorHelper.getStringListParameter("checkArtifactVersion", packageParameters).orElseGet(() -> new ArrayList());
        List forceArtifactVersion = VisitorHelper.getStringListParameter("forceArtifactVersion", packageParameters).orElseGet(() -> new ArrayList());
        boolean isPut = VisitorHelper.getBooleanParameter("isPut", packageParameters).orElse(false);
        if (artifactRoute.isPresent() && !StringUtils.isBlank((CharSequence)artifactRoute.get()) && !artifactRoute.get().isEmpty() || endpointUri.isPresent() && !StringUtils.isBlank((CharSequence)endpointUri.get()) && !endpointUri.get().isEmpty() || endpoint.isPresent()) {
            throw new NotImplementedOperationException("This repository is not implementing custom Content and endpoints at this time");
        }
        if (packageOnly.isPresent()) {
            throw new NotImplementedOperationException("This repository is not implementing packageOnly at this time");
        }
        if (count.isPresent() && count.get() < 0) {
            throw new UnprocessableEntityException("'count' must be non-negative");
        }
        ImmutableTriple versionTuple = new ImmutableTriple((Object)artifactVersion, (Object)checkArtifactVersion, (Object)forceArtifactVersion);
        IBaseBundle packagedBundle = BundleHelper.newBundle((FhirVersionEnum)fhirVersion);
        this.addBundleEntry(packagedBundle, isPut, adapter);
        if (include.size() == 1 && include.stream().anyMatch(includedType -> includedType.equals("artifact"))) {
            VisitorHelper.findUnsupportedCapability(adapter, capability);
            VisitorHelper.processCanonicals(adapter, (ImmutableTriple<List<String>, List<String>, List<String>>)versionTuple);
            IBaseBackboneElement entry = PackageHelper.createEntry((IBaseResource)adapter.get(), (boolean)isPut);
            BundleHelper.addEntry((IBaseBundle)packagedBundle, (IBaseBackboneElement)entry);
        } else {
            HashMap<String, IKnowledgeArtifactAdapter> packagedResources = new HashMap<String, IKnowledgeArtifactAdapter>();
            this.recursiveGather(adapter, packagedResources, capability, include, (ImmutableTriple<List<String>, List<String>, List<String>>)versionTuple);
            packagedResources.values().stream().filter(r -> !r.getCanonical().equals(adapter.getCanonical())).forEach(r -> this.addBundleEntry(packagedBundle, isPut, (IKnowledgeArtifactAdapter)r));
            List included = this.findUnsupportedInclude(BundleHelper.getEntry((IBaseBundle)packagedBundle), include, adapter);
            BundleHelper.setEntry((IBaseBundle)packagedBundle, included);
        }
        this.handleValueSets(packagedBundle, terminologyEndpoint);
        this.setCorrectBundleType(count, offset, packagedBundle);
        this.pageBundleBasedOnCountAndOffset(count, offset, packagedBundle);
        return packagedBundle;
    }

    protected void handleValueSets(IBaseBundle packagedBundle, Optional<IBaseResource> terminologyEndpoint) {
        IBaseExtension expansionParamsExtension;
        IBaseParameters expansionParams = Parameters.newParameters((FhirContext)this.fhirContext(), (IBase[])new IBase[0]);
        ILibraryAdapter rootSpecificationLibrary = PackageVisitor.getRootSpecificationLibrary(packagedBundle);
        if (rootSpecificationLibrary != null && (expansionParamsExtension = rootSpecificationLibrary.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters")) != null && expansionParamsExtension.getValue() != null) {
            expansionParams = PackageVisitor.getExpansionParams(rootSpecificationLibrary, ((IBaseReference)expansionParamsExtension.getValue()).getReferenceElement().getValueAsString());
        }
        IParametersAdapter params = (IParametersAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)expansionParams);
        ArrayList expandedList = new ArrayList();
        List<IValueSetAdapter> valueSets = BundleHelper.getEntryResources((IBaseBundle)packagedBundle).stream().filter(r -> r.fhirType().equals("ValueSet")).map(v -> (IValueSetAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)v)).collect(Collectors.toList());
        Optional<IValueSetExpansionCache> expansionCache = this.getExpansionCache();
        Optional<String> expansionParamsHash = expansionCache.map(e -> e.getExpansionParametersHash((IKnowledgeArtifactAdapter)rootSpecificationLibrary).orElse(null));
        ArrayList missingInCache = new ArrayList(valueSets);
        if (expansionCache.isPresent()) {
            long startCache = new Date().getTime();
            valueSets.forEach(v -> {
                IValueSetAdapter cachedExpansion = ((IValueSetExpansionCache)expansionCache.get()).getExpansionForCanonical(v.getCanonical(), expansionParamsHash.orElse(null));
                if (cachedExpansion != null) {
                    v.setExpansion(cachedExpansion.getExpansion());
                    expandedList.add(v.getUrl());
                    missingInCache.remove(v);
                }
            });
            String elapsed = String.valueOf((new Date().getTime() - startCache) / 1000L);
            myLogger.info("retrieved cached ValueSet Expansions in: {}s", (Object)elapsed);
        }
        missingInCache.forEach(valueSet -> {
            String url = valueSet.getUrl();
            long expansionStartTime = new Date().getTime();
            this.expandHelper.expandValueSet((IValueSetAdapter)valueSet, params, terminologyEndpoint.map(e -> (IEndpointAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)e)), valueSets, expandedList, new Date());
            String elapsed = String.valueOf((new Date().getTime() - expansionStartTime) / 1000L);
            myLogger.info("Expanded {} in {}s", (Object)url, (Object)elapsed);
            if (expansionCache.isPresent()) {
                ((IValueSetExpansionCache)expansionCache.get()).addToCache((IValueSetAdapter)valueSet, expansionParamsHash.orElse(null));
            }
        });
    }

    protected void setCorrectBundleType(Optional<Integer> count, Optional<Integer> offset, IBaseBundle bundle) {
        if (count.isPresent() && count.get() == 0) {
            BundleHelper.setBundleType((IBaseBundle)bundle, (String)"searchset");
            BundleHelper.setBundleTotal((IBaseBundle)bundle, (int)BundleHelper.getEntry((IBaseBundle)bundle).size());
        } else if (offset.isPresent() && offset.get() > 0 || count.isPresent() && count.get() < BundleHelper.getEntry((IBaseBundle)bundle).size()) {
            BundleHelper.setBundleType((IBaseBundle)bundle, (String)"collection");
            List removedRequest = BundleHelper.getEntry((IBaseBundle)bundle).stream().map(entry -> {
                BundleHelper.setEntryRequest((FhirVersionEnum)bundle.getStructureFhirVersionEnum(), (IBaseBackboneElement)entry, null);
                return entry;
            }).collect(Collectors.toList());
            BundleHelper.setEntry((IBaseBundle)bundle, removedRequest);
        } else {
            BundleHelper.setBundleType((IBaseBundle)bundle, (String)"transaction");
        }
    }

    protected void pageBundleBasedOnCountAndOffset(Optional<Integer> count, Optional<Integer> offset, IBaseBundle bundle) {
        Integer bundleSize;
        List entries;
        if (offset.isPresent()) {
            entries = BundleHelper.getEntry((IBaseBundle)bundle);
            bundleSize = entries.size();
            if (offset.get() < bundleSize) {
                BundleHelper.setEntry((IBaseBundle)bundle, entries.subList(offset.get(), bundleSize));
            } else {
                BundleHelper.setEntry((IBaseBundle)bundle, Arrays.asList(new IBaseBackboneElement[0]));
            }
        }
        if (count.isPresent()) {
            entries = BundleHelper.getEntry((IBaseBundle)bundle);
            bundleSize = entries.size();
            if (count.get() < bundleSize) {
                BundleHelper.setEntry((IBaseBundle)bundle, entries.subList(0, count.get()));
            }
        }
    }

    protected <T extends IBaseBackboneElement> List<T> findUnsupportedInclude(List<T> entries, List<String> include, IKnowledgeArtifactAdapter adapter) {
        if (include == null || include.isEmpty() || include.stream().anyMatch(includedType -> includedType.equals("all"))) {
            return entries;
        }
        IAdapterFactory adapterFactory = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion());
        ArrayList filteredList = new ArrayList();
        entries.stream().forEach(entry -> {
            if (this.isValidResourceType(include, entry) || this.isExtensionOrProfile(include, adapter, entry)) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("tests")) && (BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), (IBaseBackboneElement)entry).fhirType().equals("Library") && adapterFactory.createCodeableConcept(adapterFactory.createLibrary(BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), (IBaseBackboneElement)entry)).getType()).hasCoding("test-case") || ((IDomainResource)BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), (IBaseBackboneElement)entry)).getExtension().stream().anyMatch(ext -> ext.getUrl().contains("isTestCase") && (Boolean)((IPrimitiveType)ext.getValue()).getValue() != false))) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("examples")) && ((IDomainResource)BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), (IBaseBackboneElement)entry)).getExtension().stream().anyMatch(ext -> ext.getUrl().contains("isExample") && (Boolean)((IPrimitiveType)ext.getValue()).getValue() != false)) {
                filteredList.add(entry);
            }
        });
        return this.getDistinctFilteredEntries(filteredList);
    }

    private <T extends IBaseBackboneElement> boolean isExtensionOrProfile(List<String> include, IKnowledgeArtifactAdapter adapter, T entry) {
        return include.stream().anyMatch(type -> type.equals("extensions") || type.equals("profiles")) && BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), entry).fhirType().equals("StructureDefinition") && adapter.resolvePathString((IBase)BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), entry), "type").equals("Extension");
    }

    protected <T extends IBaseBackboneElement> boolean isValidResourceType(List<String> include, T entry) {
        return include.stream().anyMatch(type -> type.equals(KNOWLEDGE_ARTIFACT_TYPE)) && this.resourceIsOfType(entry, KNOWLEDGE_ARTIFACT_TYPE) || include.stream().anyMatch(type -> type.equals(CANONICAL_TYPE) && this.resourceIsOfType(entry, CANONICAL_TYPE)) || include.stream().anyMatch(type -> type.equals(CONFORMANCE_TYPE) && this.resourceIsOfType(entry, CONFORMANCE_TYPE)) || include.stream().anyMatch(type -> type.equals(TERMINOLOGY_TYPE) && this.resourceIsOfType(entry, TERMINOLOGY_TYPE));
    }

    protected <T extends IBaseBackboneElement> List<T> getDistinctFilteredEntries(List<T> filteredList) {
        ArrayList<IBaseBackboneElement> distinctFilteredEntries = new ArrayList<IBaseBackboneElement>();
        for (IBaseBackboneElement entry : filteredList) {
            if (!distinctFilteredEntries.stream().map(e -> IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter((IDomainResource)BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), (IBaseBackboneElement)e))).noneMatch(existingEntry -> {
                IKnowledgeArtifactAdapter resource = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter((IDomainResource)BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), (IBaseBackboneElement)entry));
                return existingEntry.getUrl().equals(resource.getUrl()) && existingEntry.getVersion().equals(resource.getVersion());
            })) continue;
            distinctFilteredEntries.add(entry);
        }
        return distinctFilteredEntries;
    }

    protected <T extends IBaseBackboneElement> boolean resourceIsOfType(T entry, String type) {
        return this.resourceTypes.get(type).contains(this.getResourceType(BundleHelper.getEntryResource((FhirVersionEnum)this.fhirVersion(), entry)));
    }

    protected Enum getResourceType(IBaseResource resource) {
        switch (this.fhirVersion()) {
            case DSTU3: {
                return ((org.hl7.fhir.dstu3.model.Resource)resource).getResourceType();
            }
            case R4: {
                return ((org.hl7.fhir.r4.model.Resource)resource).getResourceType();
            }
            case R5: {
                return ((Resource)resource).getResourceType();
            }
        }
        return null;
    }

    protected static ILibraryAdapter getRootSpecificationLibrary(IBaseBundle bundle) {
        Optional<ILibraryAdapter> rootSpecLibrary = BundleHelper.getEntryResources((IBaseBundle)bundle).stream().filter(r -> r.fhirType().equals("Library")).map(r -> IAdapterFactory.forFhirVersion((FhirVersionEnum)r.getStructureFhirVersionEnum()).createLibrary(r)).findFirst();
        return rootSpecLibrary.orElse(null);
    }

    protected static IBaseParameters getExpansionParams(ILibraryAdapter rootSpecificationLibrary, String reference) {
        Optional<IBaseResource> expansionParamResource = rootSpecificationLibrary.getContained().stream().filter(contained -> contained.getIdElement().getValue().equals(reference)).findFirst();
        return expansionParamResource.orElse(null);
    }
}

