/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.Period;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.cr.visitor.dstu3.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.cr.visitor.r4.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.cr.visitor.r5.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseVisitor
extends BaseKnowledgeArtifactVisitor {
    private static final String NOT_SUPPORTED = " not supported";
    private static final String ACTIVE = "active";
    private Logger logger = LoggerFactory.getLogger(ReleaseVisitor.class);
    private static final String DEPENDSON = "depends-on";

    public ReleaseVisitor(Repository repository) {
        super(repository);
    }

    public IBase visit(IKnowledgeArtifactAdapter rootAdapter, IBaseParameters operationParameters) {
        Optional<Boolean> latestFromTxServer = VisitorHelper.getBooleanParameter("latestFromTxServer", operationParameters);
        if (latestFromTxServer.isPresent()) {
            throw new NotImplementedOperationException("Support for 'latestFromTxServer' is not yet implemented.");
        }
        String version = VisitorHelper.getStringParameter("version", operationParameters).orElseThrow(() -> new UnprocessableEntityException("Version must be present"));
        String releaseLabel = VisitorHelper.getStringParameter("releaseLabel", operationParameters).orElse("");
        Optional<String> versionBehavior = VisitorHelper.getStringParameter("versionBehavior", operationParameters);
        Optional<String> requireNonExperimental = VisitorHelper.getStringParameter("requireNonExperimental", operationParameters);
        this.checkReleaseVersion(version, versionBehavior);
        this.checkReleasePreconditions(rootAdapter, rootAdapter.getApprovalDate());
        IDomainResource rootLibrary = rootAdapter.get();
        this.updateReleaseLabel((IBaseResource)rootLibrary, releaseLabel);
        String existingVersion = rootAdapter.hasVersion() ? rootAdapter.getVersion().replace("-draft", "") : null;
        String releaseVersion = this.getReleaseVersion(version, versionBehavior, existingVersion, this.fhirVersion()).orElseThrow(() -> new UnprocessableEntityException("Could not resolve a version for the root artifact."));
        ICompositeType rootEffectivePeriod = rootAdapter.getEffectivePeriod();
        if (rootAdapter.getExperimental()) {
            requireNonExperimental = Optional.of("none");
        }
        List<IDomainResource> releasedResources = this.internalRelease(rootAdapter, releaseVersion, rootEffectivePeriod, latestFromTxServer.orElse(false), requireNonExperimental, new Date(), new HashSet<String>());
        ArrayList rootArtifactOriginalDependencies = new ArrayList(rootAdapter.getDependencies());
        List originalDependenciesWithExtensions = rootArtifactOriginalDependencies.stream().filter(dep -> dep.getExtension() != null && !dep.getExtension().isEmpty()).collect(Collectors.toList());
        List noDeps = rootAdapter.getRelatedArtifact();
        noDeps.removeIf(ra -> IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)ra).equalsIgnoreCase(DEPENDSON));
        rootAdapter.setRelatedArtifact(noDeps);
        Optional expansionParameters = rootAdapter.getExpansionParameters();
        List systemVersionParams = expansionParameters.map(p -> VisitorHelper.getStringListParameter("system-version", p).orElse(null)).orElse(new ArrayList());
        List canonicalVersionParams = expansionParameters.map(p -> VisitorHelper.getStringListParameter("canonical-version", p).orElse(null)).orElse(new ArrayList());
        HashSet<String> gatheredResources = new HashSet<String>();
        this.gatherDependencies(rootAdapter, rootAdapter, gatheredResources, releasedResources, new HashMap<String, IDomainResource>(), systemVersionParams, canonicalVersionParams);
        if (rootAdapter.get().fhirType().equals("Library")) {
            ((ILibraryAdapter)rootAdapter).setExpansionParameters(systemVersionParams, canonicalVersionParams);
        }
        List relatedArtifacts = rootAdapter.getRelatedArtifact();
        ArrayList<ICompositeType> distinctResolvedRelatedArtifacts = new ArrayList<ICompositeType>(relatedArtifacts);
        distinctResolvedRelatedArtifacts.clear();
        for (ICompositeType resolvedRelatedArtifact : relatedArtifacts) {
            String relatedArtifactReference = IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)resolvedRelatedArtifact);
            boolean isDistinct = distinctResolvedRelatedArtifacts.stream().noneMatch(distinctRelatedArtifact -> {
                boolean referenceNotInArray = relatedArtifactReference.equals(IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)distinctRelatedArtifact));
                boolean typeMatches = IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)distinctRelatedArtifact).equals(IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)resolvedRelatedArtifact));
                return referenceNotInArray && typeMatches;
            });
            if (!isDistinct) continue;
            distinctResolvedRelatedArtifacts.add(resolvedRelatedArtifact);
            originalDependenciesWithExtensions.stream().filter(originalDep -> Canonicals.getUrl((String)originalDep.getReference()).equals(Canonicals.getUrl((String)relatedArtifactReference)) && IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)resolvedRelatedArtifact).equalsIgnoreCase(DEPENDSON)).findFirst().ifPresent(dep -> {
                ((IBaseHasExtensions)resolvedRelatedArtifact).getExtension().addAll(dep.getExtension());
                originalDependenciesWithExtensions.removeIf(ra -> ra.getReference().equals(relatedArtifactReference));
            });
        }
        IBaseBundle transactionBundle = BundleHelper.newBundle((FhirVersionEnum)this.fhirVersion(), null, (String)"transaction");
        for (IDomainResource artifact : releasedResources) {
            IBaseBackboneElement entry2 = PackageHelper.createEntry((IBaseResource)artifact, (boolean)true);
            BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)entry2);
        }
        this.findArtifactCommentsToUpdate((IBaseResource)rootLibrary, releaseVersion, this.repository).forEach(entry -> BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)entry));
        rootAdapter.setRelatedArtifact(distinctResolvedRelatedArtifacts);
        return this.repository.transaction(transactionBundle);
    }

    private static void updateMetadata(IKnowledgeArtifactAdapter artifactAdapter, String version, ICompositeType rootEffectivePeriod, Date current) {
        artifactAdapter.setDate(current == null ? new Date() : current);
        artifactAdapter.setStatus(ACTIVE);
        artifactAdapter.setVersion(version);
        ReleaseVisitor.propagateEffectivePeriod(rootEffectivePeriod, artifactAdapter);
    }

    private List<IDomainResource> internalRelease(IKnowledgeArtifactAdapter artifactAdapter, String version, ICompositeType rootEffectivePeriod, boolean latestFromTxServer, Optional<String> experimentalBehavior, Date current, Set<String> releasedResources) throws NotImplementedOperationException, ResourceNotFoundException {
        ArrayList<IDomainResource> resourcesToUpdate = new ArrayList<IDomainResource>();
        if (releasedResources.contains(artifactAdapter.getCanonical())) {
            return resourcesToUpdate;
        }
        releasedResources.add(artifactAdapter.getCanonical());
        ReleaseVisitor.updateMetadata(artifactAdapter, version, rootEffectivePeriod, current);
        resourcesToUpdate.add(artifactAdapter.get());
        for (ICompositeType component : artifactAdapter.getComponents()) {
            String preReleaseReference = IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)component);
            if (StringUtils.isBlank((CharSequence)preReleaseReference)) continue;
            Optional<IKnowledgeArtifactAdapter> alreadyUpdated = this.checkIfReferenceInList(preReleaseReference, resourcesToUpdate);
            if (IKnowledgeArtifactAdapter.checkIfRelatedArtifactIsOwned((ICompositeType)component) && !alreadyUpdated.isPresent()) {
                Optional<IKnowledgeArtifactAdapter> latest = VisitorHelper.tryGetLatestVersion(preReleaseReference, this.repository);
                if (latest.isPresent()) {
                    this.checkNonExperimental(latest.get().get(), experimentalBehavior, this.repository);
                    resourcesToUpdate.addAll(this.internalRelease(latest.get(), version, rootEffectivePeriod, latestFromTxServer, experimentalBehavior, current, releasedResources));
                    continue;
                }
                throw new ResourceNotFoundException(String.format("Resource with URL '%s' is Owned by this repository and referenced by resource '%s', but no active version was found on the server.", preReleaseReference, artifactAdapter.getUrl()));
            }
            if (alreadyUpdated.isPresent()) continue;
            VisitorHelper.tryGetLatestVersionWithStatus(preReleaseReference, this.repository, ACTIVE).ifPresent(latestActive -> this.checkNonExperimental(latestActive.get(), experimentalBehavior, this.repository));
        }
        return resourcesToUpdate;
    }

    private void gatherDependencies(IKnowledgeArtifactAdapter rootAdapter, IKnowledgeArtifactAdapter artifactAdapter, Set<String> gatheredResources, List<IDomainResource> releasedResources, Map<String, IDomainResource> alreadyUpdatedDependencies, List<String> systemVersionExpansionParameters, List<String> canonicalVersionExpansionParameters) {
        if (artifactAdapter == null) {
            return;
        }
        if (!gatheredResources.contains(artifactAdapter.getCanonical())) {
            List updatedRelatedArtifacts;
            gatheredResources.add(artifactAdapter.getCanonical());
            for (ICompositeType component : artifactAdapter.getComponents()) {
                Optional<IKnowledgeArtifactAdapter> res;
                String preReleaseReference;
                String updatedReference = preReleaseReference = IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)component);
                if (IKnowledgeArtifactAdapter.checkIfRelatedArtifactIsOwned((ICompositeType)component)) {
                    res = this.checkIfReferenceInList(preReleaseReference, releasedResources);
                    if (!res.isPresent()) {
                        throw new InternalErrorException("Owned resource reference not found during release: " + preReleaseReference);
                    }
                } else {
                    res = VisitorHelper.tryGetLatestVersion(preReleaseReference, this.repository);
                }
                if (res.isPresent()) {
                    if (!alreadyUpdatedDependencies.containsKey(Canonicals.getUrl((String)preReleaseReference))) {
                        alreadyUpdatedDependencies.put(Canonicals.getUrl((String)preReleaseReference), res.get().get());
                    }
                    updatedReference = res.get().hasVersion() ? String.format("%s|%s", res.get().getUrl(), res.get().getVersion()) : res.get().getUrl();
                    IKnowledgeArtifactAdapter.setRelatedArtifactReference((ICompositeType)component, (String)updatedReference, (String)res.get().getDescriptor());
                }
                ICompositeType componentToDependency = IKnowledgeArtifactAdapter.newRelatedArtifact((FhirVersionEnum)this.fhirVersion(), (String)DEPENDSON, (String)updatedReference, (String)res.map(a -> a.getDescriptor()).orElse(null));
                updatedRelatedArtifacts = artifactAdapter.getRelatedArtifact();
                updatedRelatedArtifacts.add(componentToDependency);
                artifactAdapter.setRelatedArtifact(updatedRelatedArtifacts);
            }
            List dependencies = artifactAdapter.getDependencies();
            for (IDependencyInfo dependency : dependencies) {
                IKnowledgeArtifactAdapter dependencyAdapter = null;
                String dependencyUrl = Canonicals.getUrl((String)dependency.getReference());
                if (dependencyUrl == null) {
                    dependencyUrl = dependency.getReference();
                }
                if (alreadyUpdatedDependencies.containsKey(dependencyUrl)) {
                    if (alreadyUpdatedDependencies.get(dependencyUrl) == null) continue;
                    dependencyAdapter = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter(alreadyUpdatedDependencies.get(dependencyUrl));
                    String versionedReference = this.addVersionToReference(dependency.getReference(), dependencyAdapter);
                    dependency.setReference(versionedReference);
                    this.gatherDependencies(rootAdapter, dependencyAdapter, gatheredResources, releasedResources, alreadyUpdatedDependencies, systemVersionExpansionParameters, canonicalVersionExpansionParameters);
                } else {
                    Optional<IKnowledgeArtifactAdapter> maybeAdapter;
                    Class resourceType;
                    Class clazz = resourceType = Canonicals.getResourceType((String)dependency.getReference()) == null ? null : SearchHelper.getResourceType((Repository)this.repository, (IDependencyInfo)dependency);
                    if (StringUtils.isBlank((CharSequence)Canonicals.getVersion((String)dependency.getReference()))) {
                        Optional<Object> expansionParametersVersion = Optional.empty();
                        if (resourceType == null || resourceType.getSimpleName().equals("CodeSystem")) {
                            expansionParametersVersion = systemVersionExpansionParameters.stream().filter(canonical -> !StringUtils.isBlank((CharSequence)Canonicals.getUrl((String)canonical))).filter(canonical -> Canonicals.getUrl((String)canonical).equals(dependency.getReference())).findAny();
                        } else if (resourceType.getSimpleName().equals("ValueSet")) {
                            expansionParametersVersion = canonicalVersionExpansionParameters.stream().filter(canonical -> Canonicals.getUrl((String)canonical).equals(dependency.getReference())).findAny();
                        }
                        expansionParametersVersion.map(Canonicals::getVersion).ifPresent(version -> dependency.setReference(dependency.getReference() + "|" + version));
                    }
                    if (StringUtils.isBlank((CharSequence)Canonicals.getVersion((String)dependency.getReference()))) {
                        String url = dependencyUrl;
                        maybeAdapter = VisitorHelper.tryGetLatestVersionWithStatus(dependency.getReference(), this.repository, ACTIVE).map(adapter -> {
                            String versionedReference = this.addVersionToReference(dependency.getReference(), (IKnowledgeArtifactAdapter)adapter);
                            dependency.setReference(versionedReference);
                            alreadyUpdatedDependencies.put(url, adapter.get());
                            return adapter;
                        });
                    } else {
                        maybeAdapter = Optional.ofNullable(this.getArtifactByCanonical(dependency.getReference(), this.repository));
                    }
                    if (maybeAdapter.isPresent()) {
                        dependencyAdapter = maybeAdapter.get();
                        this.gatherDependencies(rootAdapter, dependencyAdapter, gatheredResources, releasedResources, alreadyUpdatedDependencies, systemVersionExpansionParameters, canonicalVersionExpansionParameters);
                    } else {
                        alreadyUpdatedDependencies.put(dependencyUrl, null);
                    }
                }
                if (artifactAdapter.getUrl().equals(rootAdapter.getUrl())) continue;
                ICompositeType newDep = IKnowledgeArtifactAdapter.newRelatedArtifact((FhirVersionEnum)this.fhirVersion(), (String)DEPENDSON, (String)dependency.getReference(), (String)(dependencyAdapter != null ? dependencyAdapter.getDescriptor() : null));
                updatedRelatedArtifacts = rootAdapter.getRelatedArtifact();
                updatedRelatedArtifacts.add(newDep);
                rootAdapter.setRelatedArtifact(updatedRelatedArtifacts);
            }
        }
    }

    private void checkNonExperimental(IDomainResource resource, Optional<String> experimentalBehavior, Repository repository) throws UnprocessableEntityException {
        if (resource instanceof MetadataResource) {
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.checkNonExperimental((MetadataResource)resource, code, repository, this.logger);
        } else if (resource instanceof org.hl7.fhir.r4.model.MetadataResource) {
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.checkNonExperimental((org.hl7.fhir.r4.model.MetadataResource)resource, code, repository, this.logger);
        } else if (resource instanceof org.hl7.fhir.r5.model.MetadataResource) {
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.checkNonExperimental((org.hl7.fhir.r5.model.MetadataResource)resource, code, repository, this.logger);
        } else {
            throw new UnprocessableEntityException(resource.getClass().getName() + NOT_SUPPORTED);
        }
    }

    private static void propagateEffectivePeriod(ICompositeType rootEffectivePeriod, IKnowledgeArtifactAdapter artifactAdapter) {
        if (rootEffectivePeriod instanceof org.hl7.fhir.dstu3.model.Period) {
            org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.propagateEffectivePeriod((org.hl7.fhir.dstu3.model.Period)rootEffectivePeriod, artifactAdapter);
        } else if (rootEffectivePeriod instanceof Period) {
            org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.propagateEffectivePeriod((Period)rootEffectivePeriod, artifactAdapter);
        } else if (rootEffectivePeriod instanceof org.hl7.fhir.r5.model.Period) {
            org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.propagateEffectivePeriod((org.hl7.fhir.r5.model.Period)rootEffectivePeriod, artifactAdapter);
        } else {
            throw new UnprocessableEntityException(rootEffectivePeriod.getClass().getName() + NOT_SUPPORTED);
        }
    }

    private IKnowledgeArtifactAdapter getArtifactByCanonical(String inputReference, Repository repository) {
        List matchingResources = VisitorHelper.getMetadataResourcesFromBundle(SearchHelper.searchRepositoryByCanonicalWithPaging((Repository)repository, (String)inputReference)).stream().map(r -> IAdapterFactory.forFhirVersion((FhirVersionEnum)r.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(r)).collect(Collectors.toList());
        if (matchingResources.isEmpty()) {
            return null;
        }
        if (matchingResources.size() == 1) {
            return (IKnowledgeArtifactAdapter)matchingResources.get(0);
        }
        this.logger.info("Multiple resources found matching {}", (Object)inputReference);
        return (IKnowledgeArtifactAdapter)matchingResources.get(0);
    }

    private String addVersionToReference(String inputReference, IKnowledgeArtifactAdapter adapter) {
        if (adapter != null) {
            return adapter.getCanonical();
        }
        return inputReference;
    }

    private Optional<String> getReleaseVersion(String version, Optional<String> versionBehavior, String existingVersion, FhirVersionEnum fhirVersion) throws UnprocessableEntityException {
        switch (fhirVersion) {
            case DSTU3: {
                return org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
            case R4: {
                return org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
            case R5: {
                return org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
        }
        throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
    }

    private void updateReleaseLabel(IBaseResource artifact, String releaseLabel) throws IllegalArgumentException {
        if (artifact instanceof MetadataResource) {
            org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.updateReleaseLabel((MetadataResource)artifact, releaseLabel);
        } else if (artifact instanceof org.hl7.fhir.r4.model.MetadataResource) {
            org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.updateReleaseLabel((org.hl7.fhir.r4.model.MetadataResource)artifact, releaseLabel);
        } else if (artifact instanceof org.hl7.fhir.r5.model.MetadataResource) {
            org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.updateReleaseLabel((org.hl7.fhir.r5.model.MetadataResource)artifact, releaseLabel);
        } else {
            throw new UnprocessableEntityException(artifact.getClass().getName() + NOT_SUPPORTED);
        }
    }

    private Optional<IKnowledgeArtifactAdapter> checkIfReferenceInList(String referenceToCheck, List<IDomainResource> resourceList) {
        for (IDomainResource resource : resourceList) {
            String currentResourceURL;
            String referenceURL = Canonicals.getUrl((String)referenceToCheck);
            if (!referenceURL.equals(currentResourceURL = IAdapterFactory.forFhirVersion((FhirVersionEnum)resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(resource).getUrl())) continue;
            return Optional.of(resource).map(res -> IAdapterFactory.forFhirVersion((FhirVersionEnum)res.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(res));
        }
        return Optional.empty();
    }

    private void checkReleasePreconditions(IKnowledgeArtifactAdapter artifact, Date approvalDate) throws PreconditionFailedException {
        if (artifact == null) {
            throw new ResourceNotFoundException("Resource not found.");
        }
        if (!artifact.getStatus().equals("draft")) {
            throw new PreconditionFailedException(String.format("Resource with ID: '%s' does not have a status of 'draft'.", artifact.get().getIdElement().getIdPart()));
        }
        if (approvalDate == null) {
            throw new PreconditionFailedException("The artifact must be approved (indicated by approvalDate) before it is eligible for release.");
        }
        if (approvalDate.before(artifact.getDate())) {
            throw new PreconditionFailedException(String.format("The artifact was approved on '%s', but was last modified on '%s'. An approval must be provided after the most-recent update.", approvalDate, artifact.getDate()));
        }
    }

    private void checkReleaseVersion(String version, Optional<String> versionBehavior) throws UnprocessableEntityException {
        if (!versionBehavior.isPresent()) {
            throw new UnprocessableEntityException("'versionBehavior' must be provided as an argument to the $release operation. Valid values are 'default', 'check', 'force'.");
        }
        this.checkVersionValidSemver(version);
    }

    private void checkVersionValidSemver(String version) throws UnprocessableEntityException {
        if (version == null || version.isEmpty()) {
            throw new UnprocessableEntityException("The version argument is required");
        }
        if (version.contains("draft")) {
            throw new UnprocessableEntityException("The version cannot contain 'draft'");
        }
        if (version.contains("/") || version.contains("\\") || version.contains("|")) {
            throw new UnprocessableEntityException("The version contains illegal characters");
        }
        Pattern pattern = Pattern.compile("^(\\d+\\.)(\\d+\\.)(\\*|\\d+)$", 2);
        Matcher matcher = pattern.matcher(version);
        boolean matchFound = matcher.find();
        if (!matchFound) {
            throw new UnprocessableEntityException("The version must be in the format MAJOR.MINOR.PATCH");
        }
    }
}

