/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor.dstu3;

import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Basic;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.visitor.dstu3.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.cr.visitor.dstu3.CRMIReleaseVersionBehavior;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.dstu3.ArtifactAssessment;
import org.slf4j.Logger;

public class ReleaseVisitor {
    private ReleaseVisitor() {
    }

    public static void checkNonExperimental(MetadataResource resource, CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes experimentalBehavior, Repository repository, Logger log) throws UnprocessableEntityException {
        if (CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL != experimentalBehavior && CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NONE != experimentalBehavior) {
            String nonExperimentalError = String.format("Root artifact is not Experimental, but references an Experimental resource with URL '%s'.", resource.getUrl());
            if (CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.WARN == experimentalBehavior && resource.getExperimental()) {
                log.warn(nonExperimentalError);
            } else if (CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.ERROR == experimentalBehavior && resource.getExperimental()) {
                throw new UnprocessableEntityException(nonExperimentalError);
            }
            if (resource.getResourceType().equals((Object)ResourceType.ValueSet)) {
                ValueSet valueSet = (ValueSet)resource;
                List valueSets = valueSet.getCompose().getInclude().stream().flatMap(include -> include.getValueSet().stream()).collect(Collectors.toList());
                for (IPrimitiveType value : valueSets) {
                    IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)SearchHelper.searchRepositoryByCanonicalWithPaging((Repository)repository, (IPrimitiveType)value)).ifPresent(childVs -> ReleaseVisitor.checkNonExperimental((MetadataResource)childVs, experimentalBehavior, repository, log));
                }
            }
        }
    }

    public static void propagateEffectivePeriod(Period rootEffectivePeriod, IKnowledgeArtifactAdapter artifactAdapter) {
        Period effectivePeriod = (Period)artifactAdapter.getEffectivePeriod();
        if (rootEffectivePeriod != null && (rootEffectivePeriod.hasStart() || rootEffectivePeriod.hasEnd()) && (effectivePeriod == null || !effectivePeriod.hasStart() && !effectivePeriod.hasEnd())) {
            artifactAdapter.setEffectivePeriod((ICompositeType)rootEffectivePeriod);
        }
    }

    public static void updateReleaseLabel(MetadataResource artifact, String releaseLabel) throws IllegalArgumentException {
        if (releaseLabel != null) {
            Extension releaseLabelExtension = artifact.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel");
            if (releaseLabelExtension == null) {
                releaseLabelExtension = new Extension("http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel");
                artifact.addExtension(releaseLabelExtension);
            }
            releaseLabelExtension.setValue((Type)new StringType(releaseLabel));
        }
    }

    public static Bundle searchArtifactAssessmentForArtifact(IIdType reference, Repository repository) {
        HashMap searchParams = new HashMap();
        ArrayList<ReferenceParam> urlList = new ArrayList<ReferenceParam>();
        urlList.add(new ReferenceParam(reference));
        searchParams.put("artifact", urlList);
        return (Bundle)repository.search(Bundle.class, Basic.class, searchParams);
    }

    public static Optional<String> getReleaseVersion(String version, Optional<String> versionBehavior, String existingVersion) {
        Optional<String> releaseVersion = Optional.empty();
        if (versionBehavior.isPresent()) {
            CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes versionBehaviorCode = CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.fromCode(versionBehavior.get());
            if (existingVersion == null || existingVersion.isEmpty() || StringUtils.isBlank((CharSequence)existingVersion)) {
                return Optional.ofNullable(version);
            }
            String replaceDraftInExisting = existingVersion.replace("-draft", "");
            if (CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.DEFAULT == versionBehaviorCode) {
                releaseVersion = replaceDraftInExisting != null && !replaceDraftInExisting.isEmpty() ? Optional.of(replaceDraftInExisting) : Optional.ofNullable(version);
            } else if (CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.FORCE == versionBehaviorCode) {
                releaseVersion = Optional.ofNullable(version);
            } else if (CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.CHECK == versionBehaviorCode && !replaceDraftInExisting.equals(version)) {
                throw new UnprocessableEntityException(String.format("versionBehavior specified is 'check' and the version provided ('%s') does not match the version currently specified on the root artifact ('%s').", version, existingVersion));
            }
        }
        return releaseVersion;
    }

    public static List<Bundle.BundleEntryComponent> findArtifactCommentsToUpdate(MetadataResource rootArtifact, String releaseVersion, Repository repository) {
        ArrayList<Bundle.BundleEntryComponent> returnEntries = new ArrayList<Bundle.BundleEntryComponent>();
        ReleaseVisitor.searchArtifactAssessmentForArtifact((IIdType)rootArtifact.getIdElement(), repository).getEntry().stream().map(entry -> {
            try {
                return (Basic)entry.getResource();
            }
            catch (Exception e) {
                return null;
            }
        }).filter(entry -> entry != null).map(basic -> {
            ArtifactAssessment extensionsTransferred = new ArtifactAssessment();
            extensionsTransferred.setExtension(basic.getExtension());
            extensionsTransferred.setId(basic.getClass().getSimpleName() + "/" + basic.getIdPart());
            return extensionsTransferred;
        }).forEach(artifactComment -> {
            artifactComment.setDerivedFromContentRelatedArtifact(String.format("%s|%s", rootArtifact.getUrl(), releaseVersion));
            returnEntries.add((Bundle.BundleEntryComponent)PackageHelper.createEntry((IBaseResource)artifactComment, (boolean)true));
        });
        return returnEntries;
    }
}

