/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor.r4;

import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PrimitiveType;

public class CRMIReleaseExperimentalBehavior {

    public static class CRMIReleaseExperimentalBehaviorCodesEnumFactory
    implements EnumFactory<CRMIReleaseExperimentalBehaviorCodes> {
        public CRMIReleaseExperimentalBehaviorCodes fromCode(String codeString) throws IllegalArgumentException {
            return CRMIReleaseExperimentalBehaviorCodes.fromCode(codeString);
        }

        public Enumeration<CRMIReleaseExperimentalBehaviorCodes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration((EnumFactory)this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (StringUtils.isBlank((CharSequence)codeString)) {
                return null;
            }
            return new Enumeration((EnumFactory)this, (Enum)CRMIReleaseExperimentalBehaviorCodes.fromCode(codeString));
        }

        public String toCode(CRMIReleaseExperimentalBehaviorCodes code) {
            return code.toCode();
        }

        public String toSystem(CRMIReleaseExperimentalBehaviorCodes code) {
            return code.getSystem();
        }
    }

    public static enum CRMIReleaseExperimentalBehaviorCodes {
        ERROR,
        WARN,
        NONE,
        NULL;


        public static CRMIReleaseExperimentalBehaviorCodes fromCode(String codeString) throws FHIRException {
            if (StringUtils.isBlank((CharSequence)codeString)) {
                return null;
            }
            switch (codeString) {
                case "error": {
                    return ERROR;
                }
                case "warn": {
                    return WARN;
                }
                case "none": {
                    return NONE;
                }
            }
            throw new IllegalArgumentException("Unknown CRMIReleaseExperimentalBehaviorCode '" + codeString + "'");
        }

        public String toCode() {
            switch (this.ordinal()) {
                case 0: {
                    return "error";
                }
                case 1: {
                    return "warn";
                }
                case 2: {
                    return "none";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    return "http://hl7.org/fhir/uv/crmi/CodeSystem/crmi-release-experimental-behavior-codes";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this.ordinal()) {
                case 0: {
                    return "The repository should throw an error if a specification which is not Experimental references Experimental components.";
                }
                case 1: {
                    return "The repository should warn if a specification which is not Experimental references Experimental components.";
                }
                case 2: {
                    return "The repository does not need to consider the state of Experimental.";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this.ordinal()) {
                case 0: {
                    return "Error";
                }
                case 1: {
                    return "Warn";
                }
                case 2: {
                    return "None";
                }
                case 3: {
                    return null;
                }
            }
            return "?";
        }
    }
}

