/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers;

import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.IRequestResolverFactory;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.CommunicationRequestResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.CommunicationResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.DiagnosticReportResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.MedicationRequestResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.ProcedureRequestResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.ProcedureResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.ReferralRequestResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.SupplyRequestResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3.TaskResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dstu3ResolverFactory
implements IRequestResolverFactory {
    private static final Logger logger = LoggerFactory.getLogger(Dstu3ResolverFactory.class);

    @Override
    public BaseRequestResourceResolver create(IBaseResource baseActivityDefinition) {
        ActivityDefinition activityDefinition = (ActivityDefinition)baseActivityDefinition;
        String kind = activityDefinition.hasExtension("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-activity-kind") ? activityDefinition.getExtensionByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-activity-kind").getValueAsPrimitive().getValueAsString() : activityDefinition.getKind().toCode();
        ResourceType resourceType = ResourceType.fromCode((String)kind);
        switch (resourceType) {
            case Communication: {
                return new CommunicationResolver(activityDefinition);
            }
            case CommunicationRequest: {
                return new CommunicationRequestResolver(activityDefinition);
            }
            case DiagnosticReport: {
                return new DiagnosticReportResolver(activityDefinition);
            }
            case MedicationRequest: {
                return new MedicationRequestResolver(activityDefinition);
            }
            case Procedure: {
                return new ProcedureResolver(activityDefinition);
            }
            case ProcedureRequest: {
                return new ProcedureRequestResolver(activityDefinition);
            }
            case ReferralRequest: {
                return new ReferralRequestResolver(activityDefinition);
            }
            case SupplyRequest: {
                return new SupplyRequestResolver(activityDefinition);
            }
            case Task: {
                return new TaskResolver(activityDefinition);
            }
        }
        String msg = "Unsupported activity type: " + resourceType.name();
        logger.error(msg);
        throw new FHIRException(msg);
    }
}

