/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import java.util.Collections;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class ProcedureRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public ProcedureRequestResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public ProcedureRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        ProcedureRequest procedureRequest = new ProcedureRequest();
        procedureRequest.setStatus(ProcedureRequest.ProcedureRequestStatus.DRAFT);
        procedureRequest.setIntent(ProcedureRequest.ProcedureRequestIntent.PROPOSAL);
        procedureRequest.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            procedureRequest.setDefinition(Collections.singletonList(new Reference(this.activityDefinition.getUrl())));
        }
        if (request.hasPractitionerId().booleanValue()) {
            procedureRequest.setRequester(new ProcedureRequest.ProcedureRequestRequesterComponent().setAgent(new Reference(request.getPractitionerId())));
        } else if (request.hasOrganizationId().booleanValue()) {
            procedureRequest.setRequester(new ProcedureRequest.ProcedureRequestRequesterComponent().setAgent(new Reference(request.getOrganizationId())));
        }
        if (this.activityDefinition.hasCode()) {
            procedureRequest.setCode(this.activityDefinition.getCode());
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException(String.format("Missing required ActivityDefinition.code property for %s", "Procedure"));
        }
        if (this.activityDefinition.hasBodySite()) {
            procedureRequest.setBodySite(this.activityDefinition.getBodySite());
        }
        return procedureRequest;
    }
}

