/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.cpg.r4;

import java.util.HashSet;
import java.util.List;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.cpg.CqlExecutionProcessor;
import org.opencds.cqf.fhir.utility.r4.Parameters;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class R4LibraryEvaluationService {
    protected Repository repository;
    protected EvaluationSettings evaluationSettings;

    public R4LibraryEvaluationService(Repository repository, EvaluationSettings evaluationSettings) {
        this.repository = repository;
        this.evaluationSettings = evaluationSettings;
    }

    public org.hl7.fhir.r4.model.Parameters evaluate(IdType id, String subject, List<String> expression, org.hl7.fhir.r4.model.Parameters parameters, Bundle data, List<org.hl7.fhir.r4.model.Parameters> prefetchData, Endpoint dataEndpoint, Endpoint contentEndpoint, Endpoint terminologyEndpoint) {
        CqlExecutionProcessor baseCqlExecutionProcessor = new CqlExecutionProcessor();
        if (prefetchData != null) {
            return Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[]{Parameters.part((String)"invalid parameters", (Resource)((OperationOutcome)baseCqlExecutionProcessor.createIssue("warning", "prefetchData is not yet supported", this.repository)), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])});
        }
        if (contentEndpoint != null) {
            this.repository = Repositories.proxy((Repository)this.repository, (Boolean)true, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
        }
        LibraryEngine libraryEngine = new LibraryEngine(this.repository, this.evaluationSettings);
        Library library = (Library)this.repository.read(Library.class, (IIdType)id);
        CqlEngine engine = Engines.forRepositoryAndSettings((EvaluationSettings)this.evaluationSettings, (Repository)this.repository, (IBaseBundle)data);
        LibraryManager libraryManager = engine.getEnvironment().getLibraryManager();
        VersionedIdentifier libraryIdentifier = baseCqlExecutionProcessor.resolveLibraryIdentifier(null, (IBaseResource)library, libraryManager);
        HashSet<String> expressionSet = null;
        if (expression != null) {
            expressionSet = new HashSet<String>(expression);
        }
        try {
            return (org.hl7.fhir.r4.model.Parameters)libraryEngine.evaluate(libraryIdentifier, subject, (IBaseParameters)parameters, (IBaseBundle)data, expressionSet);
        }
        catch (Exception e) {
            return Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[]{Parameters.part((String)"evaluation error", (Resource)((OperationOutcome)baseCqlExecutionProcessor.createIssue("error", e.getMessage(), this.repository)), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])});
        }
    }
}

