/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.cr.measure.common.CodeDef;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierComponentDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;

public class R4MeasureDefBuilder
implements MeasureDefBuilder<Measure> {
    @Override
    public MeasureDef build(Measure measure) {
        this.checkId((Resource)measure);
        ArrayList<SdeDef> sdes = new ArrayList<SdeDef>();
        for (Measure.MeasureSupplementalDataComponent s : measure.getSupplementalData()) {
            this.checkId((Element)s);
            SdeDef sdeDef = new SdeDef(s.getId(), this.conceptToConceptDef(s.getCode()), s.getCriteria().getExpression());
            sdes.add(sdeDef);
        }
        MeasureScoring measureLevelMeasureScoring = this.getMeasureScoring(measure);
        ArrayList<GroupDef> groups = new ArrayList<GroupDef>();
        HashMap<GroupDef, MeasureScoring> groupMeasureScoring = new HashMap<GroupDef, MeasureScoring>();
        for (Measure.MeasureGroupComponent group : measure.getGroup()) {
            Object pop2;
            MeasureScoring groupMeasureScoringCode = measureLevelMeasureScoring;
            Extension scoringExtension = group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring");
            if (scoringExtension != null) {
                CodeableConcept coding = (CodeableConcept)group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring").getValue();
                groupMeasureScoringCode = MeasureScoring.fromCode(coding.getCodingFirstRep().getCode());
            }
            if (groupMeasureScoringCode == null) {
                throw new IllegalArgumentException("MeasureScoring must be specified on Group or Measure");
            }
            ArrayList<PopulationDef> populations = new ArrayList<PopulationDef>();
            for (Object pop2 : group.getPopulation()) {
                this.checkId((Element)pop2);
                MeasurePopulationType populationType = MeasurePopulationType.fromCode(pop2.getCode().getCodingFirstRep().getCode());
                populations.add(new PopulationDef(pop2.getId(), this.conceptToConceptDef(pop2.getCode()), populationType, pop2.getCriteria().getExpression()));
            }
            if (this.checkPopulationForCode(populations, MeasurePopulationType.TOTALDENOMINATOR) == null) {
                populations.add(new PopulationDef("totalDenominator", this.totalConceptDefCreator(MeasurePopulationType.TOTALDENOMINATOR), MeasurePopulationType.TOTALDENOMINATOR, null));
            }
            if (this.checkPopulationForCode(populations, MeasurePopulationType.TOTALNUMERATOR) == null) {
                populations.add(new PopulationDef("totalNumerator", this.totalConceptDefCreator(MeasurePopulationType.TOTALNUMERATOR), MeasurePopulationType.TOTALNUMERATOR, null));
            }
            ArrayList<StratifierDef> stratifiers = new ArrayList<StratifierDef>();
            pop2 = group.getStratifier().iterator();
            while (pop2.hasNext()) {
                Measure.MeasureGroupStratifierComponent mgsc = (Measure.MeasureGroupStratifierComponent)pop2.next();
                this.checkId((Element)mgsc);
                ArrayList<StratifierComponentDef> components = new ArrayList<StratifierComponentDef>();
                for (Measure.MeasureGroupStratifierComponentComponent scc : mgsc.getComponent()) {
                    this.checkId((Element)scc);
                    StratifierComponentDef scd = new StratifierComponentDef(scc.getId(), this.conceptToConceptDef(scc.getCode()), scc.hasCriteria() ? scc.getCriteria().getExpression() : null);
                    components.add(scd);
                }
                StratifierDef stratifierDef = new StratifierDef(mgsc.getId(), this.conceptToConceptDef(mgsc.getCode()), mgsc.getCriteria().getExpression(), components);
                stratifiers.add(stratifierDef);
            }
            GroupDef groupDef = new GroupDef(group.getId(), this.conceptToConceptDef(group.getCode()), stratifiers, populations);
            groups.add(groupDef);
            groupMeasureScoring.put(groupDef, groupMeasureScoringCode);
        }
        return new MeasureDef(measure.getId(), measure.getUrl(), measure.getVersion(), groupMeasureScoring, groups, sdes);
    }

    private PopulationDef checkPopulationForCode(List<PopulationDef> populations, MeasurePopulationType measurePopType) {
        return populations.stream().filter(e -> e.code().first().code().equals(measurePopType.toCode())).findAny().orElse(null);
    }

    private ConceptDef totalConceptDefCreator(MeasurePopulationType measurePopulationType) {
        return new ConceptDef(Collections.singletonList(new CodeDef(measurePopulationType.getSystem(), measurePopulationType.toCode())), null);
    }

    private ConceptDef conceptToConceptDef(CodeableConcept codeable) {
        if (codeable == null) {
            return null;
        }
        ArrayList<CodeDef> codes = new ArrayList<CodeDef>();
        for (Coding c : codeable.getCoding()) {
            codes.add(this.codeToCodeDef(c));
        }
        return new ConceptDef(codes, codeable.getText());
    }

    private CodeDef codeToCodeDef(Coding coding) {
        return new CodeDef(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay());
    }

    private void checkId(Element e) {
        if (e.getId() == null || StringUtils.isBlank((CharSequence)e.getId())) {
            throw new NullPointerException("id is required on all Elements of type: " + e.fhirType());
        }
    }

    private void checkId(Resource r) {
        if (r.getId() == null || StringUtils.isBlank((CharSequence)r.getId())) {
            throw new NullPointerException("id is required on all Resources of type: " + r.fhirType());
        }
    }

    private MeasureScoring getMeasureScoring(Measure measure) {
        return MeasureScoring.fromCode(measure.getScoring().getCodingFirstRep().getCode());
    }
}

