/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.util.BundleBuilder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.constant.MeasureReportConstants;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureProcessor;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4MeasureService {
    private static final Logger log = LoggerFactory.getLogger(R4MeasureService.class);
    private final Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    public static final List<ContactDetail> CQI_CONTACTDETAIL = Collections.singletonList(new ContactDetail().addTelecom(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.URL).setValue("http://www.hl7.org/Special/committees/cqi/index.cfm")));
    public static final List<CodeableConcept> US_JURISDICTION_CODING = Collections.singletonList(new CodeableConcept().addCoding(new Coding("urn:iso:std:iso:3166", "US", "United States of America")));
    public static final SearchParameter SUPPLEMENTAL_DATA_SEARCHPARAMETER = (SearchParameter)new SearchParameter().setUrl("http://hl7.org/fhir/us/davinci-deqm/SearchParameter/measurereport-supplemental-data").setVersion("0.1.0").setName("DEQMMeasureReportSupplementalData").setStatus(Enumerations.PublicationStatus.ACTIVE).setDate((Date)MeasureReportConstants.MEASUREREPORT_SUPPLEMENTALDATA_SEARCHPARAMETER_DEFINITION_DATE).setPublisher("HL7 International - Clinical Quality Information Work Group").setContact(CQI_CONTACTDETAIL).setDescription(String.format("Returns resources (supplemental data) from references on extensions on the MeasureReport with urls matching %s.", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setJurisdiction(US_JURISDICTION_CODING).addBase("MeasureReport").setCode("supplemental-data").setType(Enumerations.SearchParamType.REFERENCE).setExpression(String.format("MeasureReport.extension('%s').value", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpath(String.format("f:MeasureReport/f:extension[@url='%s'].value", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpathUsage(SearchParameter.XPathUsageType.NORMAL).setTitle("Supplemental Data").setId("deqm-measurereport-supplemental-data");

    public R4MeasureService(Repository repository, MeasureEvaluationOptions measureEvaluationOptions) {
        this.repository = repository;
        this.measureEvaluationOptions = measureEvaluationOptions;
    }

    public MeasureReport evaluate(Either3<CanonicalType, IdType, Measure> measure, String periodStart, String periodEnd, String reportType, String subjectId, String lastReceivedOn, Endpoint contentEndpoint, Endpoint terminologyEndpoint, Endpoint dataEndpoint, Bundle additionalData, Parameters parameters, String productLine, String practitioner) {
        Repository repo = Repositories.proxy((Repository)this.repository, (Boolean)true, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
        R4MeasureProcessor processor = new R4MeasureProcessor(repo, this.measureEvaluationOptions, new R4RepositorySubjectProvider());
        this.ensureSupplementalDataElementSearchParameter();
        MeasureReport measureReport = null;
        if (StringUtils.isNotBlank((CharSequence)practitioner)) {
            if (practitioner.indexOf("/") == -1) {
                practitioner = "Practitioner/".concat(practitioner);
            }
            subjectId = practitioner;
        }
        measureReport = processor.evaluateMeasure(measure, periodStart, periodEnd, reportType, Collections.singletonList(subjectId), (IBaseBundle)additionalData, parameters);
        this.addProductLineExtension(measureReport, productLine);
        if ((StringUtils.isNotBlank((CharSequence)practitioner) || StringUtils.isNotBlank((CharSequence)subjectId)) && measureReport.getType().name().equals(MeasureReportType.SUMMARY.name())) {
            if (StringUtils.isNotBlank((CharSequence)practitioner)) {
                measureReport.setSubject(new Reference(practitioner));
            } else {
                measureReport.setSubject(new Reference(subjectId));
            }
        }
        return measureReport;
    }

    private void addProductLineExtension(MeasureReport measureReport, String productLine) {
        if (productLine != null) {
            Extension ext = new Extension();
            ext.setUrl("http://hl7.org/fhir/us/cqframework/cqfmeasures/StructureDefinition/cqfm-productLine");
            ext.setValue((Type)new StringType(productLine));
            measureReport.addExtension(ext);
        }
    }

    protected void ensureSupplementalDataElementSearchParameter() {
        BundleBuilder builder = new BundleBuilder(this.repository.fhirContext());
        builder.addTransactionCreateEntry((IBaseResource)SUPPLEMENTAL_DATA_SEARCHPARAMETER).conditional("code=supplemental-data");
        try {
            this.repository.transaction(builder.getBundle());
        }
        catch (NotImplementedOperationException e) {
            log.warn("Error creating supplemental data search parameter. This may be due to the server not supporting transactions.", (Throwable)e);
        }
    }
}

