/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.utility.Ids;

public class ActionResolver {
    public void resolveAction(ApplyRequest request, IBaseResource requestOrchestration, IBaseResource result, IBaseBackboneElement action) {
        if ("Task".equals(result.fhirType())) {
            this.resolveTask(request, requestOrchestration, result, action);
        }
    }

    protected void resolveTask(ApplyRequest request, IBaseResource requestGroup, IBaseResource task, IBaseBackboneElement action) {
        String actionId = request.resolvePathString((IBase)action, "id");
        if (actionId != null) {
            IIdType taskId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)task.fhirType(), (String)actionId);
            task.setId(taskId);
        }
        request.getModelResolver().setValue((Object)task, "basedOn", Collections.singletonList(ExtensionBuilders.buildReference(request.getFhirVersion(), requestGroup.getIdElement().getValue())));
    }
}

