/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.model.api.IElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.cr.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IElementProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(ItemGenerator.class);
    protected static final String NO_PROFILE_ERROR = "No profile defined for input. Unable to generate item.";
    protected static final String ITEM_CREATION_ERROR = "An error occurred during item creation: %s";
    protected static final String CHILD_LINK_ID_FORMAT = "%s.%s";
    public static final List<String> INPUT_EXTENSION_LIST = Arrays.asList("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-input-description", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression");
    protected final Repository repository;
    protected final IElementProcessor elementProcessor;
    protected final ExpressionProcessor expressionProcessor;
    protected final ExtensionProcessor extensionProcessor;

    public ItemGenerator(Repository repository) {
        this(repository, IElementProcessor.createProcessor(repository));
    }

    public ItemGenerator(Repository repository, IElementProcessor elementProcessor) {
        this.repository = repository;
        this.elementProcessor = elementProcessor;
        this.expressionProcessor = new ExpressionProcessor();
        this.extensionProcessor = new ExtensionProcessor();
    }

    public IBaseBackboneElement generate(GenerateRequest request) {
        String linkId = String.valueOf(request.getItems((IBase)request.getQuestionnaire()).size() + 1);
        try {
            IBaseBackboneElement questionnaireItem = this.createQuestionnaireItem(request, linkId);
            this.processExtensions(request, questionnaireItem);
            int childCount = request.getItems((IBase)questionnaireItem).size();
            IBaseResource caseFeature = this.getCaseFeature(request, linkId);
            List parentElements = this.getElements(request, null, null);
            this.processElements(request, questionnaireItem, parentElements, childCount, linkId, caseFeature);
            return questionnaireItem;
        }
        catch (Exception ex) {
            String message = String.format(ITEM_CREATION_ERROR, ex.getMessage());
            logger.error(message);
            return this.createErrorItem(request, linkId, message);
        }
    }

    protected void processExtensions(GenerateRequest request, IBaseBackboneElement questionnaireItem) {
        this.extensionProcessor.processExtensionsInList(request, (IBase)questionnaireItem, (IElement)request.getProfile(), INPUT_EXTENSION_LIST);
    }

    protected IBaseResource getCaseFeature(GenerateRequest request, String itemLinkId) {
        IBaseResource caseFeature = null;
        CqfExpression featureExpression = this.getFeatureExpression(request);
        if (featureExpression != null) {
            try {
                IBase result;
                List<IBase> results = this.getFeatureExpressionResults(request, featureExpression, itemLinkId);
                IBase iBase = result = results == null || results.isEmpty() ? null : results.get(0);
                if (result instanceof IBaseResource) {
                    caseFeature = (IBaseResource)result;
                }
            }
            catch (ResolveExpressionException e) {
                logger.error(e.getMessage());
            }
        }
        return caseFeature;
    }

    protected CqfExpression getFeatureExpression(GenerateRequest request) {
        return this.expressionProcessor.getCqfExpression(request, request.getExtensions((IBase)request.getProfile()), "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression");
    }

    protected List<IBase> getFeatureExpressionResults(GenerateRequest request, CqfExpression featureExpression, String itemLinkId) throws ResolveExpressionException {
        return this.expressionProcessor.getExpressionResultForItem(request, featureExpression, itemLinkId);
    }

    protected <E extends ICompositeType> void processElements(GenerateRequest request, IBaseBackboneElement item, List<E> elements, int childCount, String itemLinkId, IBaseResource caseFeature) {
        for (ICompositeType element : elements) {
            String childLinkId = String.format(CHILD_LINK_ID_FORMAT, itemLinkId, ++childCount);
            List<E> childElements = this.getElements(request, request.resolvePathString((IBase)element, "path"), request.resolvePathString((IBase)element, "sliceName"));
            String elementType = this.getElementType(request, element);
            IBaseBackboneElement childItem = this.processElement(request, element, elementType, childLinkId, caseFeature, !childElements.isEmpty());
            if (childElements.isEmpty()) {
                request.getModelResolver().setValue((Object)item, "item", Collections.singletonList(childItem));
                continue;
            }
            this.processElements(request, childItem, childElements, 0, childLinkId, caseFeature);
            request.getModelResolver().setValue((Object)item, "item", Collections.singletonList(childItem));
        }
    }

    protected IBaseBackboneElement processElement(GenerateRequest request, ICompositeType element, String elementType, String childLinkId, IBaseResource caseFeature, Boolean isGroup) {
        try {
            return this.elementProcessor.processElement(request, element, elementType, childLinkId, caseFeature, isGroup);
        }
        catch (Exception ex) {
            String message = String.format(ITEM_CREATION_ERROR, ex.getMessage());
            logger.warn(message);
            return this.createErrorItem(request, childLinkId, message);
        }
    }

    protected <E extends ICompositeType> List<E> getElements(GenerateRequest request, String parentPath, String sliceName) {
        ArrayList elements = new ArrayList();
        if (request.getDifferentialElements() != null) {
            elements.addAll(request.getDifferentialElements().stream().map(e -> e).filter(e -> this.filterElement(request, e, null, parentPath, sliceName, false)).collect(Collectors.toList()));
        }
        if (request.getSnapshotElements() != null) {
            elements.addAll(request.getSnapshotElements().stream().map(e -> e).filter(e -> this.filterElement(request, e, elements, parentPath, sliceName, request.getRequiredOnly())).collect(Collectors.toList()));
        }
        return elements;
    }

    protected <E extends ICompositeType> Boolean filterElement(GenerateRequest request, E element, List<E> existingElements, String parentPath, String sliceName, Boolean requiredOnly) {
        IBaseBooleanDatatype mustSupportElement;
        IPrimitiveType min;
        int splitLength;
        String path = request.resolvePathString((IBase)element, "path");
        if (existingElements != null && !existingElements.isEmpty() && existingElements.stream().anyMatch(e -> path.equals(request.resolvePathString((IBase)e, "path")))) {
            return false;
        }
        if (request.resolvePath((IBase)element, "slicing") != null) {
            return false;
        }
        String[] pathSplit = path.split("\\.");
        if (parentPath == null ? pathSplit.length > 2 : pathSplit.length > (splitLength = parentPath.split("\\.").length + 1) || !path.contains(parentPath + ".")) {
            return false;
        }
        if (sliceName != null && !request.resolvePathString((IBase)element, "id").contains(sliceName)) {
            return false;
        }
        if (requiredOnly.booleanValue() && ((min = request.resolvePath((IBase)element, "min", IPrimitiveType.class)) == null || (Integer)min.getValue() == 0)) {
            return false;
        }
        if (request.getSupportedOnly().booleanValue() && ((mustSupportElement = request.resolvePath((IBase)element, "mustSupport", IBaseBooleanDatatype.class)) == null || ((Boolean)mustSupportElement.getValue()).equals(Boolean.FALSE))) {
            return false;
        }
        return true;
    }

    protected IBaseBackboneElement createErrorItem(GenerateRequest request, String linkId, String errorMessage) {
        return this.createQuestionnaireItemComponent(request, errorMessage, linkId, null, true);
    }

    protected String resolveElementType(GenerateRequest request, ICompositeType element) {
        List<IBase> typeList = request.resolvePathList((IBase)element, "type");
        return typeList.isEmpty() ? null : request.resolvePathString(typeList.get(0), "code");
    }

    protected String getElementType(GenerateRequest request, ICompositeType element) {
        String type = this.resolveElementType(request, element);
        if (type == null) {
            ICompositeType snapshot;
            String path = request.resolvePathString((IBase)element, "path");
            ICompositeType iCompositeType = snapshot = request.getSnapshotElements() == null ? null : (ICompositeType)request.getSnapshotElements().stream().filter(e -> path.equals(request.resolvePathString((IBase)e, "path"))).findFirst().orElse(null);
            if (snapshot != null) {
                type = this.resolveElementType(request, snapshot);
            }
        }
        return type;
    }

    public IBaseBackboneElement createQuestionnaireItem(GenerateRequest request, String linkId) {
        String url = request.resolvePathString((IBase)request.getProfile(), "url");
        String type = request.resolvePathString((IBase)request.getProfile(), "type");
        String definition = String.format("%s#%s", url, type);
        String text = this.getProfileText(request);
        IBaseBackboneElement item = this.createQuestionnaireItemComponent(request, text, linkId, definition, false);
        return item;
    }

    protected String getProfileText(GenerateRequest request) {
        IBaseExtension inputExt = request.getExtensions((IBase)request.getProfile()).stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-input-text")).findFirst().orElse(null);
        if (inputExt != null) {
            return (String)((IPrimitiveType)inputExt.getValue()).getValue();
        }
        String title = request.resolvePathString((IBase)request.getProfile(), "title");
        if (title != null) {
            return title;
        }
        String url = request.resolvePathString((IBase)request.getProfile(), "url");
        return url.substring(url.lastIndexOf("/") + 1);
    }

    protected IBaseBackboneElement createQuestionnaireItemComponent(GenerateRequest request, String text, String linkId, String definition, Boolean isDisplay) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return new Questionnaire.QuestionnaireItemComponent().setType(isDisplay != false ? Questionnaire.QuestionnaireItemType.DISPLAY : Questionnaire.QuestionnaireItemType.GROUP).setDefinition(definition).setLinkId(linkId).setText(text);
            }
            case R4: {
                return new Questionnaire.QuestionnaireItemComponent().setType(isDisplay != false ? Questionnaire.QuestionnaireItemType.DISPLAY : Questionnaire.QuestionnaireItemType.GROUP).setDefinition(definition).setLinkId(linkId).setText(text);
            }
            case R5: {
                return new Questionnaire.QuestionnaireItemComponent().setType(isDisplay != false ? Questionnaire.QuestionnaireItemType.DISPLAY : Questionnaire.QuestionnaireItemType.GROUP).setDefinition(definition).setLinkId(linkId).setText(text);
            }
        }
        return null;
    }
}

