/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.populate.IPopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItem;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItemWithContext;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessResponseItem;
import org.opencds.cqf.fhir.utility.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateProcessor
implements IPopulateProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(PopulateProcessor.class);
    private final ProcessItem processItem;
    private final ProcessItemWithContext processItemWithContext;
    private final ProcessResponseItem processResponseItem;

    public PopulateProcessor() {
        this(new ProcessItem(), new ProcessItemWithContext(), new ProcessResponseItem());
    }

    private PopulateProcessor(ProcessItem processItem, ProcessItemWithContext processItemWithExtension, ProcessResponseItem processResponseItem) {
        this.processItem = processItem;
        this.processItemWithContext = processItemWithExtension;
        this.processResponseItem = processResponseItem;
    }

    @Override
    public <R extends IBaseResource> R prePopulate(PopulateRequest request) {
        String questionnaireId = request.getQuestionnaire().getIdElement().getIdPart() + "-" + request.getSubjectId().getIdPart();
        IBaseResource populatedQuestionnaire = Resources.clone((IBaseResource)request.getQuestionnaire());
        request.getModelResolver().setValue((Object)populatedQuestionnaire, "item", null);
        populatedQuestionnaire.setId(questionnaireId);
        request.getModelResolver().setValue((Object)populatedQuestionnaire, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(request.getFhirVersion(), ExtensionBuilders.prepopulateSubjectExtension("Patient", request.getSubjectId().getIdPart()), false)));
        List<IBaseBackboneElement> items = request.getItems((IBase)request.getQuestionnaire());
        List<IBaseBackboneElement> processedItems = this.processItems(request, items);
        request.getModelResolver().setValue((Object)populatedQuestionnaire, "item", processedItems);
        request.resolveOperationOutcome(populatedQuestionnaire);
        return (R)populatedQuestionnaire;
    }

    @Override
    public IBaseResource populate(PopulateRequest request) {
        IBaseResource response = this.createQuestionnaireResponse(request);
        response.setId(request.getQuestionnaire().getIdElement().getIdPart() + "-" + request.getSubjectId().getIdPart());
        List<IBaseBackboneElement> items = request.getItems((IBase)request.getQuestionnaire());
        List<IBaseBackboneElement> processedItems = this.processItems(request, items);
        List<IBaseBackboneElement> responseItems = this.processResponseItems(request, processedItems);
        request.getModelResolver().setValue((Object)response, "item", responseItems);
        request.resolveOperationOutcome(response);
        request.getModelResolver().setValue((Object)response, "contained", Collections.singletonList(request.getQuestionnaire()));
        request.getModelResolver().setValue((Object)response, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(request.getFhirVersion(), ExtensionBuilders.dtrQuestionnaireResponseExtension(request.getQuestionnaire().getIdElement().getIdPart()), true)));
        return response;
    }

    public List<IBaseBackboneElement> processItems(PopulateRequest request, List<IBaseBackboneElement> items) {
        ArrayList<IBaseBackboneElement> populatedItems = new ArrayList<IBaseBackboneElement>();
        items.forEach(item -> {
            IBaseExtension populationContextExt = item.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext")).findFirst().orElse(null);
            if (populationContextExt != null) {
                populatedItems.addAll(this.processItemWithContext(request, (IBaseBackboneElement)item));
            } else {
                List<IBaseBackboneElement> childItems = request.getItems((IBase)item);
                if (!childItems.isEmpty()) {
                    IBaseBackboneElement populatedItem = (IBaseBackboneElement)SerializationUtils.clone((Serializable)item);
                    request.getModelResolver().setValue((Object)populatedItem, "item", null);
                    List<IBaseBackboneElement> processedChildItems = this.processItems(request, childItems);
                    request.getModelResolver().setValue((Object)populatedItem, "item", processedChildItems);
                    populatedItems.add(populatedItem);
                } else {
                    IBaseBackboneElement populatedItem = this.processItem(request, (IBaseBackboneElement)item);
                    populatedItems.add(populatedItem);
                }
            }
        });
        return populatedItems;
    }

    protected List<IBaseBackboneElement> processItemWithContext(PopulateRequest request, IBaseBackboneElement item) {
        try {
            return this.processItemWithContext.processItem(request, item);
        }
        catch (ResolveExpressionException e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            return new ArrayList<IBaseBackboneElement>();
        }
    }

    protected IBaseBackboneElement processItem(PopulateRequest request, IBaseBackboneElement item) {
        try {
            return this.processItem.processItem(request, item);
        }
        catch (ResolveExpressionException e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            return item;
        }
    }

    protected IBaseResource createQuestionnaireResponse(PopulateRequest request) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return new org.hl7.fhir.dstu3.model.QuestionnaireResponse().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS).setQuestionnaire(new Reference(((org.hl7.fhir.dstu3.model.Questionnaire)request.getQuestionnaire()).getUrl())).setSubject(new Reference(request.getSubjectId()));
            }
            case R4: {
                return new org.hl7.fhir.r4.model.QuestionnaireResponse().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS).setQuestionnaire(((Questionnaire)request.getQuestionnaire()).getUrl()).setSubject(new org.hl7.fhir.r4.model.Reference(request.getSubjectId()));
            }
            case R5: {
                return new QuestionnaireResponse().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS).setQuestionnaire(((org.hl7.fhir.r5.model.Questionnaire)request.getQuestionnaire()).getUrl()).setSubject(new org.hl7.fhir.r5.model.Reference(request.getSubjectId()));
            }
        }
        return null;
    }

    public List<IBaseBackboneElement> processResponseItems(PopulateRequest request, List<? extends IBaseBackboneElement> items) {
        try {
            return this.processResponseItem.processResponseItems(request, items);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            return new ArrayList<IBaseBackboneElement>();
        }
    }
}

