/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;

public class PopulateRequest
implements IQuestionnaireRequest {
    private final String operationName;
    private final IBaseResource questionnaire;
    private final IIdType subjectId;
    private final IBaseParameters parameters;
    private final IBaseBundle bundle;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final String defaultLibraryUrl;
    private IBaseOperationOutcome operationOutcome;

    public PopulateRequest(FhirVersionEnum fhirVersion, String operationName) {
        this.operationName = operationName;
        this.questionnaire = null;
        this.subjectId = null;
        this.parameters = null;
        this.bundle = null;
        this.libraryEngine = null;
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)fhirVersion);
        this.fhirVersion = fhirVersion;
        this.defaultLibraryUrl = null;
    }

    public PopulateRequest(String operationName, IBaseResource questionnaire, IIdType subjectId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        this.operationName = operationName;
        this.questionnaire = questionnaire;
        this.subjectId = subjectId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.fhirVersion = questionnaire.getStructureFhirVersionEnum();
        this.defaultLibraryUrl = this.resolveDefaultLibraryUrl();
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IBaseBundle getBundle() {
        return this.bundle;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.parameters;
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    protected final String resolveDefaultLibraryUrl() {
        IBaseExtension libraryExt = this.getExtensions((IBase)this.questionnaire).stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/cqf-library")).findFirst().orElse(null);
        return libraryExt == null ? null : (String)((IPrimitiveType)libraryExt.getValue()).getValue();
    }
}

