/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;

public class ProcessResponseItem {
    public List<IBaseBackboneElement> processResponseItems(PopulateRequest request, List<? extends IBaseBackboneElement> items) {
        return items.stream().map(i -> this.processResponseItem(request, (IBaseBackboneElement)i)).collect(Collectors.toList());
    }

    public IBaseBackboneElement processResponseItem(PopulateRequest request, IBaseBackboneElement item) {
        IBaseBackboneElement responseItem = this.createResponseItem(request.getFhirVersion(), item);
        List<IBaseBackboneElement> items = request.getItems((IBase)item);
        if (!items.isEmpty()) {
            List<IBaseBackboneElement> nestedResponseItems = this.processResponseItems(request, items);
            request.getModelResolver().setValue((Object)responseItem, "item", nestedResponseItems);
        } else {
            IBaseExtension authorExt = item.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author")).findFirst().orElse(null);
            if (authorExt != null) {
                request.getModelResolver().setValue((Object)responseItem, "extension", Collections.singletonList(authorExt));
            }
            responseItem = this.setAnswersForInitial(request, item, responseItem);
        }
        return responseItem;
    }

    public IBaseBackboneElement setAnswersForInitial(PopulateRequest request, IBaseBackboneElement item, IBaseBackboneElement responseItem) {
        if (request.getFhirVersion().equals((Object)FhirVersionEnum.DSTU3)) {
            IBaseBackboneElement dstu3Answer = this.createAnswer(FhirVersionEnum.DSTU3, request.resolvePath((IBase)item, "initial"));
            request.getModelResolver().setValue((Object)responseItem, "answer", (Object)dstu3Answer);
        } else {
            List<IBaseBackboneElement> initial = request.resolvePathList((IBase)item, "initial").stream().map(i -> (IBaseBackboneElement)i).collect(Collectors.toList());
            if (!initial.isEmpty()) {
                initial.forEach(i -> {
                    IBaseBackboneElement answer = this.createAnswer(request.getFhirVersion(), request.resolvePath((IBase)i, "value"));
                    request.getModelResolver().setValue((Object)responseItem, "answer", Collections.singletonList(answer));
                });
            }
        }
        return responseItem;
    }

    protected IBaseBackboneElement createAnswer(FhirVersionEnum fhirVersion, IBase value) {
        switch (fhirVersion) {
            case DSTU3: {
                return new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue((org.hl7.fhir.dstu3.model.Type)value);
            }
            case R4: {
                return new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue((Type)value);
            }
            case R5: {
                return new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue((DataType)value);
            }
        }
        return null;
    }

    protected IBaseBackboneElement createResponseItem(FhirVersionEnum fhirVersion, IBaseBackboneElement item) {
        switch (fhirVersion) {
            case DSTU3: {
                Questionnaire.QuestionnaireItemComponent dstu3Item = (Questionnaire.QuestionnaireItemComponent)item;
                return new QuestionnaireResponse.QuestionnaireResponseItemComponent(dstu3Item.getLinkIdElement()).setDefinitionElement(dstu3Item.getDefinitionElement()).setTextElement(dstu3Item.getTextElement());
            }
            case R4: {
                Questionnaire.QuestionnaireItemComponent r4Item = (Questionnaire.QuestionnaireItemComponent)item;
                return new QuestionnaireResponse.QuestionnaireResponseItemComponent(r4Item.getLinkIdElement()).setDefinitionElement(r4Item.getDefinitionElement()).setTextElement(r4Item.getTextElement());
            }
            case R5: {
                Questionnaire.QuestionnaireItemComponent r5Item = (Questionnaire.QuestionnaireItemComponent)item;
                return new QuestionnaireResponse.QuestionnaireResponseItemComponent(r5Item.getLinkId()).setDefinitionElement(r5Item.getDefinitionElement()).setTextElement(r5Item.getTextElement());
            }
        }
        return null;
    }
}

