/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;

public class CodeMap {
    public static Map<String, List<IBaseCoding>> create(ExtractRequest request) {
        if (request.getQuestionnaire() == null) {
            return null;
        }
        HashMap<String, List<IBaseCoding>> questionnaireCodeMap = new HashMap<String, List<IBaseCoding>>();
        request.getItems((IBase)request.getQuestionnaire()).forEach(item -> CodeMap.processQuestionnaireItems(request, item, questionnaireCodeMap));
        return questionnaireCodeMap;
    }

    private static void processQuestionnaireItems(IQuestionnaireRequest request, IBaseBackboneElement item, Map<String, List<IBaseCoding>> questionnaireCodeMap) {
        List<IBaseBackboneElement> childItems = request.getItems((IBase)item);
        if (!childItems.isEmpty()) {
            childItems.forEach(child -> CodeMap.processQuestionnaireItems(request, child, questionnaireCodeMap));
        } else {
            String linkId = request.resolvePathString((IBase)item, "linkId");
            List codes = request.resolvePathList((IBase)item, "code").stream().map(c -> (IBaseCoding)c).collect(Collectors.toList());
            questionnaireCodeMap.put(linkId, codes);
        }
    }
}

