/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.repository.IRepository;
import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r5.model.Meta;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.IRequestResolverFactory;
import org.opencds.cqf.fhir.cr.common.DynamicValueProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.utility.Ids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyProcessor
implements IApplyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ApplyProcessor.class);
    protected static final List<String> EXCLUDED_EXTENSION_LIST = Arrays.asList("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeCapability", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeRepresentationLevel");
    protected final IRepository repository;
    protected final IRequestResolverFactory resolverFactory;
    protected final ExtensionProcessor extensionProcessor;
    protected final DynamicValueProcessor dynamicValueProcessor;

    public ApplyProcessor(IRepository repository, IRequestResolverFactory resolverFactory) {
        this.repository = repository;
        this.resolverFactory = resolverFactory;
        this.extensionProcessor = new ExtensionProcessor();
        this.dynamicValueProcessor = new DynamicValueProcessor();
    }

    @Override
    public IBaseResource apply(ApplyRequest request) {
        logger.info("Performing $apply operation on ActivityDefinition/{}", (Object)request.getActivityDefinition().getIdElement().getIdPart());
        IBaseResource result = this.resolverFactory.create(request.getActivityDefinition()).resolve(request);
        IIdType id = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)result.fhirType(), (String)request.getActivityDefinition().getIdElement().getIdPart());
        result.setId(id);
        this.resolveMeta(request.getActivityDefinition(), result);
        this.extensionProcessor.processExtensions(request, (IBase)result, (IElement)request.getActivityDefinition(), EXCLUDED_EXTENSION_LIST);
        this.dynamicValueProcessor.processDynamicValues(request, result, (IElement)request.getActivityDefinition());
        request.resolveOperationOutcome(result);
        return result;
    }

    protected void resolveMeta(IBaseResource activityDefinition, IBaseResource resource) {
        switch (this.repository.fhirContext().getVersion().getVersion()) {
            case DSTU3: {
                break;
            }
            case R4: {
                if (!((ActivityDefinition)activityDefinition).hasProfile()) break;
                org.hl7.fhir.r4.model.Meta meta = new org.hl7.fhir.r4.model.Meta();
                meta.addProfile(((ActivityDefinition)activityDefinition).getProfile());
                ((DomainResource)resource).setMeta(meta);
                break;
            }
            case R5: {
                if (!((org.hl7.fhir.r5.model.ActivityDefinition)activityDefinition).hasProfile()) break;
                Meta meta = new Meta();
                meta.addProfile(((org.hl7.fhir.r5.model.ActivityDefinition)activityDefinition).getProfile());
                ((org.hl7.fhir.r5.model.DomainResource)resource).setMeta(meta);
                break;
            }
        }
    }
}

