/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.opencds.cqf.fhir.cr.common.IInputParameterResolver;
import org.opencds.cqf.fhir.utility.adapter.IActivityDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;

public class ApplyRequest
implements ICpgRequest {
    private final IActivityDefinitionAdapter activityDefinitionAdapter;
    private final IIdType subjectId;
    private final IIdType encounterId;
    private final IIdType practitionerId;
    private final IIdType organizationId;
    private final IBaseDatatype userType;
    private final IBaseDatatype userLanguage;
    private final IBaseDatatype userTaskContext;
    private final IBaseDatatype setting;
    private final IBaseDatatype settingContext;
    private final IBaseParameters parameters;
    private final IBaseBundle data;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final Map<String, String> referencedLibraries;
    private final IInputParameterResolver inputParameterResolver;
    private IBaseOperationOutcome operationOutcome;

    public ApplyRequest(IBaseResource activityDefinition, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IIdType organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, IBaseBundle data, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)activityDefinition, (Object)"expected non-null value for activityDefinition");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.fhirVersion = activityDefinition.getStructureFhirVersionEnum();
        this.activityDefinitionAdapter = this.getAdapterFactory().createActivityDefinition(activityDefinition);
        this.subjectId = subjectId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        this.organizationId = organizationId;
        this.userType = userType;
        this.userLanguage = userLanguage;
        this.userTaskContext = userTaskContext;
        this.setting = setting;
        this.settingContext = settingContext;
        this.parameters = parameters;
        this.data = data;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.referencedLibraries = this.activityDefinitionAdapter.getReferencedLibraries();
        this.inputParameterResolver = IInputParameterResolver.createResolver(libraryEngine.getRepository(), this.subjectId, this.encounterId, this.practitionerId, this.parameters, this.data);
    }

    public IBaseResource getActivityDefinition() {
        return this.activityDefinitionAdapter.get();
    }

    @Override
    public String getOperationName() {
        return "apply";
    }

    @Override
    public IBase getContextVariable() {
        return this.getActivityDefinition();
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IIdType getPractitionerId() {
        return this.practitionerId;
    }

    @Override
    public IIdType getEncounterId() {
        return this.encounterId;
    }

    @Override
    public IIdType getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public IBaseDatatype getUserType() {
        return this.userType;
    }

    @Override
    public IBaseDatatype getUserLanguage() {
        return this.userLanguage;
    }

    @Override
    public IBaseDatatype getUserTaskContext() {
        return this.userTaskContext;
    }

    @Override
    public IBaseDatatype getSetting() {
        return this.setting;
    }

    @Override
    public IBaseDatatype getSettingContext() {
        return this.settingContext;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.inputParameterResolver.getParameters();
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        return this.referencedLibraries;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return null;
    }

    @Override
    public IQuestionnaireAdapter getQuestionnaireAdapter() {
        return null;
    }
}

