/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.Dstu3ResolverFactory;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.R4ResolverFactory;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.R5ResolverFactory;

@FunctionalInterface
public interface IRequestResolverFactory {
    public BaseRequestResourceResolver create(IBaseResource var1);

    public static IRequestResolverFactory getDefault(FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                return new Dstu3ResolverFactory();
            }
            case R4: {
                return new R4ResolverFactory();
            }
            case R5: {
                return new R5ResolverFactory();
            }
        }
        throw new IllegalArgumentException("No default resolver factory exists for FHIR version: %s".formatted(fhirVersion));
    }
}

