/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import java.util.Collections;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Reference;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class ProcedureResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public ProcedureResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public Procedure resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        Procedure procedure = new Procedure();
        procedure.setStatus(Procedure.ProcedureStatus.UNKNOWN);
        procedure.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            procedure.setDefinition(Collections.singletonList(new Reference(this.activityDefinition.getUrl())));
        }
        if (this.activityDefinition.hasCode()) {
            procedure.setCode(this.activityDefinition.getCode());
        }
        if (this.activityDefinition.hasBodySite()) {
            procedure.setBodySite(this.activityDefinition.getBodySite());
        }
        return procedure;
    }
}

