/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import java.util.Collections;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.exceptions.FHIRException;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class ReferralRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public ReferralRequestResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public ReferralRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        ReferralRequest referralRequest = new ReferralRequest();
        referralRequest.setStatus(ReferralRequest.ReferralRequestStatus.ACTIVE);
        referralRequest.setIntent(ReferralRequest.ReferralCategory.ORDER);
        referralRequest.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            referralRequest.setDefinition(Collections.singletonList(new Reference(this.activityDefinition.getUrl())));
        }
        if (request.hasPractitionerId()) {
            referralRequest.setRequester(new ReferralRequest.ReferralRequestRequesterComponent(new Reference(request.getPractitionerId())));
        } else if (request.hasOrganizationId()) {
            referralRequest.setRequester(new ReferralRequest.ReferralRequestRequesterComponent(new Reference(request.getOrganizationId())));
        }
        if (this.activityDefinition.hasCode()) {
            referralRequest.setServiceRequested(Collections.singletonList(this.activityDefinition.getCode()));
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException("Missing required ActivityDefinition.code property for %s".formatted("ReferralRequest"));
        }
        return referralRequest;
    }
}

