/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Task;
import org.hl7.fhir.dstu3.model.Type;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class TaskResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public TaskResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public Task resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        Task task = new Task();
        task.setFor(new Reference(request.getSubjectId()));
        if (request.hasEncounterId()) {
            task.setContext(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            task.setRequester(new Task.TaskRequesterComponent(new Reference(request.getPractitionerId())));
        }
        if (this.activityDefinition.hasExtension()) {
            Type value = ((Extension)this.activityDefinition.getExtensionsByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus").get(0)).getValue();
            if (value instanceof StringType) {
                StringType type = (StringType)value;
                task.setStatus(Task.TaskStatus.valueOf((String)type.asStringValue().toUpperCase()));
            } else {
                logger.debug("Extension {} should have a value of type {}", (Object)"http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus", (Object)StringType.class.getName());
            }
        } else {
            task.setStatus(Task.TaskStatus.READY);
        }
        task.setIntent(Task.TaskIntent.PROPOSAL);
        if (this.activityDefinition.hasUrl()) {
            task.setDefinition((Type)this.activityDefinition.getUrlElement());
        }
        if (this.activityDefinition.hasCode()) {
            task.setCode(this.activityDefinition.getCode());
        }
        if (this.activityDefinition.hasDescription()) {
            task.setDescription(this.activityDefinition.getDescription());
        }
        return task;
    }
}

