/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r5;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class DiagnosticReportResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public DiagnosticReportResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public DiagnosticReport resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        DiagnosticReport diagnosticReport = new DiagnosticReport();
        diagnosticReport.setStatus(DiagnosticReport.DiagnosticReportStatus.UNKNOWN);
        diagnosticReport.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasCode()) {
            diagnosticReport.setCode(this.activityDefinition.getCode());
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException("Missing required ActivityDefinition.code property for %s".formatted("DiagnosticReport"));
        }
        if (this.activityDefinition.hasRelatedArtifact()) {
            ArrayList<Attachment> presentedFormAttachments = new ArrayList<Attachment>();
            for (RelatedArtifact artifact : this.activityDefinition.getRelatedArtifact()) {
                Attachment attachment = new Attachment();
                if (artifact.hasResourceElement()) {
                    attachment.setUrl((String)artifact.getResourceElement().getValue());
                }
                if (artifact.hasDisplay()) {
                    attachment.setTitle(artifact.getDisplay());
                }
                presentedFormAttachments.add(attachment);
            }
            diagnosticReport.setPresentedForm(presentedFormAttachments);
        }
        return diagnosticReport;
    }
}

