/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r5;

import com.google.common.base.Preconditions;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Task;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class TaskResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public TaskResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public Task resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        Task task = new Task();
        task.setFor(new Reference(request.getSubjectId()));
        if (request.hasEncounterId()) {
            task.setEncounter(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            task.setRequester(new Reference(request.getPractitionerId()));
        }
        if (this.activityDefinition.hasExtension("http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus")) {
            DataType value = this.activityDefinition.getExtensionByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus").getValue();
            if (value instanceof StringType) {
                StringType type = (StringType)value;
                task.setStatus(Task.TaskStatus.valueOf((String)type.asStringValue().toUpperCase()));
            } else {
                logger.debug("Extension {} should have a value of type {}", (Object)"http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus", (Object)StringType.class.getName());
            }
        } else {
            task.setStatus(Task.TaskStatus.READY);
        }
        task.setIntent(this.activityDefinition.hasIntent() ? Task.TaskIntent.fromCode((String)this.activityDefinition.getIntent().toCode()) : Task.TaskIntent.PROPOSAL);
        if (this.activityDefinition.hasUrl()) {
            task.setInstantiatesCanonical(this.activityDefinition.getUrl() + (this.activityDefinition.hasVersion() ? "|%s".formatted(this.activityDefinition.getVersion()) : ""));
        }
        if (this.activityDefinition.hasCode()) {
            task.setCode(this.activityDefinition.getCode());
        }
        if (this.activityDefinition.hasDescription()) {
            task.setDescription(this.activityDefinition.getDescription());
        }
        if (this.activityDefinition.getDoNotPerform()) {
            task.addModifierExtension(new Extension("http://hl7.org/fhir/StructureDefinition/request-doNotPerform").setValue((DataType)this.activityDefinition.getDoNotPerformElement()));
        }
        return task;
    }
}

