/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import java.util.List;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicValueProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DynamicValueProcessor.class);
    private static final String EXPRESSION = "expression";

    public void processDynamicValues(ICpgRequest request, IBaseResource resource, IElement definitionElement) {
        IBaseResource baseResource;
        IBaseResource context = definitionElement instanceof IBaseResource ? (baseResource = (IBaseResource)definitionElement) : resource;
        this.processDynamicValues(request, context, resource, definitionElement, null);
    }

    public void processDynamicValues(ICpgRequest request, IBaseResource context, IBaseResource resource, IElement definitionElement, IElement requestAction) {
        List<IBaseBackboneElement> dynamicValues = request.getDynamicValues(definitionElement);
        for (IBaseBackboneElement dynamicValue : dynamicValues) {
            try {
                this.resolveDynamicValue(request, dynamicValue, context, resource, requestAction);
            }
            catch (Exception e) {
                String message = "DynamicValue resolution for path %s encountered exception: %s".formatted(request.resolvePathString((IBase)dynamicValue, "path"), e.getMessage());
                logger.error(message);
                request.logException(message);
            }
        }
    }

    protected CqfExpression getDynamicValueExpression(ICpgRequest request, IBaseBackboneElement dynamicValue) {
        return switch (request.getFhirVersion()) {
            case FhirVersionEnum.DSTU3 -> new CqfExpression(request.resolvePathString((IBase)dynamicValue, "language"), request.resolvePathString((IBase)dynamicValue, EXPRESSION), request.getReferencedLibraries());
            case FhirVersionEnum.R4 -> CqfExpression.of((Expression)request.resolvePath((IBase)dynamicValue, EXPRESSION, Expression.class), request.getReferencedLibraries());
            case FhirVersionEnum.R5 -> CqfExpression.of((org.hl7.fhir.r5.model.Expression)request.resolvePath((IBase)dynamicValue, EXPRESSION, org.hl7.fhir.r5.model.Expression.class), request.getReferencedLibraries());
            default -> null;
        };
    }

    protected void resolveDynamicValue(ICpgRequest request, IBaseBackboneElement dynamicValue, IBaseResource context, IBaseResource resource, IElement requestAction) {
        String path = request.resolvePathString((IBase)dynamicValue, "path");
        path = path.replace("%", "");
        CqfExpression cqfExpression = this.getDynamicValueExpression(request, dynamicValue);
        if (cqfExpression != null) {
            IBase value;
            IBase result = this.getDynamicValueExpressionResult(request, cqfExpression, context, resource);
            if (result == null || result.isEmpty()) {
                String warning = "Null value received when evaluating dynamic value expression: %s".formatted(cqfExpression.getExpression());
                logger.warn(warning);
                return;
            }
            IBase iBase = value = result.size() == 1 ? result.get(0) : result;
            if (this.requiresRequestAction(path, resource).booleanValue()) {
                if (requestAction == null) {
                    throw new IllegalArgumentException("Error resolving dynamicValue with path %s: expected requestAction not found".formatted(path));
                }
                if (this.isPriorityExtension(path).booleanValue()) {
                    if (request.getFhirVersion() != FhirVersionEnum.DSTU3) {
                        throw new IllegalArgumentException("Please use the priority path when setting indicator values when using FHIR R4 or higher for CDS Hooks evaluation");
                    }
                    ((Element)requestAction).addExtension().setValue((Type)value);
                } else {
                    request.getModelResolver().setValue((Object)requestAction, path.replace("action.", ""), (Object)value);
                }
            } else {
                request.getModelResolver().setValue((Object)resource, path, (Object)value);
            }
        }
    }

    protected List<IBase> getDynamicValueExpressionResult(ICpgRequest request, CqfExpression cqfExpression, IBaseResource context, IBaseResource resource) {
        return request.getLibraryEngine().resolveExpression(request.getSubjectId().getIdPart(), cqfExpression, request.getParameters(), request.getRawParameters(), request.getData(), (IBase)context, (IBase)resource);
    }

    private Boolean requiresRequestAction(String path, IBaseResource resource) {
        return this.isPriorityExtension(path) != false || this.isAction(path, resource) != false;
    }

    private Boolean isPriorityExtension(String path) {
        return path.startsWith("activity.extension") || path.startsWith("action.extension");
    }

    private Boolean isAction(String path, IBaseResource resource) {
        return path.startsWith("action.") || resource == null;
    }
}

