/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cr.common.ICqlOperationRequest;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(ExpressionProcessor.class);
    protected static final String EXCEPTION_MESSAGE_TEMPLATE = "Error encountered evaluating expression (%s) for item (%s): %s";

    public List<IBase> getExpressionResultForItem(ICqlOperationRequest request, CqfExpression expression, String itemLinkId, IBaseParameters parameters, Map<String, Object> rawParameters) {
        try {
            return this.getExpressionResult(request, expression, parameters, rawParameters);
        }
        catch (Exception ex) {
            String message = EXCEPTION_MESSAGE_TEMPLATE.formatted(expression.getExpression(), itemLinkId, ex.getMessage());
            throw new UnprocessableEntityException(message);
        }
    }

    public List<IBase> getExpressionResult(ICqlOperationRequest request, CqfExpression expression) {
        return this.getExpressionResult(request, expression, null, null);
    }

    public List<IBase> getExpressionResult(ICqlOperationRequest request, CqfExpression expression, @Nullable IBaseParameters parameters, @Nullable Map<String, Object> rawParameters) {
        parameters = parameters == null ? request.getParameters() : parameters;
        rawParameters = rawParameters == null ? request.getRawParameters() : rawParameters;
        Collection result = expression == null ? null : request.getLibraryEngine().resolveExpression(request.getSubjectId().getIdPart(), expression, parameters, rawParameters, request.getData(), request.getContextVariable(), request.getResourceVariable());
        return result == null ? new ArrayList<IBase>() : result.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <E extends IBaseExtension<?, ?>> CqfExpression getCqfExpression(IOperationRequest request, List<E> extensions, String extensionUrl) {
        IBaseExtension extension = extensions.stream().filter(e -> e.getUrl().equals(extensionUrl)).findFirst().orElse(null);
        return extension == null ? null : CqfExpression.of((IBaseExtension)extension, request.getReferencedLibraries());
    }

    public CqfExpression getCqfExpressionForElement(IOperationRequest request, IBaseBackboneElement element) {
        if (element == null) {
            return null;
        }
        String expressionPath = "expression";
        return switch (request.getFhirVersion()) {
            case FhirVersionEnum.DSTU3 -> new CqfExpression(request.resolvePathString((IBase)element, "language"), request.resolvePathString((IBase)element, expressionPath), request.getReferencedLibraries());
            case FhirVersionEnum.R4 -> CqfExpression.of((Expression)request.resolvePath((IBase)element, expressionPath, Expression.class), request.getReferencedLibraries());
            case FhirVersionEnum.R5 -> CqfExpression.of((org.hl7.fhir.r5.model.Expression)request.resolvePath((IBase)element, expressionPath, org.hl7.fhir.r5.model.Expression.class), request.getReferencedLibraries());
            default -> null;
        };
    }

    public CqfExpression getItemInitialExpression(IOperationRequest request, IBaseBackboneElement item) {
        if (!item.hasExtension()) {
            return null;
        }
        CqfExpression cqfExpression = this.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/StructureDefinition/cqf-expression");
        return cqfExpression != null ? cqfExpression : this.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
    }
}

