/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.cr.common.IInputParameterResolver;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputParameterResolver
implements IInputParameterResolver {
    private static final Logger logger = LoggerFactory.getLogger(InputParameterResolver.class);
    protected final IIdType subjectId;
    protected final IIdType encounterId;
    protected final IIdType practitionerId;
    protected final IAdapterFactory adapterFactory;
    protected final IRepository repository;
    protected final IParametersAdapter parameters;

    public InputParameterResolver(IRepository repository, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IBaseParameters parameters, IBaseBundle data, List<IParametersParameterComponentAdapter> context, List<IBaseExtension<?, ?>> launchContext) {
        this.subjectId = subjectId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        this.repository = this.resolveRepository(repository, data);
        this.adapterFactory = IAdapterFactory.forFhirContext((FhirContext)this.repository.fhirContext());
        this.parameters = this.resolveParameters(parameters, context, launchContext);
    }

    protected final IRepository resolveRepository(IRepository serverRepository, IBaseBundle data) {
        return data == null ? serverRepository : new FederatedRepository(serverRepository, new IRepository[]{new InMemoryFhirRepository(serverRepository.fhirContext(), data)});
    }

    protected FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    protected FhirVersionEnum fhirVersion() {
        return this.fhirContext().getVersion().getVersion();
    }

    protected <R extends IBaseResource> R readRepository(Class<R> resourceType, IIdType id) {
        try {
            return (R)this.repository.read(resourceType, id);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected final IParametersAdapter resolveParameters(IBaseParameters baseParameters, List<IParametersParameterComponentAdapter> context, List<IBaseExtension<?, ?>> launchContext) {
        Class practitionerClass;
        Object practitioner;
        Class encounterClass;
        Object encounter;
        Class subjectClass;
        Object subject;
        IParametersAdapter params = this.adapterFactory.createParameters((IBaseParameters)Resources.newBaseForVersion((String)"Parameters", (FhirVersionEnum)this.fhirVersion()));
        if (baseParameters != null) {
            this.adapterFactory.createParameters(baseParameters).getParameter().forEach(p -> params.addParameter((IBase)p.get()));
        }
        if (this.subjectId != null && (subject = this.readRepository(subjectClass = this.fhirContext().getResourceDefinition(this.subjectId.getResourceType()).getImplementingClass(), this.subjectId)) != null) {
            params.addParameter("%subject", subject);
        }
        if (this.encounterId != null && (encounter = this.readRepository(encounterClass = this.fhirContext().getResourceDefinition(this.encounterId.getResourceType()).getImplementingClass(), this.encounterId)) != null) {
            params.addParameter("%encounter", encounter);
        }
        if (this.practitionerId != null && (practitioner = this.readRepository(practitionerClass = this.fhirContext().getResourceDefinition(this.practitionerId.getResourceType()).getImplementingClass(), this.practitionerId)) != null) {
            params.addParameter("%practitioner", practitioner);
        }
        if (launchContext != null && !launchContext.isEmpty()) {
            this.resolveLaunchContext(params, context, launchContext);
        }
        return params;
    }

    protected void resolveLaunchContext(IParametersAdapter params, List<IParametersParameterComponentAdapter> contexts, List<IBaseExtension<?, ?>> launchContexts) {
        launchContexts.forEach(launchContext -> {
            List<IBaseResource> value;
            String name = launchContext.getExtension().stream().map(e -> (IBaseExtension)e).filter(e -> e.getUrl().equals("name")).map(e -> this.adapterFactory.createCoding((ICompositeType)e.getValue()).getCode()).findFirst().orElse(null);
            List<String> types = launchContext.getExtension().stream().map(e -> (IBaseExtension)e).filter(e -> e.getUrl().equals("type")).map(type -> ((IPrimitiveType)type.getValue()).getValueAsString()).toList();
            if (name == null || types.isEmpty()) {
                throw new UnprocessableEntityException("Encountered invalid Launch Context extension");
            }
            List<IParametersParameterComponentAdapter> content = this.getContent(contexts, name);
            if (content != null && !content.isEmpty() && !(value = this.getValue(types, content)).isEmpty()) {
                String cqlParameterName = name.substring(0, 1).toUpperCase().concat(name.substring(1));
                value.forEach(resource -> {
                    params.addParameter("%" + name, resource);
                    params.addParameter(cqlParameterName, resource);
                });
            }
        });
    }

    protected List<IParametersParameterComponentAdapter> getContent(List<IParametersParameterComponentAdapter> contexts, String name) {
        return contexts == null ? null : contexts.stream().filter(c -> c.getPart().stream().filter(p -> p.getName().equals("name")).anyMatch(p -> ((IPrimitiveType)p.getValue()).getValueAsString().equals(name))).flatMap(c -> c.getPart().stream().filter(p -> p.getName().equals("content"))).toList();
    }

    protected List<IBaseResource> getValue(List<String> types, List<IParametersParameterComponentAdapter> content) {
        return content.stream().map(p -> {
            IBaseDatatype patt0$temp = p.getValue();
            if (patt0$temp instanceof IBaseReference) {
                IBaseReference ref = (IBaseReference)patt0$temp;
                IBaseResource resource = null;
                for (String type : types) {
                    try {
                        resource = (IBaseResource)this.readRepository(this.fhirContext().getResourceDefinition(type).getImplementingClass(), ref.getReferenceElement());
                        if (resource == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                return resource;
            }
            return p.getResource();
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public IBaseParameters getParameters() {
        return this.parameters == null ? null : (IBaseParameters)this.parameters.get();
    }

    @Override
    public <T extends ICompositeType> IBaseParameters resolveInputParameters(List<T> dataRequirement) {
        List<IDataRequirementAdapter> dataRequirements = dataRequirement.stream().map(arg_0 -> ((IAdapterFactory)this.adapterFactory).createDataRequirement(arg_0)).toList();
        IParametersAdapter params = this.adapterFactory.createParameters((IBaseParameters)Resources.newBaseForVersion((String)"Parameters", (FhirVersionEnum)this.fhirVersion()));
        if (this.parameters != null) {
            this.parameters.getParameter().forEach(p -> params.addParameter((IBase)p.get()));
        }
        for (IDataRequirementAdapter req : dataRequirements) {
            if (!req.hasId() || !req.hasCodeFilter()) continue;
            IParametersParameterComponentAdapter parameter = this.adapterFactory.createParametersParameter((IBaseBackboneElement)Parameters.newPart((FhirContext)this.fhirContext(), (String)("%" + "%s".formatted(req.getId())), (IBase[])new IBase[0]));
            this.resolveCodeFilters(req, parameter);
            params.addParameter((IBase)parameter.get());
        }
        return (IBaseParameters)params.get();
    }

    private void resolveCodeFilters(IDataRequirementAdapter req, IParametersParameterComponentAdapter parameter) {
        for (IDataRequirementCodeFilterAdapter filter : req.getCodeFilter()) {
            if (filter == null || !filter.hasPath() || !filter.hasValueSet()) continue;
            try {
                IValueSetAdapter valueSet = this.adapterFactory.createValueSet(SearchHelper.searchRepositoryByCanonical((IRepository)this.repository, (IPrimitiveType)filter.getValueSet()));
                List<ICodingAdapter> codes = valueSet.getExpansionContains().stream().map(c -> this.adapterFactory.createCoding((ICompositeType)Resources.newBaseForVersion((String)"Coding", (FhirVersionEnum)this.fhirVersion())).setCode(c.getCode()).setSystem(c.getSystem()).setDisplay(c.getDisplay())).toList();
                Searches.SearchBuilder searchBuilder = Searches.builder();
                codes.forEach(c -> searchBuilder.withTokenParam("code", c.getCode()));
                Class resourceType = this.fhirContext().getResourceDefinition(req.getType()).getImplementingClass();
                IBaseBundle searchResults = SearchHelper.searchRepositoryWithPaging((IRepository)this.repository, (Class)resourceType, (Map)searchBuilder.build(), null);
                if (BundleHelper.getEntry((IBaseBundle)searchResults).isEmpty()) continue;
                parameter.setResource((IBaseResource)(BundleHelper.getEntry((IBaseBundle)searchResults).size() > 1 ? searchResults : BundleHelper.getEntryResourceFirstRep((IBaseBundle)searchResults)));
            }
            catch (Exception e) {
                logger.debug("Could not find ValueSet with url {} on the local server.", (Object)filter.getValueSet());
            }
        }
    }
}

