/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.StringType;

public class ItemValueTransformer {
    private ItemValueTransformer() {
    }

    public static org.hl7.fhir.dstu3.model.Type transformValueToItem(org.hl7.fhir.dstu3.model.Type value) {
        if (value instanceof org.hl7.fhir.dstu3.model.CodeableConcept) {
            org.hl7.fhir.dstu3.model.CodeableConcept codeType = (org.hl7.fhir.dstu3.model.CodeableConcept)value;
            return (org.hl7.fhir.dstu3.model.Type)codeType.getCoding().get(0);
        }
        if (value instanceof org.hl7.fhir.dstu3.model.Enumeration) {
            org.hl7.fhir.dstu3.model.Enumeration enumType = (org.hl7.fhir.dstu3.model.Enumeration)value;
            return new org.hl7.fhir.dstu3.model.StringType(enumType.asStringValue());
        }
        if (value instanceof org.hl7.fhir.dstu3.model.IdType) {
            org.hl7.fhir.dstu3.model.IdType idType = (org.hl7.fhir.dstu3.model.IdType)value;
            return new org.hl7.fhir.dstu3.model.StringType(idType.asStringValue());
        }
        if (value instanceof Identifier) {
            Identifier identifier = (Identifier)value;
            return new org.hl7.fhir.dstu3.model.StringType(identifier.getValue());
        }
        return value;
    }

    public static Type transformValueToItem(Type value) {
        if (value instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            org.hl7.fhir.r4.model.CodeableConcept codeType = (org.hl7.fhir.r4.model.CodeableConcept)value;
            return (Type)codeType.getCoding().get(0);
        }
        if (value instanceof Enumeration) {
            Enumeration enumType = (Enumeration)value;
            return new org.hl7.fhir.r4.model.StringType(enumType.getCode());
        }
        if (value instanceof IdType) {
            IdType idType = (IdType)value;
            return new org.hl7.fhir.r4.model.StringType(idType.asStringValue());
        }
        if (value instanceof org.hl7.fhir.r4.model.Identifier) {
            org.hl7.fhir.r4.model.Identifier identifier = (org.hl7.fhir.r4.model.Identifier)value;
            return new org.hl7.fhir.r4.model.StringType(identifier.getValue());
        }
        return value;
    }

    public static DataType transformValueToItem(DataType value) {
        if (value instanceof CodeableConcept) {
            CodeableConcept codeType = (CodeableConcept)value;
            return (DataType)codeType.getCoding().get(0);
        }
        if (value instanceof org.hl7.fhir.r5.model.Enumeration) {
            org.hl7.fhir.r5.model.Enumeration enumType = (org.hl7.fhir.r5.model.Enumeration)value;
            return new StringType(enumType.getCode());
        }
        if (value instanceof org.hl7.fhir.r5.model.IdType) {
            org.hl7.fhir.r5.model.IdType idType = (org.hl7.fhir.r5.model.IdType)value;
            return new StringType(idType.asStringValue());
        }
        if (value instanceof org.hl7.fhir.r5.model.Identifier) {
            org.hl7.fhir.r5.model.Identifier identifier = (org.hl7.fhir.r5.model.Identifier)value;
            return new StringType(identifier.getValue());
        }
        return value;
    }

    public static IBase transformValueToResource(FhirVersionEnum fhirVersion, IBase value) {
        switch (fhirVersion) {
            case DSTU3: {
                return ItemValueTransformer.transformValueToResource((org.hl7.fhir.dstu3.model.Type)value);
            }
            case R4: {
                return ItemValueTransformer.transformValueToResource((Type)value);
            }
            case R5: {
                return ItemValueTransformer.transformValueToResource((DataType)value);
            }
        }
        return null;
    }

    public static org.hl7.fhir.dstu3.model.Type transformValueToResource(org.hl7.fhir.dstu3.model.Type value) {
        if (value instanceof org.hl7.fhir.dstu3.model.Coding) {
            org.hl7.fhir.dstu3.model.Coding codingType = (org.hl7.fhir.dstu3.model.Coding)value;
            return new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(codingType);
        }
        return value;
    }

    public static Type transformValueToResource(Type value) {
        if (value instanceof org.hl7.fhir.r4.model.Coding) {
            org.hl7.fhir.r4.model.Coding codingType = (org.hl7.fhir.r4.model.Coding)value;
            return new org.hl7.fhir.r4.model.CodeableConcept().addCoding(codingType);
        }
        return value;
    }

    public static DataType transformValueToResource(DataType value) {
        if (value instanceof Coding) {
            Coding codingType = (Coding)value;
            return new CodeableConcept().addCoding(codingType);
        }
        return value;
    }
}

