/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.cr.visitor.PackageVisitor;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;

public class PackageProcessor
implements IPackageProcessor {
    protected final IRepository repository;
    protected final FhirVersionEnum fhirVersion;
    protected final PackageVisitor packageVisitor;
    protected final IAdapterFactory adapterFactory;

    public PackageProcessor(IRepository repository) {
        this.repository = repository;
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.packageVisitor = new PackageVisitor(this.repository);
        this.adapterFactory = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion);
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource, IBaseParameters parameters) {
        return (IBaseBundle)this.packageVisitor.visit(this.adapterFactory.createKnowledgeArtifactAdapter((IDomainResource)resource), parameters);
    }
}

