/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.cpg;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.opencds.cqf.fhir.utility.Canonicals;

public class CqlExecutionProcessor {
    public Map<String, String> resolveIncludedLibraries(List<?> includedLibraries) {
        if (includedLibraries != null) {
            HashMap<String, String> libraries = new HashMap<String, String>();
            String name = null;
            String url = null;
            for (Object parameters : includedLibraries) {
                if (parameters instanceof Parameters) {
                    Parameters parameters1 = (Parameters)parameters;
                    for (Parameters.ParametersParameterComponent parameterComponent : parameters1.getParameter()) {
                        if (parameterComponent.getName().equalsIgnoreCase("url")) {
                            url = parameterComponent.getValue().primitiveValue();
                        }
                        if (!parameterComponent.getName().equalsIgnoreCase("name")) continue;
                        name = parameterComponent.getValue().primitiveValue();
                    }
                } else {
                    for (Parameters.ParametersParameterComponent parameterComponent : ((org.hl7.fhir.r4.model.Parameters)parameters).getParameter()) {
                        if (parameterComponent.getName().equalsIgnoreCase("url")) {
                            url = parameterComponent.getValue().primitiveValue();
                        }
                        if (!parameterComponent.getName().equalsIgnoreCase("name")) continue;
                        name = parameterComponent.getValue().primitiveValue();
                    }
                }
                libraries.put(name, url);
            }
            return libraries;
        }
        return null;
    }

    public VersionedIdentifier resolveLibraryIdentifier(String content, IBaseResource library, LibraryManager libraryManager) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            CompiledLibrary translatedLibrary = CqlTranslator.fromText((String)content, (LibraryManager)libraryManager).getTranslatedLibrary();
            return new VersionedIdentifier().withId(translatedLibrary.getIdentifier().getId()).withVersion(translatedLibrary.getIdentifier().getVersion());
        }
        if (library == null) {
            return null;
        }
        Library r4Library = (Library)library;
        return new VersionedIdentifier().withId(r4Library.hasUrl() ? Canonicals.getIdPart((String)r4Library.getUrl()) : (r4Library.hasName() ? r4Library.getName() : null)).withVersion(r4Library.hasVersion() ? r4Library.getVersion() : (r4Library.hasUrl() ? Canonicals.getVersion((String)r4Library.getUrl()) : null));
    }

    public IBaseOperationOutcome createIssue(String severity, String details, IRepository repository) {
        if (repository.fhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            return new org.hl7.fhir.dstu3.model.OperationOutcome().addIssue(new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.fromCode((String)severity)).setDetails(new org.hl7.fhir.dstu3.model.CodeableConcept().setText(details)));
        }
        return new OperationOutcome().addIssue(new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.fromCode((String)severity)).setDetails(new CodeableConcept().setText(details)));
    }
}

