/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.common;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationBasisValidator;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierComponentDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureScoringTypePopulations;

public class MeasureEvaluator {
    private final PopulationBasisValidator populationBasisValidator;

    public MeasureEvaluator(PopulationBasisValidator populationBasisValidator) {
        this.populationBasisValidator = populationBasisValidator;
    }

    public MeasureDef evaluate(MeasureDef measureDef, MeasureEvalType measureEvalType, String subjectType, String subjectId, EvaluationResult evaluationResult, boolean applyScoring) {
        Objects.requireNonNull(measureDef, "measureDef is a required argument");
        Objects.requireNonNull(subjectId, "subjectIds is a required argument");
        switch (measureEvalType) {
            case PATIENT: 
            case SUBJECT: {
                return this.evaluateSubject(measureDef, subjectType, subjectId, MeasureReportType.INDIVIDUAL, evaluationResult, applyScoring);
            }
            case SUBJECTLIST: {
                return this.evaluateSubject(measureDef, subjectType, subjectId, MeasureReportType.SUBJECTLIST, evaluationResult, applyScoring);
            }
            case PATIENTLIST: {
                return this.evaluateSubject(measureDef, subjectType, subjectId, MeasureReportType.PATIENTLIST, evaluationResult, applyScoring);
            }
            case POPULATION: {
                return this.evaluateSubject(measureDef, subjectType, subjectId, MeasureReportType.SUMMARY, evaluationResult, applyScoring);
            }
        }
        throw new InvalidRequestException("Unsupported Measure Evaluation type: %s for MeasureDef: %s".formatted(measureEvalType.getDisplay(), measureDef.url()));
    }

    protected MeasureDef evaluateSubject(MeasureDef measureDef, String subjectType, String subjectId, MeasureReportType reportType, EvaluationResult evaluationResult, boolean applyScoring) {
        this.evaluateSdes(subjectId, measureDef.sdes(), evaluationResult);
        for (GroupDef groupDef : measureDef.groups()) {
            this.evaluateGroup(measureDef, groupDef, subjectType, subjectId, reportType, evaluationResult, applyScoring);
        }
        return measureDef;
    }

    protected Iterable<Object> evaluatePopulationCriteria(String subjectType, ExpressionResult expressionResult, EvaluationResult evaluationResult, Set<Object> outEvaluatedResources) {
        if (expressionResult != null && !expressionResult.evaluatedResources().isEmpty()) {
            outEvaluatedResources.addAll(expressionResult.evaluatedResources());
        }
        if (expressionResult == null || expressionResult.value() == null) {
            return Collections.emptyList();
        }
        if (expressionResult.value() instanceof Boolean) {
            if (Boolean.TRUE.equals(expressionResult.value())) {
                Object booleanResult = evaluationResult.forExpression(subjectType).value();
                return Collections.singletonList(booleanResult);
            }
            return Collections.emptyList();
        }
        Object value = expressionResult.value();
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        return Collections.singletonList(value);
    }

    protected PopulationDef evaluatePopulationMembership(String subjectType, String subjectId, PopulationDef inclusionDef, EvaluationResult evaluationResult) {
        ExpressionResult matchingResult = evaluationResult.forExpression(inclusionDef.expression());
        int i = 0;
        for (Object resource : this.evaluatePopulationCriteria(subjectType, matchingResult, evaluationResult, inclusionDef.getEvaluatedResources())) {
            inclusionDef.addResource(resource);
            inclusionDef.addResource(subjectId, resource);
            ++i;
        }
        if (i > 0) {
            inclusionDef.addSubject(subjectId);
        }
        return inclusionDef;
    }

    protected void evaluateProportion(GroupDef groupDef, String subjectType, String subjectId, MeasureReportType reportType, EvaluationResult evaluationResult, boolean applyScoring) {
        R4MeasureScoringTypePopulations.validateScoringTypePopulations(groupDef.populations().stream().map(PopulationDef::type).toList(), groupDef.measureScoring());
        PopulationDef initialPopulation = groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION);
        PopulationDef numerator = groupDef.getSingle(MeasurePopulationType.NUMERATOR);
        PopulationDef denominator = groupDef.getSingle(MeasurePopulationType.DENOMINATOR);
        PopulationDef denominatorExclusion = groupDef.getSingle(MeasurePopulationType.DENOMINATOREXCLUSION);
        PopulationDef denominatorException = groupDef.getSingle(MeasurePopulationType.DENOMINATOREXCEPTION);
        PopulationDef numeratorExclusion = groupDef.getSingle(MeasurePopulationType.NUMERATOREXCLUSION);
        PopulationDef dateOfCompliance = groupDef.getSingle(MeasurePopulationType.DATEOFCOMPLIANCE);
        initialPopulation = this.evaluatePopulationMembership(subjectType, subjectId, initialPopulation, evaluationResult);
        denominator = this.evaluatePopulationMembership(subjectType, subjectId, denominator, evaluationResult);
        numerator = this.evaluatePopulationMembership(subjectType, subjectId, numerator, evaluationResult);
        if (applyScoring) {
            denominator.getResources().retainAll(initialPopulation.getResources());
            denominator.getSubjects().retainAll(initialPopulation.getSubjects());
            numerator.getSubjects().retainAll(denominator.getSubjects());
            numerator.getResources().retainAll(denominator.getResources());
        }
        if (denominatorExclusion != null) {
            denominatorExclusion = this.evaluatePopulationMembership(subjectType, subjectId, denominatorExclusion, evaluationResult);
        }
        if (denominatorException != null) {
            denominatorException = this.evaluatePopulationMembership(subjectType, subjectId, denominatorException, evaluationResult);
        }
        if (numeratorExclusion != null) {
            numeratorExclusion = this.evaluatePopulationMembership(subjectType, subjectId, numeratorExclusion, evaluationResult);
        }
        if (groupDef.isBooleanBasis()) {
            if (denominatorExclusion != null && applyScoring) {
                numerator.getSubjects().removeAll(denominatorExclusion.getSubjects());
                numerator.removeOverlaps(denominatorExclusion.getSubjectResources());
                denominatorExclusion.getResources().retainAll(denominator.getResources());
                denominatorExclusion.getSubjects().retainAll(denominator.getSubjects());
                denominatorExclusion.retainOverlaps(denominator.getSubjectResources());
            }
            if (numeratorExclusion != null && applyScoring) {
                numeratorExclusion.getResources().retainAll(numerator.getResources());
                numeratorExclusion.getSubjects().retainAll(numerator.getSubjects());
                numeratorExclusion.retainOverlaps(numerator.getSubjectResources());
            }
            if (denominatorException != null && applyScoring) {
                denominatorException.getSubjects().removeAll(numerator.getSubjects());
                denominatorException.getResources().removeAll(numerator.getResources());
                denominatorException.removeOverlaps(numerator.getSubjectResources());
                denominatorException.getResources().retainAll(denominator.getResources());
                denominatorException.getSubjects().retainAll(denominator.getSubjects());
                denominatorException.retainOverlaps(denominator.getSubjectResources());
            }
        } else {
            if (denominatorExclusion != null && applyScoring) {
                numerator.getResources().removeAll(denominatorExclusion.getResources());
                numerator.removeOverlaps(denominatorExclusion.getSubjectResources());
                denominatorExclusion.getResources().retainAll(denominator.getResources());
                denominatorExclusion.retainOverlaps(denominator.getSubjectResources());
            }
            if (numeratorExclusion != null && applyScoring) {
                numeratorExclusion.getResources().retainAll(numerator.getResources());
                numeratorExclusion.retainOverlaps(numerator.getSubjectResources());
            }
            if (denominatorException != null && applyScoring) {
                denominatorException.getResources().removeAll(numerator.getResources());
                denominatorException.removeOverlaps(numerator.getSubjectResources());
                denominatorException.getResources().retainAll(denominator.getResources());
                denominatorException.retainOverlaps(denominator.getSubjectResources());
            }
        }
        if (reportType.equals((Object)MeasureReportType.INDIVIDUAL) && dateOfCompliance != null) {
            Object doc = this.evaluateDateOfCompliance(dateOfCompliance, evaluationResult);
            dateOfCompliance.addResource(doc);
        }
    }

    protected void evaluateContinuousVariable(GroupDef groupDef, String subjectType, String subjectId, EvaluationResult evaluationResult, boolean applyScoring) {
        PopulationDef initialPopulation = groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION);
        PopulationDef measurePopulation = groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATION);
        PopulationDef measurePopulationExclusion = groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATIONEXCLUSION);
        R4MeasureScoringTypePopulations.validateScoringTypePopulations(groupDef.populations().stream().map(PopulationDef::type).toList(), MeasureScoring.CONTINUOUSVARIABLE);
        initialPopulation = this.evaluatePopulationMembership(subjectType, subjectId, initialPopulation, evaluationResult);
        if (initialPopulation.getSubjects().contains(subjectId)) {
            measurePopulation = this.evaluatePopulationMembership(subjectType, subjectId, measurePopulation, evaluationResult);
            if (measurePopulationExclusion != null) {
                this.evaluatePopulationMembership(subjectType, subjectId, groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATIONEXCLUSION), evaluationResult);
                if (applyScoring) {
                    measurePopulationExclusion.getResources().retainAll(measurePopulation.getResources());
                    measurePopulationExclusion.getSubjects().retainAll(measurePopulation.getSubjects());
                }
            }
        }
    }

    protected void evaluateCohort(GroupDef groupDef, String subjectType, String subjectId, EvaluationResult evaluationResult, boolean applyScoring) {
        PopulationDef initialPopulation = groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION);
        R4MeasureScoringTypePopulations.validateScoringTypePopulations(groupDef.populations().stream().map(PopulationDef::type).toList(), MeasureScoring.COHORT);
        this.evaluatePopulationMembership(subjectType, subjectId, initialPopulation, evaluationResult);
    }

    protected void evaluateGroup(MeasureDef measureDef, GroupDef groupDef, String subjectType, String subjectId, MeasureReportType reportType, EvaluationResult evaluationResult, boolean applyScoring) {
        this.populationBasisValidator.validateGroupPopulations(measureDef, groupDef, evaluationResult);
        this.populationBasisValidator.validateStratifiers(measureDef, groupDef, evaluationResult);
        this.evaluateStratifiers(subjectId, groupDef.stratifiers(), evaluationResult);
        MeasureScoring scoring = groupDef.measureScoring();
        switch (scoring) {
            case PROPORTION: 
            case RATIO: {
                this.evaluateProportion(groupDef, subjectType, subjectId, reportType, evaluationResult, applyScoring);
                break;
            }
            case CONTINUOUSVARIABLE: {
                this.evaluateContinuousVariable(groupDef, subjectType, subjectId, evaluationResult, applyScoring);
                break;
            }
            case COHORT: {
                this.evaluateCohort(groupDef, subjectType, subjectId, evaluationResult, applyScoring);
            }
        }
    }

    protected Object evaluateDateOfCompliance(PopulationDef populationDef, EvaluationResult evaluationResult) {
        return evaluationResult.forExpression(populationDef.expression()).value();
    }

    protected void evaluateSdes(String subjectId, List<SdeDef> sdes, EvaluationResult evaluationResult) {
        for (SdeDef sde : sdes) {
            List list;
            ExpressionResult expressionResult = evaluationResult.forExpression(sde.expression());
            Object result = expressionResult.value();
            if (result instanceof List && (list = (List)result).size() == 1 && list.get(0) == null) {
                result = null;
            }
            sde.putResult(subjectId, result, expressionResult.evaluatedResources());
        }
    }

    protected Object addStratifierResult(Object result, String subjectId) {
        if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            Iterator resultIter = iterable.iterator();
            result = !resultIter.hasNext() ? null : resultIter.next();
            if (resultIter.hasNext()) {
                throw new InvalidRequestException("stratifiers may not return multiple values for subjectId: " + subjectId);
            }
        }
        return result;
    }

    protected void addStratifierComponentResult(List<StratifierComponentDef> components, EvaluationResult evaluationResult, String subjectId) {
        for (StratifierComponentDef component : components) {
            ExpressionResult expressionResult = evaluationResult.forExpression(component.expression());
            Object result = this.addStratifierResult(expressionResult.value(), subjectId);
            if (result == null) continue;
            component.putResult(subjectId, result, expressionResult.evaluatedResources());
        }
    }

    protected void evaluateStratifiers(String subjectId, List<StratifierDef> stratifierDefs, EvaluationResult evaluationResult) {
        for (StratifierDef sd : stratifierDefs) {
            if (!sd.components().isEmpty()) {
                this.addStratifierComponentResult(sd.components(), evaluationResult, subjectId);
                continue;
            }
            ExpressionResult expressionResult = evaluationResult.forExpression(sd.expression());
            Object result = this.addStratifierResult(expressionResult.value(), subjectId);
            if (result == null) continue;
            sd.putResult(subjectId, result, expressionResult.evaluatedResources());
        }
    }
}

