/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.common;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvaluator;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationBasisValidator;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.helper.DateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureProcessorUtils {
    private static final Logger logger = LoggerFactory.getLogger(MeasureProcessorUtils.class);

    public void processResults(Map<String, EvaluationResult> results, MeasureDef measureDef, @Nonnull MeasureEvalType measureEvalType, boolean applyScoring, PopulationBasisValidator populationBasisValidator) {
        MeasureEvaluator evaluator = new MeasureEvaluator(populationBasisValidator);
        for (Map.Entry<String, EvaluationResult> entry : results.entrySet()) {
            String subjectId = entry.getKey();
            Pair<String, String> sub = this.getSubjectTypeAndId(subjectId);
            String subjectIdPart = (String)sub.getRight();
            String subjectTypePart = (String)sub.getLeft();
            EvaluationResult evalResult = entry.getValue();
            try {
                evaluator.evaluate(measureDef, measureEvalType, subjectTypePart, subjectIdPart, evalResult, applyScoring);
            }
            catch (Exception e) {
                String error = "Exception for subjectId: %s, Message: %s".formatted(subjectId, e.getMessage());
                measureDef.addError(error);
                logger.error(error, (Throwable)e);
            }
        }
    }

    public void continuousVariableObservation(MeasureDef measureDef, CqlEngine context) {
        for (GroupDef groupDef : measureDef.groups()) {
            if (!groupDef.measureScoring().equals((Object)MeasureScoring.CONTINUOUSVARIABLE) || groupDef.getSingle(MeasurePopulationType.MEASUREOBSERVATION) == null) continue;
            PopulationDef measurePopulation = groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATION);
            PopulationDef measureObservation = groupDef.getSingle(MeasurePopulationType.MEASUREOBSERVATION);
            for (Object resource : measurePopulation.getResources()) {
                Object observationResult = this.evaluateObservationCriteria(resource, measureObservation.expression(), measureObservation.getEvaluatedResources(), groupDef.isBooleanBasis(), context);
                measureObservation.addResource(observationResult);
            }
        }
    }

    @Nullable
    public static ZonedDateTime getZonedTimeZoneForEval(@Nullable Interval interval) {
        return Optional.ofNullable(interval).map(Interval::getLow).filter(DateTime.class::isInstance).map(DateTime.class::cast).map(DateTime::getZoneOffset).map(zoneOffset -> LocalDateTime.now().atOffset((ZoneOffset)zoneOffset).toZonedDateTime()).orElse(null);
    }

    public ParameterDef getMeasurementPeriodParameterDef(CqlEngine context) {
        Library lib = context.getState().getCurrentLibrary();
        if (lib.getParameters() == null || lib.getParameters().getDef() == null || lib.getParameters().getDef().isEmpty()) {
            return null;
        }
        for (ParameterDef pd : lib.getParameters().getDef()) {
            if (!pd.getName().equals("Measurement Period")) continue;
            return pd;
        }
        return null;
    }

    public void setMeasurementPeriod(MeasureDef measureDef, Interval measurementPeriod, CqlEngine context) {
        ParameterDef pd = this.getMeasurementPeriodParameterDef(context);
        if (pd == null) {
            logger.warn("Parameter \"{}\" was not found. Unable to validate type.", (Object)"Measurement Period");
            context.getState().setParameter(null, "Measurement Period", (Object)measurementPeriod);
            return;
        }
        if (measurementPeriod == null && pd.getDefault() == null) {
            logger.warn("No default or value supplied for Parameter \"{}\". This may result in incorrect results or errors.", (Object)"Measurement Period");
            return;
        }
        if (measurementPeriod == null) {
            measurementPeriod = (Interval)context.getEvaluationVisitor().visitParameterDef(pd, (Object)context.getState());
            context.getState().setParameter(null, "Measurement Period", (Object)MeasureProcessorUtils.cloneIntervalWithUtc(measurementPeriod));
            return;
        }
        IntervalTypeSpecifier intervalTypeSpecifier = (IntervalTypeSpecifier)pd.getParameterTypeSpecifier();
        if (intervalTypeSpecifier == null) {
            logger.debug("No ELM type information available. Unable to validate type of \"{}\"", (Object)"Measurement Period");
            context.getState().setParameter(null, "Measurement Period", (Object)measurementPeriod);
            return;
        }
        NamedTypeSpecifier pointType = (NamedTypeSpecifier)intervalTypeSpecifier.getPointType();
        String targetType = pointType.getName().getLocalPart();
        Interval convertedPeriod = this.convertInterval(measureDef, measurementPeriod, targetType);
        context.getState().setParameter(null, "Measurement Period", (Object)convertedPeriod);
    }

    public Interval getDefaultMeasurementPeriod(Interval measurementPeriod, CqlEngine context) {
        if (measurementPeriod == null) {
            return (Interval)context.getState().getParameters().get("Measurement Period");
        }
        return measurementPeriod;
    }

    private static Interval cloneIntervalWithUtc(Interval interval) {
        Object startAsObject = interval.getStart();
        Object endAsObject = interval.getEnd();
        if (startAsObject instanceof DateTime) {
            DateTime time = (DateTime)startAsObject;
            if (endAsObject instanceof DateTime) {
                DateTime time1 = (DateTime)endAsObject;
                return new Interval((Object)MeasureProcessorUtils.cloneDateTimeWithUtc(time), true, (Object)MeasureProcessorUtils.cloneDateTimeWithUtc(time1), true);
            }
        }
        return interval;
    }

    private static DateTime cloneDateTimeWithUtc(DateTime dateTime) {
        DateTime newDateTime = new DateTime(dateTime.getDateTime().withOffsetSameLocal(ZoneOffset.UTC));
        newDateTime.setPrecision(dateTime.getPrecision());
        return newDateTime;
    }

    public Interval convertInterval(MeasureDef measureDef, Interval interval, String targetType) {
        String sourceTypeQualified = interval.getPointType().getTypeName();
        String sourceType = sourceTypeQualified.substring(sourceTypeQualified.lastIndexOf(".") + 1);
        if (sourceType.equals(targetType)) {
            return interval;
        }
        if (sourceType.equals("DateTime") && targetType.equals("Date")) {
            logger.debug("A DateTime interval was provided and a Date interval was expected. The DateTime will be truncated.");
            return new Interval((Object)this.truncateDateTime((DateTime)interval.getLow()), interval.getLowClosed(), (Object)this.truncateDateTime((DateTime)interval.getHigh()), interval.getHighClosed());
        }
        throw new InvalidRequestException("The interval type of %s did not match the expected type of %s and no conversion was possible for MeasureDef: %s.".formatted(sourceType, targetType, measureDef.url()));
    }

    public Date truncateDateTime(DateTime dateTime) {
        OffsetDateTime odt = dateTime.getDateTime();
        return new Date(odt.getYear(), odt.getMonthValue(), odt.getDayOfMonth());
    }

    public void captureEvaluatedResources(Set<Object> outEvaluatedResources, CqlEngine context) {
        if (outEvaluatedResources != null && context.getState().getEvaluatedResources() != null) {
            outEvaluatedResources.addAll(context.getState().getEvaluatedResources());
        }
        this.clearEvaluatedResources(context);
    }

    private void clearEvaluatedResources(CqlEngine context) {
        context.getState().clearEvaluatedResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateObservationCriteria(Object resource, String criteriaExpression, Set<Object> outEvaluatedResources, boolean isBooleanBasis, CqlEngine context) {
        Object result;
        ExpressionDef ed = Libraries.resolveExpressionRef((String)criteriaExpression, (Library)context.getState().getCurrentLibrary());
        if (!(ed instanceof FunctionDef)) {
            throw new InvalidRequestException("Measure observation %s does not reference a function definition".formatted(criteriaExpression));
        }
        context.getState().pushActivationFrame((Element)ed);
        try {
            if (!isBooleanBasis) {
                context.getState().push(new Variable(((OperandDef)((FunctionDef)ed).getOperand().get(0)).getName()).withValue(resource));
            }
            result = context.getEvaluationVisitor().visitExpression(ed.getExpression(), context.getState());
        }
        finally {
            context.getState().popActivationFrame();
        }
        this.captureEvaluatedResources(outEvaluatedResources, context);
        return result;
    }

    public Map<String, EvaluationResult> getEvaluationResults(List<String> subjectIds, MeasureDef measureDef, ZonedDateTime zonedMeasurementPeriod, CqlEngine context, LibraryEngine libraryEngine, VersionedIdentifier id) {
        HashMap<String, EvaluationResult> result = new HashMap<String, EvaluationResult>();
        for (String subjectId : subjectIds) {
            if (subjectId == null) {
                throw new NullPointerException("SubjectId is required in order to calculate.");
            }
            Pair<String, String> subjectInfo = this.getSubjectTypeAndId(subjectId);
            String subjectTypePart = (String)subjectInfo.getLeft();
            String subjectIdPart = (String)subjectInfo.getRight();
            context.getState().setContextValue(subjectTypePart, (Object)subjectIdPart);
            try {
                result.put(subjectId, libraryEngine.getEvaluationResult(id, subjectId, null, null, null, null, null, zonedMeasurementPeriod, context));
            }
            catch (Exception e) {
                String error = "Exception for subjectId: %s, Message: %s".formatted(subjectId, e.getMessage());
                measureDef.addError(error);
                logger.error(error, (Throwable)e);
            }
        }
        return result;
    }

    public Pair<String, String> getSubjectTypeAndId(String subjectId) {
        if (subjectId.contains("/")) {
            String[] subjectIdParts = subjectId.split("/");
            return Pair.of((Object)subjectIdParts[0], (Object)subjectIdParts[1]);
        }
        throw new InvalidRequestException("Unable to determine Subject type for id: %s. SubjectIds must be in the format {subjectType}/{subjectId} (e.g. Patient/123)".formatted(subjectId));
    }

    public MeasureEvalType getEvalType(MeasureEvalType evalType, String reportType, List<String> subjectIds) {
        if (evalType == null) {
            evalType = MeasureEvalType.fromCode(reportType).orElse(subjectIds == null || subjectIds.isEmpty() || subjectIds.get(0) == null ? MeasureEvalType.POPULATION : MeasureEvalType.SUBJECT);
        }
        return evalType;
    }

    public Interval buildMeasurementPeriod(String periodStart, String periodEnd) {
        if (periodStart == null || periodEnd == null) {
            return null;
        }
        return new Interval((Object)DateHelper.resolveRequestDate(periodStart, true), true, (Object)DateHelper.resolveRequestDate(periodEnd, false), true);
    }
}

