/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;

public class PopulationDef {
    private final String id;
    private final String expression;
    private final ConceptDef code;
    private final MeasurePopulationType measurePopulationType;
    protected Set<Object> evaluatedResources;
    protected Set<Object> resources;
    protected Set<String> subjects;
    protected Map<String, Set<Object>> subjectResources = new HashMap<String, Set<Object>>();

    public PopulationDef(String id, ConceptDef code, MeasurePopulationType measurePopulationType, String expression) {
        this.id = id;
        this.code = code;
        this.measurePopulationType = measurePopulationType;
        this.expression = expression;
    }

    public MeasurePopulationType type() {
        return this.measurePopulationType;
    }

    public String id() {
        return this.id;
    }

    public ConceptDef code() {
        return this.code;
    }

    public void addEvaluatedResource(Object resource) {
        this.getEvaluatedResources().add(resource);
    }

    public Set<Object> getEvaluatedResources() {
        if (this.evaluatedResources == null) {
            this.evaluatedResources = new HashSet<Object>();
        }
        return this.evaluatedResources;
    }

    public void addSubject(String subject) {
        this.getSubjects().add(subject);
    }

    public void removeSubject(String subject) {
        this.getSubjects().remove(subject);
    }

    public Set<String> getSubjects() {
        if (this.subjects == null) {
            this.subjects = new HashSet<String>();
        }
        return this.subjects;
    }

    public void addResource(Object resource) {
        this.getResources().add(resource);
    }

    public Set<Object> getResources() {
        if (this.resources == null) {
            this.resources = new HashSet<Object>();
        }
        return this.resources;
    }

    public String expression() {
        return this.expression;
    }

    public Map<String, Set<Object>> getSubjectResources() {
        return this.subjectResources;
    }

    public void addResource(String key, Object value) {
        this.subjectResources.computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    public void removeOverlaps(Map<String, Set<Object>> overlap) {
        Iterator<Map.Entry<String, Set<Object>>> iterator = this.subjectResources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<Object>> entry = iterator.next();
            String key = entry.getKey();
            Set<Object> valuesInA = entry.getValue();
            if (overlap.containsKey(key)) {
                valuesInA.removeAll((Collection)overlap.get(key));
            }
            if (!valuesInA.isEmpty()) continue;
            iterator.remove();
        }
    }

    public void retainOverlaps(Map<String, Set<Object>> filterMap) {
        Iterator<Map.Entry<String, Set<Object>>> iterator = this.subjectResources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<Object>> entry = iterator.next();
            String key = entry.getKey();
            Set<Object> values = entry.getValue();
            if (!filterMap.containsKey(key)) {
                iterator.remove();
                continue;
            }
            values.retainAll((Collection)filterMap.get(key));
            if (!values.isEmpty()) continue;
            iterator.remove();
        }
    }
}

