/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.dstu3;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.Resource;
import org.opencds.cqf.fhir.cr.measure.common.CodeDef;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;

public class Dstu3MeasureDefBuilder
implements MeasureDefBuilder<Measure> {
    @Override
    public MeasureDef build(Measure measure) {
        this.checkId((Resource)measure);
        ArrayList<SdeDef> sdes = new ArrayList<SdeDef>();
        for (Measure.MeasureSupplementalDataComponent s : measure.getSupplementalData()) {
            this.checkId((Element)s);
            SdeDef sdeDef = new SdeDef(s.getId(), null, s.getCriteria());
            sdes.add(sdeDef);
        }
        MeasureScoring measureScoring = MeasureScoring.fromCode(measure.getScoring().getCodingFirstRep().getCode());
        CodeDef measureBasis = this.getMeasureBasis(measure);
        CodeDef measureImpNotation = this.getMeasureImprovementNotation(measure);
        if (measureScoring == null && measure.hasGroup()) {
            throw new InvalidRequestException("MeasureScoring must be specified on Measure: %s".formatted(measure.getUrl()));
        }
        ArrayList<GroupDef> groups = new ArrayList<GroupDef>();
        for (Measure.MeasureGroupComponent group : measure.getGroup()) {
            Object pop2;
            ArrayList<PopulationDef> populations = new ArrayList<PopulationDef>();
            for (Object pop2 : group.getPopulation()) {
                this.checkId((Element)pop2);
                MeasurePopulationType populationType = MeasurePopulationType.fromCode(pop2.getCode().getCodingFirstRep().getCode());
                populations.add(new PopulationDef(pop2.getId(), this.conceptToConceptDef(pop2.getCode()), populationType, pop2.getCriteria()));
            }
            ArrayList<StratifierDef> stratifiers = new ArrayList<StratifierDef>();
            pop2 = group.getStratifier().iterator();
            while (pop2.hasNext()) {
                Measure.MeasureGroupStratifierComponent mgsc = (Measure.MeasureGroupStratifierComponent)pop2.next();
                this.checkId((Element)mgsc);
                StratifierDef stratifierDef = new StratifierDef(mgsc.getId(), null, mgsc.getCriteria());
                stratifiers.add(stratifierDef);
            }
            GroupDef groupDef = new GroupDef(group.getId(), null, stratifiers, populations, measureScoring, false, this.getImprovementNotation(measureImpNotation), this.getPopulationBasisDef(measureBasis));
            groups.add(groupDef);
        }
        return new MeasureDef(measure.getId(), measure.getUrl(), measure.getVersion(), groups, sdes);
    }

    private PopulationDef checkPopulationForCode(List<PopulationDef> populations, MeasurePopulationType measurePopType) {
        return populations.stream().filter(e -> e.code().first().code().equals(measurePopType.toCode())).findAny().orElse(null);
    }

    private ConceptDef totalConceptDefCreator(MeasurePopulationType measurePopulationType) {
        return new ConceptDef(Collections.singletonList(new CodeDef(measurePopulationType.getSystem(), measurePopulationType.toCode())), null);
    }

    private ConceptDef conceptToConceptDef(CodeableConcept codeable) {
        if (codeable == null) {
            return null;
        }
        ArrayList<CodeDef> codes = new ArrayList<CodeDef>();
        for (Coding c : codeable.getCoding()) {
            codes.add(this.codeToCodeDef(c));
        }
        return new ConceptDef(codes, codeable.getText());
    }

    private CodeDef codeToCodeDef(Coding coding) {
        return new CodeDef(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay());
    }

    private void checkId(Element e) {
        if (e.getId() == null || StringUtils.isBlank((CharSequence)e.getId())) {
            throw new NullPointerException("id is required on all Elements of type: " + e.fhirType());
        }
    }

    private void checkId(Resource r) {
        if (r.getId() == null || StringUtils.isBlank((CharSequence)r.getId())) {
            throw new NullPointerException("id is required on all Resources of type: " + r.fhirType());
        }
    }

    private void validateImprovementNotationCode(Measure measure, CodeDef improvementNotation) {
        if (improvementNotation != null) {
            boolean hasValidCode;
            String code = improvementNotation.code();
            boolean bl = hasValidCode = "increase".equals(code) || "decrease".equals(code);
            if (!hasValidCode) {
                throw new IllegalArgumentException("ImprovementNotation Coding has invalid code: %s, combination for Measure: %s".formatted(code, measure.getUrl()));
            }
        }
    }

    public CodeDef getMeasureBasis(Measure measure) {
        Extension ext = measure.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis");
        if (ext != null) {
            return new CodeDef("http://hl7.org/fhir/fhir-types", ext.getValue().toString());
        }
        return null;
    }

    public CodeDef getMeasureImprovementNotation(Measure measure) {
        if (measure.hasImprovementNotation()) {
            CodeDef impNot = new CodeDef(null, measure.getImprovementNotation());
            this.validateImprovementNotationCode(measure, impNot);
            return impNot;
        }
        return null;
    }

    private CodeDef getPopulationBasisDef(CodeDef measureBasis) {
        if (measureBasis != null) {
            return measureBasis;
        }
        return new CodeDef("http://hl7.org/fhir/fhir-types", "boolean");
    }

    private CodeDef getImprovementNotation(CodeDef measureImpNotation) {
        if (measureImpNotation != null) {
            return measureImpNotation;
        }
        return new CodeDef(null, "increase");
    }
}

