/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.dstu3;

import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cqframework.cql.cql2elm.CqlIncludeException;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.fhir.model.Dstu3FhirModelResolver;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureProcessorUtils;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.SubjectProvider;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3MeasureReportBuilder;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3PopulationBasisValidator;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3RepositorySubjectProvider;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;

public class Dstu3MeasureProcessor {
    private final IRepository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private final SubjectProvider subjectProvider;
    private final MeasureProcessorUtils measureProcessorUtils = new MeasureProcessorUtils();

    public Dstu3MeasureProcessor(IRepository repository, MeasureEvaluationOptions measureEvaluationOptions) {
        this(repository, measureEvaluationOptions, new Dstu3RepositorySubjectProvider());
    }

    public Dstu3MeasureProcessor(IRepository repository, MeasureEvaluationOptions measureEvaluationOptions, SubjectProvider subjectProvider) {
        this.repository = Objects.requireNonNull(repository);
        this.measureEvaluationOptions = measureEvaluationOptions != null ? measureEvaluationOptions : MeasureEvaluationOptions.defaultOptions();
        this.subjectProvider = subjectProvider;
    }

    public MeasureReport evaluateMeasure(IdType measureId, String periodStart, String periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters) {
        Measure measure = (Measure)this.repository.read(Measure.class, (IIdType)measureId);
        return this.evaluateMeasure(measure, periodStart, periodEnd, reportType, subjectIds, additionalData, parameters);
    }

    protected MeasureReport evaluateMeasure(Measure measure, String periodStart, String periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters) {
        this.checkMeasureLibrary(measure);
        Interval measurementPeriodParams = this.measureProcessorUtils.buildMeasurementPeriod(periodStart, periodEnd);
        MeasureDef measureDef = new Dstu3MeasureDefBuilder().build(measure);
        IRepository actualRepo = this.repository;
        if (additionalData != null) {
            actualRepo = new FederatedRepository(this.repository, new IRepository[]{new InMemoryFhirRepository(this.repository.fhirContext(), additionalData)});
        }
        List<String> subjects = this.subjectProvider.getSubjects(actualRepo, subjectIds).collect(Collectors.toList());
        MeasureEvalType evalType = this.getMeasureEvalType(reportType, subjects);
        CqlEngine context = Engines.forRepository((IRepository)this.repository, (EvaluationSettings)this.measureEvaluationOptions.getEvaluationSettings(), (IBaseBundle)additionalData);
        VersionedIdentifier libraryVersionIdentifier = this.getLibraryVersionIdentifier(measure);
        LibraryEngine libraryEngine = this.getLibraryEngine(parameters, libraryVersionIdentifier, context);
        this.measureProcessorUtils.setMeasurementPeriod(measureDef, measurementPeriodParams, context);
        Interval measurementPeriod = this.measureProcessorUtils.getDefaultMeasurementPeriod(measurementPeriodParams, context);
        ZonedDateTime zonedMeasurementPeriod = MeasureProcessorUtils.getZonedTimeZoneForEval(measurementPeriod);
        if (!subjects.isEmpty()) {
            Map<String, EvaluationResult> results = this.measureProcessorUtils.getEvaluationResults(subjectIds, measureDef, zonedMeasurementPeriod, context, libraryEngine, libraryVersionIdentifier);
            this.measureProcessorUtils.processResults(results, measureDef, evalType, this.measureEvaluationOptions.getApplyScoringSetMembership(), new Dstu3PopulationBasisValidator());
        }
        this.measureProcessorUtils.continuousVariableObservation(measureDef, context);
        return new Dstu3MeasureReportBuilder().build(measure, measureDef, this.evalTypeToReportType(evalType), measurementPeriod, subjects);
    }

    protected MeasureReportType evalTypeToReportType(MeasureEvalType measureEvalType) {
        switch (measureEvalType) {
            case PATIENT: 
            case SUBJECT: {
                return MeasureReportType.INDIVIDUAL;
            }
            case PATIENTLIST: 
            case SUBJECTLIST: {
                return MeasureReportType.PATIENTLIST;
            }
            case POPULATION: {
                return MeasureReportType.SUMMARY;
            }
        }
        throw new InvalidRequestException("Unsupported MeasureEvalType: %s".formatted(measureEvalType.toCode()));
    }

    protected LibraryEngine getLibraryEngine(Parameters parameters, VersionedIdentifier id, CqlEngine context) {
        CompiledLibrary lib;
        try {
            lib = context.getEnvironment().getLibraryManager().resolveLibrary(id);
        }
        catch (CqlIncludeException e) {
            throw new IllegalStateException("Unable to load CQL/ELM for library: %s. Verify that the Library resource is available in your environment and has CQL/ELM content embedded.".formatted(id.getId()), e);
        }
        context.getState().init(lib.getLibrary());
        if (parameters != null) {
            Map<String, Object> paramMap = this.resolveParameterMap(parameters);
            context.getState().setParameters(lib.getLibrary(), paramMap);
            if (lib.getLibrary().getIncludes() != null) {
                lib.getLibrary().getIncludes().getDef().forEach(includeDef -> paramMap.forEach((paramKey, paramValue) -> context.getState().setParameter(includeDef.getLocalIdentifier(), paramKey, paramValue)));
            }
        }
        return new LibraryEngine(this.repository, this.measureEvaluationOptions.getEvaluationSettings());
    }

    private VersionedIdentifier getLibraryVersionIdentifier(Measure measure) {
        Reference reference = (Reference)measure.getLibrary().get(0);
        Library library = (Library)this.repository.read(Library.class, reference.getReferenceElement());
        return new VersionedIdentifier().withId(library.getName()).withVersion(library.getVersion());
    }

    private MeasureEvalType getMeasureEvalType(String reportType, List<String> subjectIds) {
        return MeasureEvalType.fromCode(reportType).orElse(subjectIds == null || subjectIds.isEmpty() || subjectIds.get(0) == null ? MeasureEvalType.POPULATION : MeasureEvalType.SUBJECT);
    }

    private void checkMeasureLibrary(Measure measure) {
        if (!measure.hasLibrary()) {
            throw new InvalidRequestException("Measure %s does not have a primary library specified".formatted(measure.getUrl()));
        }
    }

    private Map<String, Object> resolveParameterMap(Parameters parameters) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Dstu3FhirModelResolver modelResolver = new Dstu3FhirModelResolver();
        parameters.getParameter().forEach(param -> {
            Object value;
            if (param.hasResource()) {
                value = param.getResource();
            } else {
                value = param.getValue();
                if (value instanceof IPrimitiveType) {
                    IPrimitiveType type = (IPrimitiveType)value;
                    value = modelResolver.toJavaPrimitive(type.getValue(), value);
                }
            }
            if (parameterMap.containsKey(param.getName())) {
                if (parameterMap.get(param.getName()) instanceof List) {
                    if (value != null) {
                        List list = (List)parameterMap.get(param.getName());
                        list.add(value);
                    }
                } else {
                    parameterMap.put(param.getName(), Arrays.asList(parameterMap.get(param.getName()), value));
                }
            } else {
                parameterMap.put(param.getName(), value);
            }
        });
        return parameterMap;
    }
}

