/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.dstu3;

import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.util.BundleBuilder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.constant.MeasureReportConstants;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3MeasureEvaluatorSingle;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3MeasureProcessor;

public class Dstu3MeasureService
implements Dstu3MeasureEvaluatorSingle {
    private final IRepository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    public static final List<ContactDetail> CQI_CONTACT_DETAIL = Collections.singletonList(new ContactDetail().addTelecom(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.URL).setValue("http://www.hl7.org/Special/committees/cqi/index.cfm")));
    public static final List<CodeableConcept> US_JURISDICTION_CODING = Collections.singletonList(new CodeableConcept().addCoding(new Coding("urn:iso:std:iso:3166", "US", "United States of America")));
    public static final SearchParameter SUPPLEMENTAL_DATA_SEARCHPARAMETER = (SearchParameter)new SearchParameter().setUrl("http://hl7.org/fhir/us/davinci-deqm/SearchParameter/measurereport-supplemental-data").setVersion("0.1.0").setName("DEQMMeasureReportSupplementalData").setStatus(Enumerations.PublicationStatus.ACTIVE).setDate((Date)MeasureReportConstants.MEASUREREPORT_SUPPLEMENTALDATA_SEARCHPARAMETER_DEFINITION_DATE).setPublisher("HL7 International - Clinical Quality Information Work Group").setContact(CQI_CONTACT_DETAIL).setDescription("Returns resources (supplemental data) from references on extensions on the MeasureReport with urls matching %s.".formatted("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setJurisdiction(US_JURISDICTION_CODING).addBase("MeasureReport").setCode("supplemental-data").setType(Enumerations.SearchParamType.REFERENCE).setExpression("MeasureReport.extension('%s').value".formatted("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpath("f:MeasureReport/f:extension[@url='%s'].value".formatted("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpathUsage(SearchParameter.XPathUsageType.NORMAL).setTitle("Supplemental Data").setId("deqm-measurereport-supplemental-data");

    public Dstu3MeasureService(IRepository repository, MeasureEvaluationOptions measureEvaluationOptions) {
        this.repository = repository;
        this.measureEvaluationOptions = measureEvaluationOptions;
    }

    @Override
    public MeasureReport evaluateMeasure(IdType id, String periodStart, String periodEnd, String reportType, String subject, String practitioner, String lastReceivedOn, String productLine, Bundle additionalData, Parameters parameters, Endpoint terminologyEndpoint) {
        this.ensureSupplementalDataElementSearchParameter();
        Dstu3MeasureProcessor dstu3MeasureProcessor = new Dstu3MeasureProcessor(this.repository, this.measureEvaluationOptions);
        MeasureReport report = dstu3MeasureProcessor.evaluateMeasure(id, periodStart, periodEnd, reportType, Collections.singletonList(subject), (IBaseBundle)additionalData, parameters);
        if (productLine != null) {
            Extension ext = new Extension();
            ext.setUrl("http://hl7.org/fhir/us/cqframework/cqfmeasures/StructureDefinition/cqfm-productLine");
            ext.setValue((Type)new StringType(productLine));
            report.addExtension(ext);
        }
        return report;
    }

    protected void ensureSupplementalDataElementSearchParameter() {
        BundleBuilder builder = new BundleBuilder(this.repository.fhirContext());
        builder.addTransactionCreateEntry((IBaseResource)SUPPLEMENTAL_DATA_SEARCHPARAMETER).conditional("code=supplemental-data");
        this.repository.transaction(builder.getBundle());
    }
}

