/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.opencds.cqf.fhir.cr.measure.CareGapsProperties;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePeriodValidator;
import org.opencds.cqf.fhir.cr.measure.r4.R4CareGapsProcessor;
import org.opencds.cqf.fhir.cr.measure.r4.R4CareGapsServiceInterface;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.monad.Eithers;

public class R4CareGapsService
implements R4CareGapsServiceInterface {
    private final R4CareGapsProcessor r4CareGapsProcessor;

    public R4CareGapsService(CareGapsProperties careGapsProperties, IRepository repository, MeasureEvaluationOptions measureEvaluationOptions, String serverBase, MeasurePeriodValidator measurePeriodEvalutator) {
        this.r4CareGapsProcessor = new R4CareGapsProcessor(careGapsProperties, repository, measureEvaluationOptions, serverBase, measurePeriodEvalutator);
    }

    @Override
    public Parameters getCareGapsReport(@Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, @Nullable String subject, List<String> status, List<IdType> measureId, List<String> measureIdentifier, List<CanonicalType> measureUrl, boolean notDocument) {
        return this.r4CareGapsProcessor.getCareGapsReport(periodStart, periodEnd, subject, status, this.liftMeasureParameters(measureId, measureIdentifier, measureUrl), notDocument);
    }

    @Override
    public List<Either3<IdType, String, CanonicalType>> liftMeasureParameters(List<IdType> measureId, List<String> measureIdentifier, List<CanonicalType> measureUrl) {
        ArrayList<Either3<IdType, String, CanonicalType>> eitherList = new ArrayList<Either3<IdType, String, CanonicalType>>();
        Optional.ofNullable(measureId).ifPresent(list -> measureId.stream().filter(this::isValidMeasureIdType).map(Eithers::forLeft3).forEach(eitherList::add));
        Optional.ofNullable(measureIdentifier).ifPresent(list -> measureIdentifier.stream().filter(Objects::nonNull).map(Eithers::forMiddle3).forEach(eitherList::add));
        Optional.ofNullable(measureUrl).ifPresent(list -> measureUrl.stream().filter(this::isValidCanonical).map(Eithers::forRight3).forEach(eitherList::add));
        if (eitherList.isEmpty()) {
            List measureIdsAsStrings = Optional.ofNullable(measureId).map(nonNullMeasureId -> nonNullMeasureId.stream().map(IdType::getIdPart).collect(Collectors.toList())).orElse(Collections.emptyList());
            throw new InvalidRequestException("no measure resolving parameter was specified for Measure: " + String.valueOf(measureIdsAsStrings));
        }
        return eitherList;
    }

    private boolean isValidCanonical(CanonicalType canonicalType) {
        return canonicalType != null && !canonicalType.toString().contains("null");
    }

    private boolean isValidMeasureIdType(IdType measureId) {
        return measureId != null && measureId.getIdPart() != null;
    }
}

