/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlCompilerOptions;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.elm.requirements.fhir.DataRequirementsProcessor;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.conv40_50.VersionConvertor_40_50;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.cql.engine.fhir.exception.FhirVersionMisMatchException;
import org.opencds.cqf.cql.engine.fhir.retrieve.R4FhirQueryGenerator;
import org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterResolver;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.fhir.cql.cql2elm.content.RepositoryFhirLibrarySourceProvider;
import org.opencds.cqf.fhir.cql.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.fhir.cql.engine.terminology.RepositoryTerminologyProvider;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.helper.DateHelper;
import org.opencds.cqf.fhir.cr.measure.helper.SubjectContext;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Libraries;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.AdapterFactory;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4DataRequirementsService {
    private static final Logger ourLog = LoggerFactory.getLogger(R4DataRequirementsService.class);
    private final IRepository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private static final String EXTENSION_URL_FHIR_QUERY_PATTERN = "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-fhirQueryPattern";

    public R4DataRequirementsService(IRepository repository, MeasureEvaluationOptions measureEvaluationOptions) {
        this.repository = repository;
        this.measureEvaluationOptions = measureEvaluationOptions;
    }

    public Library dataRequirements(IdType measureId, String periodStart, String periodEnd) {
        Measure measure = (Measure)this.repository.read(Measure.class, (IIdType)measureId);
        Library library = this.getLibraryFromMeasure(measure);
        if (library == null) {
            throw new ResourceNotFoundException(((CanonicalType)measure.getLibrary().get(0)).asStringValue());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)periodStart) && StringUtils.isNotBlank((CharSequence)periodEnd)) {
            Interval measurementPeriod = new Interval((Object)DateHelper.resolveRequestDate(periodStart, true), true, (Object)DateHelper.resolveRequestDate(periodEnd, false), true);
            parameters.put("MeasurementPeriod", measurementPeriod);
            return this.processDataRequirements(measure, library, parameters);
        }
        ourLog.warn("periodStart & periodEnd was defaulted to empty");
        return this.processDataRequirements(library, parameters);
    }

    public Library getLibraryFromMeasure(Measure measure) {
        Iterator libraryIter = measure.getLibrary().iterator();
        String libraryIdOrCanonical = null;
        while (libraryIter.hasNext() && libraryIdOrCanonical == null) {
            CanonicalType ref = (CanonicalType)libraryIter.next();
            if (ref == null) continue;
            libraryIdOrCanonical = (String)ref.getValue();
        }
        Library library = null;
        try {
            library = (Library)this.repository.read(Library.class, (IIdType)new IdType(libraryIdOrCanonical));
        }
        catch (Exception e) {
            ourLog.info("Library read failed as measure.getLibrary() is not an ID, fall back to search as canonical");
        }
        if (library == null) {
            library = this.fetchDependencyLibrary(libraryIdOrCanonical);
        }
        return library;
    }

    private static LibrarySourceProvider buildLibrarySource(IRepository repository) {
        AdapterFactory adapterFactory = new AdapterFactory();
        return new RepositoryFhirLibrarySourceProvider(repository, (IAdapterFactory)adapterFactory, new LibraryVersionSelector((IAdapterFactory)adapterFactory));
    }

    private LibraryManager createLibraryManager(Library library) {
        LibrarySourceProvider librarySourceProvider = R4DataRequirementsService.buildLibrarySource(this.repository);
        Bundle libraryBundle = new Bundle();
        List<Library> listLib = this.fetchDependencyLibraries(library);
        listLib.add(library);
        listLib.forEach(lib -> {
            Bundle.BundleEntryComponent component = new Bundle.BundleEntryComponent();
            component.setResource((org.hl7.fhir.r4.model.Resource)lib);
            libraryBundle.addEntry(component);
        });
        ArrayList<LibrarySourceProvider> sourceProviders = new ArrayList<LibrarySourceProvider>(Arrays.asList(librarySourceProvider, librarySourceProvider));
        LibraryManager ll = new LibraryManager(new ModelManager());
        for (LibrarySourceProvider lsp : sourceProviders) {
            ll.getLibrarySourceLoader().registerProvider(lsp);
        }
        return ll;
    }

    public static CqlTranslator getTranslator(InputStream cqlStream, LibraryManager libraryManager) {
        CqlTranslator translator;
        try {
            translator = CqlTranslator.fromStream((InputStream)cqlStream, (LibraryManager)libraryManager);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Errors occurred translating library: %s".formatted(e.getMessage()));
        }
        return translator;
    }

    private CqlTranslator translateLibrary(Library library, LibraryManager libraryManager) {
        CqlTranslator translator = R4DataRequirementsService.getTranslator(new ByteArrayInputStream((byte[])Libraries.getContent((IBaseResource)library, (String)"text/cql").get()), libraryManager);
        if (!translator.getErrors().isEmpty()) {
            throw new RuntimeException(((CqlCompilerException)translator.getErrors().get(0)).getMessage());
        }
        return translator;
    }

    private Library processDataRequirements(Library library, Map<String, Object> parameters) {
        LibraryManager libraryManager = this.createLibraryManager(library);
        CqlTranslator translator = this.translateLibrary(library, libraryManager);
        ModelResolver modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)FhirVersionEnum.R4);
        SearchParameterResolver searchParameterResolver = new SearchParameterResolver(this.repository.fhirContext());
        RepositoryTerminologyProvider terminologyProvider = new RepositoryTerminologyProvider(this.repository, this.measureEvaluationOptions.getEvaluationSettings().getValueSetCache(), this.measureEvaluationOptions.getEvaluationSettings().getTerminologySettings());
        return R4DataRequirementsService.getModuleDefinitionLibraryR4(libraryManager, translator.getTranslatedLibrary(), searchParameterResolver, (TerminologyProvider)terminologyProvider, modelResolver, null, parameters, this.measureEvaluationOptions);
    }

    public static Library getModuleDefinitionLibraryR4(LibraryManager libraryManager, CompiledLibrary translatedLibrary, SearchParameterResolver searchParameterResolver, TerminologyProvider terminologyProvider, ModelResolver modelResolver, IBaseConformance capStatement, Map<String, Object> parameters, MeasureEvaluationOptions measureEvaluationOptions) {
        org.hl7.fhir.r5.model.Library libraryR5 = R4DataRequirementsService.getModuleDefinitionLibraryR5(libraryManager, translatedLibrary, measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlCompilerOptions(), parameters);
        VersionConvertor_40_50 versionConvertor_40_50 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
        Library libraryR4 = (Library)versionConvertor_40_50.convertResource((Resource)libraryR5);
        libraryR4 = R4DataRequirementsService.addDataRequirementFhirQueries(libraryR4, searchParameterResolver, terminologyProvider, modelResolver, measureEvaluationOptions, capStatement);
        return libraryR4;
    }

    private Library processDataRequirements(Measure measure, Library library, Map<String, Object> parameters) {
        LibraryManager libraryManager = this.createLibraryManager(library);
        CqlTranslator translator = this.translateLibrary(library, libraryManager);
        ModelResolver modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)FhirVersionEnum.R4);
        SearchParameterResolver searchParameterResolver = new SearchParameterResolver(this.repository.fhirContext());
        RepositoryTerminologyProvider terminologyProvider = new RepositoryTerminologyProvider(this.repository, this.measureEvaluationOptions.getEvaluationSettings().getValueSetCache(), this.measureEvaluationOptions.getEvaluationSettings().getTerminologySettings());
        return R4DataRequirementsService.getModuleDefinitionLibraryR4(measure, libraryManager, translator.getTranslatedLibrary(), this.measureEvaluationOptions, searchParameterResolver, (TerminologyProvider)terminologyProvider, modelResolver, null, parameters);
    }

    private List<Library> fetchDependencyLibraries(Library library) {
        HashMap<String, Library> resources = new HashMap<String, Library>();
        ArrayList<Library> queue = new ArrayList<Library>();
        queue.add(library);
        while (!queue.isEmpty()) {
            Library current = (Library)queue.get(0);
            queue.remove(0);
            this.visitLibrary(current, queue, resources);
        }
        return new ArrayList<Library>(resources.values());
    }

    private void visitLibrary(Library library, List<Library> queue, Map<String, Library> resources) {
        for (RelatedArtifact relatedArtifact : library.getRelatedArtifact()) {
            String resourceCanonical;
            Library lib;
            if (!relatedArtifact.getType().equals((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON) || !relatedArtifact.hasResource() || (lib = this.fetchDependencyLibrary(resourceCanonical = relatedArtifact.getResource())) == null) continue;
            resources.putIfAbsent(lib.getId(), lib);
            queue.add(lib);
        }
    }

    public List<IBaseResource> fetchbundleEntries(List<Bundle.BundleEntryComponent> bundleList) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        for (Bundle.BundleEntryComponent drq : bundleList) {
            resources.add((IBaseResource)drq.getResource());
        }
        return resources;
    }

    private Library fetchDependencyLibrary(String resourceCanonical) {
        List bundleList;
        Library library = null;
        Canonicals.CanonicalParts parts = Canonicals.getParts((String)resourceCanonical);
        if (parts.resourceType().equals("Library") && (bundleList = ((Bundle)this.repository.search(Bundle.class, Library.class, Searches.byCanonical((String)resourceCanonical))).getEntry()) != null && !bundleList.isEmpty()) {
            if (bundleList.size() == 1) {
                library = (Library)((Bundle.BundleEntryComponent)bundleList.get(0)).getResource();
            } else {
                AdapterFactory adapterFactory = new AdapterFactory();
                LibraryVersionSelector libraryVersionSelector = new LibraryVersionSelector((IAdapterFactory)adapterFactory);
                ILibraryAdapter libAdapter = adapterFactory.createLibrary((IBaseResource)((Bundle.BundleEntryComponent)bundleList.get(0)).getResource());
                VersionedIdentifier identifier = new VersionedIdentifier();
                if (StringUtils.isNotBlank((CharSequence)libAdapter.getName())) {
                    identifier.setId(libAdapter.getName());
                }
                if (StringUtils.isNotBlank((CharSequence)parts.version())) {
                    identifier.setVersion(parts.version());
                }
                library = (Library)libraryVersionSelector.select(identifier, this.fetchbundleEntries(bundleList));
            }
        }
        return library;
    }

    public static Library getModuleDefinitionLibraryR4(Measure measureToUse, LibraryManager libraryManager, CompiledLibrary translatedLibrary, MeasureEvaluationOptions measureEvaluationOptions, SearchParameterResolver searchParameterResolver, TerminologyProvider terminologyProvider, ModelResolver modelResolver, IBaseConformance capStatement, Map<String, Object> parameters) {
        VersionConvertor_40_50 versionConvertor_40_50 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
        org.hl7.fhir.r5.model.Measure r5Measure = (org.hl7.fhir.r5.model.Measure)versionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)measureToUse);
        org.hl7.fhir.r5.model.Library effectiveDataRequirements = R4DataRequirementsService.getModuleDefinitionLibraryR5(r5Measure, libraryManager, translatedLibrary, measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlCompilerOptions(), parameters);
        Library r4EffectiveDataRequirements = (Library)versionConvertor_40_50.convertResource((Resource)effectiveDataRequirements);
        r4EffectiveDataRequirements = R4DataRequirementsService.addDataRequirementFhirQueries(r4EffectiveDataRequirements, searchParameterResolver, terminologyProvider, modelResolver, measureEvaluationOptions, capStatement);
        return r4EffectiveDataRequirements;
    }

    public static org.hl7.fhir.r5.model.Library getModuleDefinitionLibraryR5(LibraryManager libraryManager, CompiledLibrary translatedLibrary, CqlCompilerOptions options, Map<String, Object> parameters) {
        DataRequirementsProcessor dqReqTrans = new DataRequirementsProcessor();
        return dqReqTrans.gatherDataRequirements(libraryManager, translatedLibrary, options, null, parameters, true, true);
    }

    public static org.hl7.fhir.r5.model.Library getModuleDefinitionLibraryR5(org.hl7.fhir.r5.model.Measure measureToUse, LibraryManager libraryManager, CompiledLibrary translatedLibrary, CqlCompilerOptions options, Map<String, Object> parameters) {
        Set<String> expressionList = R4DataRequirementsService.getExpressions(measureToUse);
        DataRequirementsProcessor dqReqTrans = new DataRequirementsProcessor();
        return dqReqTrans.gatherDataRequirements(libraryManager, translatedLibrary, options, expressionList, parameters, true, true);
    }

    private static Set<String> getExpressions(org.hl7.fhir.r5.model.Measure measureToUse) {
        HashSet<String> expressionSet = new HashSet<String>();
        measureToUse.getSupplementalData().forEach(supData -> expressionSet.add(supData.getCriteria().getExpression()));
        measureToUse.getGroup().forEach(groupMember -> {
            groupMember.getPopulation().forEach(population -> expressionSet.add(population.getCriteria().getExpression()));
            groupMember.getStratifier().forEach(stratifier -> expressionSet.add(stratifier.getCriteria().getExpression()));
        });
        return expressionSet;
    }

    private static Library addDataRequirementFhirQueries(Library library, SearchParameterResolver searchParameterResolver, TerminologyProvider terminologyProvider, ModelResolver modelResolver, MeasureEvaluationOptions measureEvaluationOptions, IBaseConformance capStatement) {
        List dataReqs = library.getDataRequirement();
        try {
            Integer queryBatchThreshold;
            R4FhirQueryGenerator fhirQueryGenerator = new R4FhirQueryGenerator(searchParameterResolver, terminologyProvider, modelResolver);
            if (measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlEngineOptions().getPageSize() != null) {
                fhirQueryGenerator.setPageSize(measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlEngineOptions().getPageSize());
            }
            fhirQueryGenerator.setExpandValueSets(measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlEngineOptions().shouldExpandValueSets());
            Integer maxCodesPerQuery = measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlEngineOptions().getMaxCodesPerQuery();
            if (maxCodesPerQuery != null && maxCodesPerQuery > 0) {
                fhirQueryGenerator.setMaxCodesPerQuery(measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlEngineOptions().getMaxCodesPerQuery());
            }
            if ((queryBatchThreshold = measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlEngineOptions().getQueryBatchThreshold()) != null && queryBatchThreshold > 0) {
                fhirQueryGenerator.setQueryBatchThreshold(measureEvaluationOptions.getEvaluationSettings().getCqlOptions().getCqlEngineOptions().getQueryBatchThreshold());
            }
            HashMap<String, Object> contextValues = new HashMap<String, Object>();
            SubjectContext contextValue = R4DataRequirementsService.getContextForSubject(library.getSubject());
            contextValues.put(contextValue.getContextType(), contextValue.getContextValue());
            for (DataRequirement drq : dataReqs) {
                List queries = fhirQueryGenerator.generateFhirQueries((ICompositeType)drq, null, contextValues, null, capStatement);
                for (String query : queries) {
                    Extension ext = new Extension();
                    ext.setUrl(EXTENSION_URL_FHIR_QUERY_PATTERN);
                    ext.setValue((Type)new StringType(query));
                    drq.getExtension().add(ext);
                }
            }
        }
        catch (FhirVersionMisMatchException e) {
            ourLog.debug("Error attempting to generate FHIR queries: {}", (Object)e.getMessage());
        }
        return library;
    }

    private static SubjectContext getContextForSubject(Type subject) {
        String contextType = "Patient";
        if (subject instanceof CodeableConcept) {
            CodeableConcept concept = (CodeableConcept)subject;
            for (Coding c : concept.getCoding()) {
                if (!"http://hl7.org/fhir/resource-types".equals(c.getSystem())) continue;
                contextType = c.getCode();
            }
        }
        return new SubjectContext(contextType, "{{context.%sId}}".formatted(contextType.toLowerCase()));
    }
}

