/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cqframework.cql.cql2elm.CqlIncludeException;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Parameters;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.fhir.model.R4FhirModelResolver;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.VersionedIdentifiers;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureProcessorUtils;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.SubjectProvider;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureReportBuilder;
import org.opencds.cqf.fhir.cr.measure.r4.R4PopulationBasisValidator;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4DateHelper;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4MeasureServiceUtils;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;
import org.opencds.cqf.fhir.utility.search.Searches;

public class R4MeasureProcessor {
    private final IRepository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private final SubjectProvider subjectProvider;
    private final R4MeasureServiceUtils r4MeasureServiceUtils;
    private final MeasureProcessorUtils measureProcessorUtils = new MeasureProcessorUtils();

    public R4MeasureProcessor(IRepository repository, MeasureEvaluationOptions measureEvaluationOptions, SubjectProvider subjectProvider, R4MeasureServiceUtils r4MeasureServiceUtils) {
        this.repository = Objects.requireNonNull(repository);
        this.measureEvaluationOptions = measureEvaluationOptions != null ? measureEvaluationOptions : MeasureEvaluationOptions.defaultOptions();
        this.subjectProvider = subjectProvider;
        this.r4MeasureServiceUtils = r4MeasureServiceUtils;
    }

    public MeasureReport evaluateMeasure(Either3<CanonicalType, IdType, Measure> measure, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters) {
        MeasureEvalType evalType = this.r4MeasureServiceUtils.getMeasureEvalType(reportType, subjectIds);
        IRepository actualRepo = this.repository;
        if (additionalData != null) {
            actualRepo = new FederatedRepository(this.repository, new IRepository[]{new InMemoryFhirRepository(this.repository.fhirContext(), additionalData)});
        }
        List<String> subjects = this.subjectProvider.getSubjects(actualRepo, subjectIds).collect(Collectors.toList());
        return this.evaluateMeasure(measure, periodStart, periodEnd, reportType, subjects, additionalData, parameters, evalType);
    }

    public MeasureReport evaluateMeasure(Either3<CanonicalType, IdType, Measure> measure, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters, MeasureEvalType evalType) {
        Measure m = (Measure)measure.fold(this::resolveByUrl, this::resolveById, Function.identity());
        return this.evaluateMeasure(m, periodStart, periodEnd, reportType, subjectIds, additionalData, parameters, evalType);
    }

    public MeasureReport evaluateMeasureResults(Measure measure, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, @Nonnull List<String> subjectIds, @Nonnull Map<String, EvaluationResult> results) {
        this.checkMeasureLibrary(measure);
        MeasureEvalType evaluationType = this.measureProcessorUtils.getEvalType(null, reportType, subjectIds);
        Interval measurementPeriod = this.buildMeasurementPeriod(periodStart, periodEnd);
        MeasureDef measureDef = new R4MeasureDefBuilder().build(measure);
        this.measureProcessorUtils.processResults(results, measureDef, evaluationType, this.measureEvaluationOptions.getApplyScoringSetMembership(), new R4PopulationBasisValidator());
        this.continuousVariableObservationCheck(measureDef, measure);
        return new R4MeasureReportBuilder().build(measure, measureDef, this.r4EvalTypeToReportType(evaluationType, measure), measurementPeriod, subjectIds);
    }

    protected MeasureReport evaluateMeasure(Measure measure, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters, MeasureEvalType evalType) {
        this.checkMeasureLibrary(measure);
        MeasureEvalType evaluationType = this.measureProcessorUtils.getEvalType(evalType, reportType, subjectIds);
        Interval measurementPeriodParams = this.buildMeasurementPeriod(periodStart, periodEnd);
        MeasureDef measureDef = new R4MeasureDefBuilder().build(measure);
        CqlEngine context = Engines.forRepository((IRepository)this.repository, (EvaluationSettings)this.measureEvaluationOptions.getEvaluationSettings(), (IBaseBundle)additionalData);
        VersionedIdentifier libraryVersionIdentifier = this.getLibraryVersionIdentifier(measure);
        LibraryEngine libraryEngine = this.getLibraryEngine(parameters, libraryVersionIdentifier, context);
        this.measureProcessorUtils.setMeasurementPeriod(measureDef, measurementPeriodParams, context);
        Interval measurementPeriod = this.measureProcessorUtils.getDefaultMeasurementPeriod(measurementPeriodParams, context);
        ZonedDateTime zonedMeasurementPeriod = MeasureProcessorUtils.getZonedTimeZoneForEval(measurementPeriod);
        Map<String, EvaluationResult> results = this.measureProcessorUtils.getEvaluationResults(subjectIds, measureDef, zonedMeasurementPeriod, context, libraryEngine, libraryVersionIdentifier);
        this.measureProcessorUtils.processResults(results, measureDef, evaluationType, this.measureEvaluationOptions.getApplyScoringSetMembership(), new R4PopulationBasisValidator());
        this.measureProcessorUtils.continuousVariableObservation(measureDef, context);
        return new R4MeasureReportBuilder().build(measure, measureDef, this.r4EvalTypeToReportType(evaluationType, measure), measurementPeriod, subjectIds);
    }

    protected void continuousVariableObservationCheck(MeasureDef measureDef, Measure measure) {
        for (GroupDef groupDef : measureDef.groups()) {
            if (!groupDef.measureScoring().equals((Object)MeasureScoring.CONTINUOUSVARIABLE) || groupDef.getSingle(MeasurePopulationType.MEASUREOBSERVATION) == null) continue;
            throw new InvalidRequestException("Measure Evaluation Mode does not have CQL engine context to support: Measure Scoring Type: %s, Measure Population Type: %s, for Measure: %s".formatted(new Object[]{MeasureScoring.CONTINUOUSVARIABLE, MeasurePopulationType.MEASUREOBSERVATION, measure.getUrl()}));
        }
    }

    protected MeasureReportType r4EvalTypeToReportType(MeasureEvalType measureEvalType, Measure measure) {
        return switch (measureEvalType) {
            case MeasureEvalType.SUBJECT -> MeasureReportType.INDIVIDUAL;
            case MeasureEvalType.SUBJECTLIST -> MeasureReportType.SUBJECTLIST;
            case MeasureEvalType.POPULATION -> MeasureReportType.SUMMARY;
            default -> throw new InvalidRequestException("Unsupported MeasureEvalType: %s for Measure: %s".formatted(measureEvalType.toCode(), measure.getUrl()));
        };
    }

    protected VersionedIdentifier getLibraryVersionIdentifier(Measure measure) {
        String url = ((CanonicalType)measure.getLibrary().get(0)).asStringValue();
        Bundle b = (Bundle)this.repository.search(Bundle.class, Library.class, Searches.byCanonical((String)url), null);
        if (b.getEntry().isEmpty()) {
            String errorMsg = "Unable to find Library with url: %s".formatted(url);
            throw new ResourceNotFoundException(errorMsg);
        }
        return VersionedIdentifiers.forUrl((String)url);
    }

    protected LibraryEngine getLibraryEngine(Parameters parameters, VersionedIdentifier id, CqlEngine context) {
        CompiledLibrary lib;
        try {
            lib = context.getEnvironment().getLibraryManager().resolveLibrary(id);
        }
        catch (CqlIncludeException e) {
            throw new IllegalStateException("Unable to load CQL/ELM for library: %s. Verify that the Library resource is available in your environment and has CQL/ELM content embedded.".formatted(id.getId()), e);
        }
        context.getState().init(lib.getLibrary());
        this.setArgParameters(parameters, context, lib);
        return new LibraryEngine(this.repository, this.measureEvaluationOptions.getEvaluationSettings());
    }

    protected void checkMeasureLibrary(Measure measure) {
        if (!measure.hasLibrary()) {
            throw new InvalidRequestException("Measure %s does not have a primary library specified".formatted(measure.getUrl()));
        }
    }

    protected void setArgParameters(Parameters parameters, CqlEngine context, CompiledLibrary lib) {
        if (parameters != null) {
            Map<String, Object> paramMap = this.resolveParameterMap(parameters);
            context.getState().setParameters(lib.getLibrary(), paramMap);
            if (lib.getLibrary().getIncludes() != null) {
                lib.getLibrary().getIncludes().getDef().forEach(includeDef -> paramMap.forEach((paramKey, paramValue) -> context.getState().setParameter(includeDef.getLocalIdentifier(), paramKey, paramValue)));
            }
        }
    }

    protected Measure resolveByUrl(CanonicalType url) {
        Canonicals.CanonicalParts parts = Canonicals.getParts((IPrimitiveType)url);
        Bundle result = (Bundle)this.repository.search(Bundle.class, Measure.class, Searches.byNameAndVersion((String)parts.idPart(), (String)parts.version()));
        return (Measure)result.getEntryFirstRep().getResource();
    }

    protected Measure resolveById(IdType id) {
        return (Measure)this.repository.read(Measure.class, (IIdType)id);
    }

    private Map<String, Object> resolveParameterMap(Parameters parameters) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        R4FhirModelResolver modelResolver = new R4FhirModelResolver();
        parameters.getParameter().forEach(param -> {
            Object value;
            if (param.hasResource()) {
                value = param.getResource();
            } else {
                value = param.getValue();
                if (value instanceof IPrimitiveType) {
                    IPrimitiveType type = (IPrimitiveType)value;
                    value = modelResolver.toJavaPrimitive(type.getValue(), value);
                }
            }
            if (parameterMap.containsKey(param.getName())) {
                if (parameterMap.get(param.getName()) instanceof List) {
                    if (value != null) {
                        List list = (List)parameterMap.get(param.getName());
                        list.add(value);
                    }
                } else {
                    parameterMap.put(param.getName(), Arrays.asList(parameterMap.get(param.getName()), value));
                }
            } else {
                parameterMap.put(param.getName(), value);
            }
        });
        return parameterMap;
    }

    public Interval buildMeasurementPeriod(ZonedDateTime periodStart, ZonedDateTime periodEnd) {
        Interval measurementPeriod = null;
        if (periodStart != null && periodEnd != null) {
            R4DateHelper helper = new R4DateHelper();
            measurementPeriod = helper.buildMeasurementPeriodInterval(periodStart, periodEnd);
        }
        return measurementPeriod;
    }
}

