/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationBasisValidator;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierComponentDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;

public class R4PopulationBasisValidator
implements PopulationBasisValidator {
    private static final String BOOLEAN_BASIS = "boolean";
    private static final Set<Class<?>> ALLOWED_STRATIFIER_BOOLEAN_BASIS_TYPES = new HashSet<Class>(Arrays.asList(CodeableConcept.class, Quantity.class, Range.class, Reference.class, Coding.class, Enumeration.class, Boolean.class, Integer.class, String.class, Code.class));

    @Override
    public void validateGroupPopulations(MeasureDef measureDef, GroupDef groupDef, EvaluationResult evaluationResult) {
        groupDef.populations().forEach(population -> this.validateGroupPopulationBasisType(measureDef.url(), groupDef, (PopulationDef)population, evaluationResult));
    }

    @Override
    public void validateStratifiers(MeasureDef measureDef, GroupDef groupDef, EvaluationResult evaluationResult) {
        groupDef.stratifiers().forEach(stratifier -> this.validateStratifierPopulationBasisType(measureDef.url(), groupDef, (StratifierDef)stratifier, evaluationResult));
    }

    private void validateGroupPopulationBasisType(String url, GroupDef groupDef, PopulationDef populationDef, EvaluationResult evaluationResult) {
        List<Class<?>> resultMatchingClasses;
        MeasureScoring scoring = groupDef.measureScoring();
        String populationExpression = populationDef.expression();
        ExpressionResult expressionResult = evaluationResult.forExpression(populationDef.expression());
        if (expressionResult == null || expressionResult.value() == null) {
            return;
        }
        List<Class<?>> resultClasses = this.extractClassesFromSingleOrListResult(expressionResult.value());
        String groupPopulationBasisCode = groupDef.getPopulationBasis().code();
        Optional<Class<?>> optResourceClass = this.extractResourceType(groupPopulationBasisCode);
        if (optResourceClass.isPresent() && (resultMatchingClasses = resultClasses.stream().filter(it -> ((Class)optResourceClass.get()).isAssignableFrom((Class<?>)it)).toList()).size() != resultClasses.size()) {
            throw new InvalidRequestException("group expression criteria results for expression: [%s] and scoring: [%s] must fall within accepted types for population basis: [%s] for Measure: [%s] due to mismatch between total result classes: %s and matching result classes: %s".formatted(new Object[]{populationExpression, scoring, groupPopulationBasisCode, url, this.prettyClassNames(resultClasses), this.prettyClassNames(resultMatchingClasses)}));
        }
    }

    private void validateStratifierPopulationBasisType(String url, GroupDef groupDef, StratifierDef stratifierDef, EvaluationResult evaluationResult) {
        if (!stratifierDef.components().isEmpty()) {
            for (StratifierComponentDef component : stratifierDef.components()) {
                this.validateExpressionResultType(groupDef, component.expression(), evaluationResult, url);
            }
        } else {
            this.validateExpressionResultType(groupDef, stratifierDef.expression(), evaluationResult, url);
        }
    }

    private void validateExpressionResultType(GroupDef groupDef, String expression, EvaluationResult evaluationResult, String url) {
        ExpressionResult expressionResult = evaluationResult.forExpression(expression);
        if (expressionResult == null || expressionResult.value() == null) {
            return;
        }
        List<Class<?>> resultClasses = this.extractClassesFromSingleOrListResult(expressionResult.value());
        String groupPopulationBasisCode = groupDef.getPopulationBasis().code();
        List<Class<?>> resultMatchingClasses = resultClasses.stream().filter(resultClass -> ALLOWED_STRATIFIER_BOOLEAN_BASIS_TYPES.contains(resultClass) || Boolean.class == resultClass).toList();
        if (resultMatchingClasses.size() != resultClasses.size()) {
            throw new InvalidRequestException("stratifier expression criteria results for expression: [%s] must fall within accepted types for population-basis: [%s] for Measure: [%s] due to mismatch between total result classes: %s and matching result classes: %s".formatted(expression, groupPopulationBasisCode, url, this.prettyClassNames(resultClasses), this.prettyClassNames(resultMatchingClasses)));
        }
    }

    private Optional<Class<?>> extractResourceType(String groupPopulationBasisCode) {
        if (BOOLEAN_BASIS.equals(groupPopulationBasisCode)) {
            return Optional.of(Boolean.class);
        }
        Optional<String> optResourceClassName = Arrays.stream(ResourceType.values()).map(Enum::name).filter(theName -> {
            if ("ListResource".equals(groupPopulationBasisCode)) {
                return true;
            }
            return theName.equals(groupPopulationBasisCode);
        }).map(typeName -> "org.hl7.fhir.r4.model." + typeName).findFirst();
        if (optResourceClassName.isPresent()) {
            try {
                return Optional.of(Class.forName(optResourceClassName.get()));
            }
            catch (ClassNotFoundException exception) {
                throw new InternalErrorException((Throwable)exception);
            }
        }
        return Optional.empty();
    }

    private List<Class<?>> extractClassesFromSingleOrListResult(Object result) {
        if (result == null) {
            return Collections.emptyList();
        }
        if (!(result instanceof List)) {
            return Collections.singletonList(result.getClass());
        }
        List list = (List)result;
        Stream<Class> classStream = list.stream().filter(Objects::nonNull).map(Object::getClass);
        return classStream.toList();
    }

    private List<String> prettyClassNames(List<Class<?>> classes) {
        return classes.stream().map(Class::getSimpleName).toList();
    }
}

