/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.ResourceType;
import org.opencds.cqf.fhir.cr.measure.SubjectProviderOptions;
import org.opencds.cqf.fhir.cr.measure.common.SubjectProvider;
import org.opencds.cqf.fhir.utility.iterable.BundleIterator;
import org.opencds.cqf.fhir.utility.iterable.BundleMappingIterable;
import org.opencds.cqf.fhir.utility.search.Searches;

public class R4RepositorySubjectProvider
implements SubjectProvider {
    private final SubjectProviderOptions subjectProviderOptions;

    public R4RepositorySubjectProvider(SubjectProviderOptions subjectProviderOptions) {
        this.subjectProviderOptions = subjectProviderOptions;
    }

    @Override
    public Stream<String> getSubjects(IRepository repository, @Nullable String subjectId) {
        return this.getSubjects(repository, Collections.singletonList(subjectId));
    }

    @Override
    public Stream<String> getSubjects(IRepository repository, List<String> subjectIds) {
        if (subjectIds == null || subjectIds.isEmpty() || subjectIds.get(0) == null || subjectIds.get(0).isEmpty()) {
            Bundle bundle = (Bundle)repository.search(Bundle.class, Patient.class, Searches.ALL);
            return new BundleMappingIterable(repository, (IBaseBundle)bundle, x -> x.getResource().getIdElement().toUnqualifiedVersionless().getValue()).toStream();
        }
        ArrayList subjects = new ArrayList();
        subjectIds.forEach(subjectId -> {
            if (!subjectId.contains("/")) {
                subjectId = "Patient/".concat((String)subjectId);
            }
            if (subjectId.startsWith("Patient")) {
                IdType id = new IdType(subjectId);
                Patient r = (Patient)repository.read(Patient.class, (IIdType)id);
                if (r == null) {
                    throw new ResourceNotFoundException((IIdType)id);
                }
                subjects.add(r.getIdElement().toUnqualifiedVersionless().getValue());
            } else if (subjectId.startsWith("Practitioner")) {
                this.addPractitionerSubjectIds((String)subjectId, repository, subjects);
            } else if (subjectId.startsWith("Group")) {
                IdType id = new IdType(subjectId);
                Group r = (Group)repository.read(Group.class, (IIdType)id);
                if (r == null) {
                    throw new ResourceNotFoundException((IIdType)id);
                }
                if (r.getType().equals((Object)Group.GroupType.PERSON)) {
                    for (Group.GroupMemberComponent gmc : r.getMember()) {
                        IIdType ref = gmc.getEntity().getReferenceElement();
                        subjects.add(ref.getResourceType() + "/" + ref.getIdPart());
                    }
                } else if (r.getType().equals((Object)Group.GroupType.PRACTITIONER)) {
                    List<String> practitionerGroupMembers = this.getMembersInGroup(r);
                    for (String practitioner : practitionerGroupMembers) {
                        this.addPractitionerSubjectIds(practitioner, repository, subjects);
                    }
                }
            } else if (subjectId.startsWith("Organization")) {
                subjects.addAll(this.getOrganizationSubjectIds((String)subjectId, repository));
            } else {
                throw new IllegalArgumentException("Unsupported subjectId: %s".formatted(subjectIds));
            }
        });
        return subjects.stream();
    }

    private List<String> getMembersInGroup(Group group) {
        ArrayList<String> members = new ArrayList<String>();
        for (Group.GroupMemberComponent gmc : group.getMember()) {
            IIdType ref = gmc.getEntity().getReferenceElement();
            members.add(ref.getResourceType() + "/" + ref.getIdPart());
        }
        return members;
    }

    public void addPractitionerSubjectIds(String practitioner, IRepository repository, List<String> patients) {
        HashMap<String, List<ReferenceParam>> map = new HashMap<String, List<ReferenceParam>>();
        map.put("general-practitioner", Collections.singletonList(new ReferenceParam((String)(practitioner.startsWith("Practitioner/") ? practitioner : "Practitioner/" + practitioner))));
        Bundle bundle = (Bundle)repository.search(Bundle.class, Patient.class, map);
        BundleIterator iterator = new BundleIterator(repository, (IBaseBundle)bundle);
        while (iterator.hasNext()) {
            IBaseResource patient = iterator.next().getResource();
            String refString = patient.getIdElement().getResourceType() + "/" + patient.getIdElement().getIdPart();
            patients.add(refString);
        }
    }

    private List<String> getOrganizationSubjectIds(String organization, IRepository repository) {
        return Stream.concat(this.getManagingOrganizationSubjectIds(organization, repository), this.getPartOfSubjectIds(organization, repository)).collect(Collectors.toList());
    }

    private Stream<String> getManagingOrganizationSubjectIds(String organization, IRepository repository) {
        HashMap<String, List<IQueryParameterType>> searchParams = new HashMap<String, List<IQueryParameterType>>();
        searchParams.put("organization", Collections.singletonList(new ReferenceParam(organization)));
        return R4RepositorySubjectProvider.handlePatientBundle(repository, searchParams);
    }

    private Stream<String> getPartOfSubjectIds(String organization, IRepository repository) {
        if (!this.subjectProviderOptions.isPartOfEnabled()) {
            return Stream.empty();
        }
        HashMap<String, List<IQueryParameterType>> searchParam = new HashMap<String, List<IQueryParameterType>>();
        searchParam.put("organization", Collections.singletonList(new ReferenceParam("organization", organization).setChain("partof")));
        return R4RepositorySubjectProvider.handlePatientBundle(repository, searchParam);
    }

    private static Stream<String> handlePatientBundle(IRepository repository, Map<String, List<IQueryParameterType>> searchParam) {
        Bundle bundle = (Bundle)repository.search(Bundle.class, Patient.class, searchParam);
        List bundleEntries = bundle.getEntry();
        if (bundleEntries == null || bundleEntries.isEmpty()) {
            return Stream.empty();
        }
        BundleIterator iterator = new BundleIterator(repository, (IBaseBundle)bundle);
        ArrayList patientIds = new ArrayList();
        iterator.forEachRemaining(item -> {
            IBaseResource resource = item.getResource();
            IIdType idElement = resource.getIdElement();
            patientIds.add(String.valueOf(ResourceType.Patient) + "/" + idElement.getIdPart());
        });
        return patientIds.stream();
    }
}

