/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.IRequestResolverFactory;
import org.opencds.cqf.fhir.cr.common.DataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IDataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.cr.common.PackageProcessor;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.IApplyProcessor;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class PlanDefinitionProcessor {
    protected final ModelResolver modelResolver;
    protected final FhirVersionEnum fhirVersion;
    protected IApplyProcessor applyProcessor;
    protected IPackageProcessor packageProcessor;
    protected IDataRequirementsProcessor dataRequirementsProcessor;
    protected org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor;
    protected IRequestResolverFactory requestResolverFactory;
    protected IRepository repository;
    protected EvaluationSettings evaluationSettings;

    public PlanDefinitionProcessor(IRepository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public PlanDefinitionProcessor(IRepository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null, null, null, null, null);
    }

    public PlanDefinitionProcessor(IRepository repository, EvaluationSettings evaluationSettings, IApplyProcessor applyProcessor, IPackageProcessor packageProcessor, IDataRequirementsProcessor dataRequirementsProcessor, org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor, IRequestResolverFactory requestResolverFactory) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.packageProcessor = packageProcessor;
        this.dataRequirementsProcessor = dataRequirementsProcessor;
        this.requestResolverFactory = requestResolverFactory;
        this.activityProcessor = activityProcessor;
        this.applyProcessor = applyProcessor;
    }

    public EvaluationSettings evaluationSettings() {
        return this.evaluationSettings;
    }

    protected void initApplyProcessor() {
        if (this.activityProcessor == null) {
            this.activityProcessor = new org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyProcessor(this.repository, this.requestResolverFactory != null ? this.requestResolverFactory : IRequestResolverFactory.getDefault(this.fhirVersion));
        }
        this.applyProcessor = this.applyProcessor != null ? this.applyProcessor : new ApplyProcessor(this.repository, this.modelResolver, this.activityProcessor);
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R resolvePlanDefinition(Either3<C, IIdType, R> planDefinition) {
        return new ResourceResolver("PlanDefinition", this.repository).resolve(planDefinition);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packagePlanDefinition(Either3<C, IIdType, R> planDefinition) {
        return this.packagePlanDefinition(planDefinition, false);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packagePlanDefinition(Either3<C, IIdType, R> planDefinition, boolean isPut) {
        return this.packagePlanDefinition(planDefinition, PackageHelper.packageParameters((FhirVersionEnum)this.fhirVersion, null, (boolean)isPut));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packagePlanDefinition(Either3<C, IIdType, R> planDefinition, IBaseParameters parameters) {
        return this.packagePlanDefinition((IBaseResource)this.resolvePlanDefinition(planDefinition), parameters);
    }

    public IBaseBundle packagePlanDefinition(IBaseResource planDefinition, IBaseParameters parameters) {
        IPackageProcessor processor = this.packageProcessor != null ? this.packageProcessor : new PackageProcessor(this.repository);
        return processor.packageResource(planDefinition, parameters);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource dataRequirements(Either3<C, IIdType, R> planDefinition, IBaseParameters parameters) {
        return this.dataRequirements((IBaseResource)this.resolvePlanDefinition(planDefinition), parameters);
    }

    public IBaseResource dataRequirements(IBaseResource planDefinition, IBaseParameters parameters) {
        IDataRequirementsProcessor processor = this.dataRequirementsProcessor != null ? this.dataRequirementsProcessor : new DataRequirementsProcessor(this.repository, this.evaluationSettings);
        return processor.getDataRequirements(planDefinition, parameters);
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> ApplyRequest buildApplyRequest(@Nonnull Either3<C, IIdType, R> planDefinition, @Nonnull String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine) {
        if (StringUtils.isBlank((CharSequence)subject)) {
            throw new IllegalArgumentException("Missing required parameter: 'subject'");
        }
        return new ApplyRequest((IBaseResource)this.resolvePlanDefinition(planDefinition), Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)subject, (String)"Patient")), encounter == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)encounter, (String)"Encounter")), practitioner == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)practitioner, (String)"Practitioner")), organization == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)organization, (String)"Organization")), userType, userLanguage, userTaskContext, setting, settingContext, parameters, data, prefetchData, libraryEngine, this.modelResolver, null);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext) {
        return this.apply(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, null, null, null, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.apply(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, data, prefetchData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, IRepository dataRepository, IRepository contentRepository, IRepository terminologyRepository) {
        this.repository = Repositories.proxy((IRepository)this.repository, (Boolean)useServerData, (IRepository)dataRepository, (IRepository)contentRepository, (IRepository)terminologyRepository);
        return this.apply(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, data, prefetchData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine) {
        if (this.fhirVersion == FhirVersionEnum.R5) {
            return this.applyR5(planDefinition, List.of(subject), encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, data, prefetchData, libraryEngine);
        }
        return this.apply(this.buildApplyRequest(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, data, prefetchData, libraryEngine));
    }

    public IBaseResource apply(ApplyRequest request) {
        this.initApplyProcessor();
        return this.applyProcessor.apply(request);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseParameters applyR5(Either3<C, IIdType, R> planDefinition, List<String> subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.applyR5(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, data, prefetchData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseParameters applyR5(Either3<C, IIdType, R> planDefinition, List<String> subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, IRepository dataRepository, IRepository contentRepository, IRepository terminologyRepository) {
        this.repository = Repositories.proxy((IRepository)this.repository, (Boolean)useServerData, (IRepository)dataRepository, (IRepository)contentRepository, (IRepository)terminologyRepository);
        return this.applyR5(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, data, prefetchData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseParameters applyR5(Either3<C, IIdType, R> planDefinition, List<String> subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine) {
        IParametersAdapter param = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion).createParameters((IBaseParameters)Resources.newBaseForVersion((String)"Parameters", (FhirVersionEnum)this.fhirVersion));
        subject.forEach(s -> param.addParameter("return", (IBaseResource)this.applyR5(this.buildApplyRequest(planDefinition, (String)s, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, data, prefetchData, libraryEngine))));
        return (IBaseParameters)param.get();
    }

    public IBaseBundle applyR5(ApplyRequest request) {
        this.initApplyProcessor();
        return this.applyProcessor.applyR5(request);
    }
}

